/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.collect.BiMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.service.enhancer.impl.util.VarScopeUtils;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class OpServiceInfo {
    protected OpService opService;
    protected Node serviceNode;
    protected Var serviceVar;
    protected BiMap<Var, Var> mentionedSubOpVarsScopedToNormed;
    protected Query normedQuery;
    protected Op normedQueryOp;
    protected long limit;
    protected long offset;
    protected BiMap<Var, Var> visibleSubOpVarsScopedToNorm;

    public OpServiceInfo(OpService opService) {
        this.opService = opService;
        this.serviceNode = opService.getService();
        this.serviceVar = this.serviceNode.isVariable() ? (Var)this.serviceNode : null;
        Op baseSubOp = opService.getSubOp();
        if (baseSubOp instanceof OpSlice) {
            OpSlice slice = (OpSlice)baseSubOp;
            baseSubOp = slice.getSubOp();
            this.offset = slice.getStart();
            this.limit = slice.getLength();
        } else {
            this.limit = Long.MIN_VALUE;
            this.offset = Long.MIN_VALUE;
        }
        Collection mentionedSubOpVars = OpVars.mentionedVars((Op)baseSubOp);
        this.mentionedSubOpVarsScopedToNormed = VarScopeUtils.normalizeVarScopes(mentionedSubOpVars);
        this.normedQueryOp = NodeTransformLib.transform((NodeTransform)new NodeTransformSubst(this.mentionedSubOpVarsScopedToNormed), (Op)baseSubOp);
        Set visibleSubOpVars = OpVars.visibleVars((Op)baseSubOp);
        this.visibleSubOpVarsScopedToNorm = VarScopeUtils.normalizeVarScopes(visibleSubOpVars);
        this.normedQuery = OpAsQuery.asQuery((Op)this.normedQueryOp);
        VarExprList vel = this.normedQuery.getProject();
        VarExprList newVel = new VarExprList();
        int allocId = 0;
        for (Var var : vel.getVars()) {
            Expr expr = vel.getExpr(var);
            if (Var.isAllocVar((Node)var)) {
                Var tmp = Var.alloc((String)("__av" + ++allocId + "__"));
                this.mentionedSubOpVarsScopedToNormed.put((Object)var, (Object)tmp);
                this.visibleSubOpVarsScopedToNorm.put((Object)tmp, (Object)tmp);
                var = tmp;
            }
            newVel.add(var, expr);
        }
        vel.clear();
        vel.addAll(newVel);
    }

    public OpService getOpService() {
        return this.opService;
    }

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public Node getSubstServiceNode(Binding binding) {
        Node result = this.serviceVar == null ? this.serviceNode : binding.get(this.serviceVar);
        return result;
    }

    public Var getServiceVar() {
        return this.serviceVar;
    }

    public Query getNormedQuery() {
        return this.normedQuery;
    }

    public Op getNormedQueryOp() {
        return this.normedQueryOp;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public Set<Var> getVisibleSubOpVarsScoped() {
        return this.visibleSubOpVarsScopedToNorm.keySet();
    }

    public Map<Var, Var> getMentionedSubOpVarsScopedToNormed() {
        return this.mentionedSubOpVarsScopedToNormed;
    }

    public Map<Var, Var> getVisibleSubOpVarsNormedToScoped() {
        return this.visibleSubOpVarsScopedToNorm.inverse();
    }
}

