/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.service.bulk.ServiceExecutorBulk;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceExecutor;

public class OpServiceExecutorImpl
implements OpServiceExecutor {
    protected OpService originalOp;
    protected ExecutionContext execCxt;
    protected ServiceExecutorBulk delegate;

    public OpServiceExecutorImpl(OpService opService, ExecutionContext execCxt, ServiceExecutorBulk delegate) {
        this.originalOp = opService;
        this.execCxt = execCxt;
        this.delegate = delegate;
    }

    public ExecutionContext getExecCxt() {
        return this.execCxt;
    }

    @Override
    public QueryIterator exec(OpService substitutedOp) {
        QueryIterator result2;
        Binding input = BindingFactory.binding();
        boolean silent = this.originalOp.getSilent();
        try {
            QueryIterSingleton singleton = QueryIterSingleton.create((Binding)BindingFactory.root(), (ExecutionContext)this.execCxt);
            result2 = this.delegate.createExecution(substitutedOp, (QueryIterator)singleton, this.execCxt);
            if (result2 == null) {
                throw new QueryExecException("No SERVICE handler");
            }
            result2 = QueryIter.makeTracked((QueryIterator)result2, (ExecutionContext)this.execCxt);
        }
        catch (RuntimeException ex) {
            if (silent) {
                Log.warn((Object)this, (String)("SERVICE " + NodeFmtLib.strTTL((Node)substitutedOp.getService()) + " : " + ex.getMessage()));
                QueryIterSingleton result2 = QueryIterSingleton.create((Binding)input, (ExecutionContext)this.execCxt);
            }
            throw ex;
        }
        return result2;
    }
}

