/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.SortedSet;
import java.util.stream.IntStream;
import org.apache.jena.sparql.service.enhancer.impl.util.SinglePrefetchIterator;

public class IteratorFactoryWithBuffer<T, I extends Iterator<T>> {
    protected final Object lock = new Object();
    protected I delegate;
    protected List<T> buffer = null;
    protected long absBufferOffset = 0L;
    protected SetMultimap<Long, Iterator<T>> offsetToChild = MultimapBuilder.treeKeys().hashSetValues().build();

    public IteratorFactoryWithBuffer(I delegate) {
        this.delegate = delegate;
    }

    public static <T, I extends Iterator<T>> SubIterator<T, I> wrap(I delegate) {
        SubIterator<T, I> result = new IteratorFactoryWithBuffer<T, I>(delegate).createSubIterator(false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubIterator<T, I> createSubIterator(long offset) {
        SubIteratorImpl result;
        Object object = this.lock;
        synchronized (object) {
            result = new SubIteratorImpl(offset);
            this.offsetToChild.put((Object)offset, (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubIterator<T, I> createSubIterator(boolean startAtUnbuffered) {
        SubIterator<T, I> result;
        Object object = this.lock;
        synchronized (object) {
            long offset = this.absBufferOffset;
            if (this.buffer != null && startAtUnbuffered) {
                offset += (long)this.buffer.size();
            }
            result = this.createSubIterator(offset);
        }
        return result;
    }

    protected void checkShrink() {
    }

    public static void main(String[] args) {
        PrimitiveIterator.OfInt base = IntStream.range(0, 5).iterator();
        IteratorFactoryWithBuffer factory = new IteratorFactoryWithBuffer(base);
        try (SubIterator primary = factory.createSubIterator(false);){
            for (int i = 0; i < 2; ++i) {
                System.out.println("primary: " + String.valueOf(primary.next()));
            }
            try (SubIterator secondary = primary.createSubIterator(false);){
                for (int i = 0; i < 2; ++i) {
                    System.out.println("secondary: " + String.valueOf(secondary.next()));
                }
                try (SubIterator ternary = secondary.createSubIterator(false);){
                    while (ternary.hasNext()) {
                        System.out.println("ternary: " + String.valueOf(ternary.next()));
                    }
                    while (primary.hasNext()) {
                        System.out.println("primary: " + String.valueOf(primary.next()));
                    }
                    while (secondary.hasNext()) {
                        System.out.println("secondary: " + String.valueOf(secondary.next()));
                    }
                    System.out.println(primary.getOffset());
                    System.out.println(secondary.getOffset());
                    System.out.println(ternary.getOffset());
                }
            }
        }
    }

    public static interface SubIterator<T, I extends Iterator<T>>
    extends PeekingIterator<T>,
    AutoCloseable {
        public I getDelegate();

        public long getOffset();

        public long getDistanceToLowestOffset();

        @Override
        public void close();

        public SubIterator<T, I> createSubIterator(boolean var1);

        default public SubIterator<T, I> subIteratorAtStartOfBuffer() {
            return this.createSubIterator(false);
        }

        default public SubIterator<T, I> subIteratorAtEndOfBuffer() {
            return this.createSubIterator(true);
        }
    }

    protected class SubIteratorImpl
    extends SinglePrefetchIterator<T>
    implements SubIterator<T, I> {
        protected long absOffset;

        @Override
        public I getDelegate() {
            return IteratorFactoryWithBuffer.this.delegate;
        }

        public SubIteratorImpl(long absOffset) {
            this.absOffset = absOffset;
        }

        @Override
        public SubIterator<T, I> createSubIterator(boolean startAtUnbuffered) {
            SubIterator result = this.isOpen() ? (startAtUnbuffered ? IteratorFactoryWithBuffer.this.createSubIterator(startAtUnbuffered) : IteratorFactoryWithBuffer.this.createSubIterator(this.absOffset)) : new SubIteratorImpl(this.absOffset);
            return result;
        }

        @Override
        public long getOffset() {
            long d = this.wasHasNextCalled() ? 1L : 0L;
            return this.absOffset - d;
        }

        protected boolean isOpen() {
            return IteratorFactoryWithBuffer.this.offsetToChild.containsEntry((Object)this.absOffset, (Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected T prefetch() {
            boolean isEndOfData = false;
            Object result = null;
            Object object = IteratorFactoryWithBuffer.this.lock;
            synchronized (object) {
                long bufferSize;
                if (!this.isOpen()) {
                    return this.finish();
                }
                if (this.absOffset < IteratorFactoryWithBuffer.this.absBufferOffset) {
                    throw new IllegalStateException();
                }
                int relOffset = Math.toIntExact(this.absOffset - IteratorFactoryWithBuffer.this.absBufferOffset);
                long l = bufferSize = IteratorFactoryWithBuffer.this.buffer == null ? 0L : (long)IteratorFactoryWithBuffer.this.buffer.size();
                if ((long)relOffset < bufferSize) {
                    result = IteratorFactoryWithBuffer.this.buffer.get(relOffset);
                    ++this.absOffset;
                } else if ((long)relOffset == bufferSize) {
                    if (IteratorFactoryWithBuffer.this.delegate.hasNext()) {
                        result = IteratorFactoryWithBuffer.this.delegate.next();
                        if (IteratorFactoryWithBuffer.this.offsetToChild.size() > 1) {
                            if (IteratorFactoryWithBuffer.this.buffer == null) {
                                IteratorFactoryWithBuffer.this.buffer = new ArrayList();
                                IteratorFactoryWithBuffer.this.absBufferOffset = this.absOffset;
                            }
                            IteratorFactoryWithBuffer.this.buffer.add(result);
                        } else {
                            IteratorFactoryWithBuffer.this.buffer = null;
                        }
                        ++this.absOffset;
                    } else {
                        isEndOfData = true;
                    }
                } else {
                    isEndOfData = true;
                }
                if (isEndOfData) {
                    result = this.finish();
                    this.close();
                } else {
                    IteratorFactoryWithBuffer.this.offsetToChild.remove((Object)(this.absOffset - 1L), (Object)this);
                    IteratorFactoryWithBuffer.this.offsetToChild.put((Object)this.absOffset, (Object)this);
                    if (IteratorFactoryWithBuffer.this.buffer == null) {
                        IteratorFactoryWithBuffer.this.absBufferOffset = this.absOffset;
                    }
                    IteratorFactoryWithBuffer.this.checkShrink();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = IteratorFactoryWithBuffer.this.lock;
            synchronized (object) {
                IteratorFactoryWithBuffer.this.offsetToChild.remove((Object)this.absOffset, (Object)this);
                IteratorFactoryWithBuffer.this.checkShrink();
            }
        }

        @Override
        public long getDistanceToLowestOffset() {
            SortedSet keys = (SortedSet)IteratorFactoryWithBuffer.this.offsetToChild.asMap().keySet();
            long first = keys.isEmpty() ? this.absOffset : (Long)keys.first();
            long result = this.absOffset - first;
            return result;
        }

        public T peek() {
            return this.current();
        }
    }
}

