/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.service.bulk.ChainingServiceExecutorBulk;
import org.apache.jena.sparql.service.bulk.ServiceExecutorBulk;
import org.apache.jena.sparql.service.enhancer.impl.CacheMode;
import org.apache.jena.sparql.service.enhancer.impl.ChainingServiceExecutorBulkCache;
import org.apache.jena.sparql.service.enhancer.impl.ServiceOpts;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.util.Context;

public class ChainingServiceExecutorBulkServiceEnhancer
implements ChainingServiceExecutorBulk {
    public QueryIterator createExecution(OpService opService, QueryIterator input, ExecutionContext execCxt, ServiceExecutorBulk chain) {
        QueryIterator result;
        CacheMode effCacheMode;
        boolean enableSpecial;
        int i;
        Node node = opService.getService();
        List<Map.Entry<String, String>> opts = ServiceOpts.parseAsOptions(node);
        boolean enableBulk = false;
        int bulkSize = 1;
        CacheMode cacheMode = null;
        Context cxt = execCxt.getContext();
        int n = opts.size();
        block20: for (i = 0; i < n; ++i) {
            Map.Entry<String, String> opt = opts.get(i);
            String key = opt.getKey();
            String val = opt.getValue();
            switch (key) {
                case "loop": {
                    continue block20;
                }
                case "cache": {
                    String v;
                    switch (v = val == null ? "" : val.toLowerCase()) {
                        case "off": {
                            cacheMode = CacheMode.OFF;
                            continue block20;
                        }
                        case "clear": {
                            cacheMode = CacheMode.CLEAR;
                            continue block20;
                        }
                    }
                    cacheMode = CacheMode.DEFAULT;
                    continue block20;
                }
                case "bulk": {
                    enableBulk = true;
                    int maxBulkSize = (Integer)cxt.get(ServiceEnhancerConstants.serviceBulkMaxBindingCount, (Object)100);
                    bulkSize = (Integer)cxt.get(ServiceEnhancerConstants.serviceBulkBindingCount, (Object)30);
                    try {
                        if (val != null && !val.isBlank()) {
                            bulkSize = Integer.parseInt(val);
                        }
                    }
                    catch (Exception e) {
                        throw new QueryExecException("Failed to configure bulk size", (Throwable)e);
                    }
                    bulkSize = Math.max(Math.min(bulkSize, maxBulkSize), 1);
                    continue block20;
                }
            }
        }
        List<Map.Entry<String, String>> subList = opts.subList(i, n);
        String serviceStr = ServiceOpts.unparse(subList);
        OpService newOp = null;
        if (serviceStr.isEmpty()) {
            Op subOp = opService.getSubOp();
            if (subOp instanceof OpService) {
                newOp = (OpService)subOp;
            } else {
                serviceStr = ServiceEnhancerConstants.SELF.getURI();
            }
        }
        if (newOp == null) {
            node = NodeFactory.createURI((String)serviceStr);
            newOp = new OpService(node, opService.getSubOp(), opService.getSilent());
        }
        boolean bl = enableSpecial = (effCacheMode = CacheMode.effectiveMode(cacheMode)) != CacheMode.OFF || enableBulk;
        if (enableSpecial) {
            ChainingServiceExecutorBulkCache exec = new ChainingServiceExecutorBulkCache(bulkSize, effCacheMode);
            result = exec.createExecution(newOp, input, execCxt, chain);
        } else {
            result = chain.createExecution(newOp, input, execCxt);
        }
        return result;
    }
}

