/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import java.util.Optional;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.service.bulk.ChainingServiceExecutorBulk;
import org.apache.jena.sparql.service.bulk.ServiceExecutorBulk;
import org.apache.jena.sparql.service.enhancer.impl.Batcher;
import org.apache.jena.sparql.service.enhancer.impl.CacheMode;
import org.apache.jena.sparql.service.enhancer.impl.GroupedBatch;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceExecutorImpl;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceInfo;
import org.apache.jena.sparql.service.enhancer.impl.RequestExecutor;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResultSizeCache;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.util.Context;

public class ChainingServiceExecutorBulkCache
implements ChainingServiceExecutorBulk {
    public static final int DFT_BULK_SIZE = 30;
    public static final int DFT_MAX_BULK_SIZE = 100;
    public static final int DFT_MAX_OUT_OUF_BAND_SIZE = 30;
    protected int bulkSize;
    protected CacheMode cacheMode;

    public ChainingServiceExecutorBulkCache(int bulkSize, CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        this.bulkSize = bulkSize;
    }

    public QueryIterator createExecution(OpService original, QueryIterator input, ExecutionContext execCxt, ServiceExecutorBulk chain) {
        Context cxt = execCxt.getContext();
        ServiceResponseCache serviceCache = CacheMode.OFF.equals((Object)this.cacheMode) ? null : ServiceResponseCache.get(cxt);
        OpServiceInfo serviceInfo = new OpServiceInfo(original);
        ServiceResultSizeCache resultSizeCache = Optional.ofNullable((ServiceResultSizeCache)cxt.get(ServiceEnhancerConstants.serviceResultSizeCache)).orElseGet(ServiceResultSizeCache::new);
        OpServiceExecutorImpl opExecutor = new OpServiceExecutorImpl(serviceInfo.getOpService(), execCxt, chain);
        int maxOutOfBandItemCount = cxt.getInt(ServiceEnhancerConstants.serviceBulkMaxOutOfBandBindingCount, 30);
        Batcher<Node, Binding> scheduler = new Batcher<Node, Binding>(serviceInfo::getSubstServiceNode, this.bulkSize, maxOutOfBandItemCount);
        IteratorCloseable<GroupedBatch<Node, Long, Binding>> inputBatchIterator = scheduler.batch((IteratorCloseable<Binding>)input);
        RequestExecutor exec = new RequestExecutor(opExecutor, serviceInfo, resultSizeCache, serviceCache, this.cacheMode, inputBatchIterator);
        return exec;
    }
}

