/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.collect.AbstractIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.sparql.service.enhancer.impl.Batch;
import org.apache.jena.sparql.service.enhancer.impl.BatchImpl;
import org.apache.jena.sparql.service.enhancer.impl.GroupedBatch;
import org.apache.jena.sparql.service.enhancer.impl.GroupedBatchImpl;

public class Batcher<G, I> {
    protected int maxBulkSize;
    protected int maxOutOfBandItemCount;
    protected Function<I, G> itemToGroupKey;

    public Batcher(Function<I, G> itemToGroupKey, int maxBulkSize, int maxOutOfBandItemCount) {
        this.itemToGroupKey = itemToGroupKey;
        this.maxBulkSize = maxBulkSize;
        this.maxOutOfBandItemCount = maxOutOfBandItemCount;
    }

    public IteratorCloseable<GroupedBatch<G, Long, I>> batch(IteratorCloseable<I> inputIterator) {
        return new IteratorGroupedBatch(inputIterator);
    }

    class IteratorGroupedBatch
    extends AbstractIterator<GroupedBatch<G, Long, I>>
    implements IteratorCloseable<GroupedBatch<G, Long, I>> {
        protected IteratorCloseable<I> inputIterator;
        protected long inputIteratorOffset;
        protected NavigableMap<Long, G> nextGroup = new TreeMap();
        protected Map<G, NavigableMap<Long, Batch<Long, I>>> groupToBatches = new HashMap();

        public IteratorGroupedBatch(IteratorCloseable<I> inputIterator) {
            this(inputIterator, 0);
        }

        public IteratorGroupedBatch(IteratorCloseable<I> inputIterator, int inputIteratorOffset) {
            this.inputIterator = inputIterator;
            this.inputIteratorOffset = inputIteratorOffset;
        }

        protected GroupedBatch<G, Long, I> computeNext() {
            GroupedBatchImpl result;
            Iterator nextGroupIt;
            Optional<Object> resultGroupKeyOpt = Optional.ofNullable(this.nextGroup.firstEntry()).map(Map.Entry::getValue);
            Object resultGroupKey = resultGroupKeyOpt.orElse(null);
            Optional<Map.Entry> resultBatchEntry = resultGroupKeyOpt.map(this.groupToBatches::get).map(offsetToBatch -> offsetToBatch.firstEntry());
            long resultBatchMinOffset = resultBatchEntry.map(Map.Entry::getKey).orElse(this.inputIteratorOffset);
            Optional<Batch> resultBatch = resultBatchEntry.map(Map.Entry::getValue);
            long resultBatchMaxOffset = resultBatch.map(Batch::getNextValidIndex).orElse(this.inputIteratorOffset);
            int resultBatchSize = resultBatch.map(Batch::getItems).map(Map::size).orElse(0);
            long outOfBandItemCountInResultBatch = resultBatchMaxOffset - resultBatchMinOffset - (long)resultBatchSize;
            long outOfBandItemCountInOtherBatches = this.inputIteratorOffset - resultBatchMaxOffset;
            long outOfBandItemCount = outOfBandItemCountInResultBatch + outOfBandItemCountInOtherBatches;
            Object previousGroupKey = null;
            Batch<Long, Object> currentBatch = null;
            NavigableMap currentBatches = null;
            int currentBatchSize = -1;
            if (resultBatchSize < Batcher.this.maxBulkSize) {
                while (this.inputIterator.hasNext() && outOfBandItemCount <= (long)Batcher.this.maxOutOfBandItemCount) {
                    Batch<Long, Object> insertTargetBatch;
                    Object input = this.inputIterator.next();
                    Object currentGroupKey = Batcher.this.itemToGroupKey.apply(input);
                    Objects.requireNonNull(currentGroupKey);
                    if (!Objects.equals(currentGroupKey, previousGroupKey)) {
                        previousGroupKey = currentGroupKey;
                        currentBatches = this.groupToBatches.computeIfAbsent(currentGroupKey, x -> new TreeMap());
                        if (currentBatches.isEmpty()) {
                            currentBatch = BatchImpl.forLong();
                            currentBatches.put(this.inputIteratorOffset, currentBatch);
                            this.nextGroup.put(this.inputIteratorOffset, currentGroupKey);
                        } else {
                            currentBatch = (Batch<Long, Object>)currentBatches.lastEntry().getValue();
                        }
                        currentBatchSize = currentBatch.size();
                        if (resultGroupKey == null) {
                            resultGroupKey = currentGroupKey;
                        }
                    }
                    if (currentBatchSize >= Batcher.this.maxBulkSize) {
                        insertTargetBatch = BatchImpl.forLong();
                        currentBatches.put(this.inputIteratorOffset, insertTargetBatch);
                        this.nextGroup.put(this.inputIteratorOffset, currentGroupKey);
                    } else {
                        insertTargetBatch = currentBatch;
                        ++currentBatchSize;
                    }
                    insertTargetBatch.put(this.inputIteratorOffset, input);
                    ++this.inputIteratorOffset;
                    if (currentGroupKey.equals(resultGroupKey)) {
                        if (currentBatchSize >= Batcher.this.maxBulkSize) {
                            break;
                        }
                    } else {
                        ++outOfBandItemCount;
                    }
                    if (insertTargetBatch == currentBatch) continue;
                    currentBatch = insertTargetBatch;
                    currentBatchSize = insertTargetBatch.size();
                }
            }
            if ((nextGroupIt = this.nextGroup.entrySet().iterator()).hasNext()) {
                Map.Entry e = nextGroupIt.next();
                resultGroupKey = e.getValue();
                nextGroupIt.remove();
                NavigableMap nextBatches = this.groupToBatches.get(resultGroupKey);
                Iterator nextBatchesIt = nextBatches.values().iterator();
                Batch resultBatchTmp = (Batch)nextBatchesIt.next();
                nextBatchesIt.remove();
                result = new GroupedBatchImpl(resultGroupKey, resultBatchTmp);
            } else {
                result = (GroupedBatchImpl)this.endOfData();
            }
            return result;
        }

        public void close() {
            Iter.close(this.inputIterator);
        }
    }
}

