/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.service.enhancer.impl.BatchQueryRewriter;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceInfo;

public class BatchQueryRewriterBuilder {
    protected OpServiceInfo serviceInfo;
    protected Var idxVar;
    protected boolean sequentialUnion;
    protected boolean orderRetainingUnion;
    protected boolean omitEndMarker;

    public BatchQueryRewriterBuilder(OpServiceInfo serviceInfo, Var idxVar) {
        this.serviceInfo = serviceInfo;
        this.idxVar = idxVar;
    }

    public boolean isSequentialUnion() {
        return this.sequentialUnion;
    }

    public BatchQueryRewriterBuilder setSequentialUnion(boolean linearUnion) {
        this.sequentialUnion = linearUnion;
        return this;
    }

    public boolean isOrderRetainingUnion() {
        return this.orderRetainingUnion;
    }

    public BatchQueryRewriterBuilder setOrderRetainingUnion(boolean orderRetainingUnion) {
        this.orderRetainingUnion = orderRetainingUnion;
        return this;
    }

    public boolean isOmitEndMarker() {
        return this.omitEndMarker;
    }

    public BatchQueryRewriterBuilder setOmitEndMarker(boolean omitEndMarker) {
        this.omitEndMarker = omitEndMarker;
        return this;
    }

    public static BatchQueryRewriterBuilder from(OpServiceInfo serviceInfo, Var idxVar) {
        return new BatchQueryRewriterBuilder(serviceInfo, idxVar);
    }

    public BatchQueryRewriter build() {
        return new BatchQueryRewriter(this.serviceInfo, this.idxVar, this.sequentialUnion, this.orderRetainingUnion, this.omitEndMarker);
    }
}

