/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpLib;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.service.enhancer.impl.Batch;
import org.apache.jena.sparql.service.enhancer.impl.BatchQueryRewriteResult;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceInfo;
import org.apache.jena.sparql.service.enhancer.impl.PartitionRequest;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKeyFactory;
import org.apache.jena.sparql.service.enhancer.impl.util.BindingUtils;

public class BatchQueryRewriter {
    protected OpServiceInfo serviceInfo;
    protected Var idxVar;
    protected boolean sequentialUnion;
    protected boolean orderRetainingUnion;
    protected boolean omitEndMarker;
    static int REMOTE_END_MARKER = 1000000000;
    static NodeValue NV_REMOTE_END_MARKER = NodeValue.makeInteger((long)REMOTE_END_MARKER);

    public static boolean isRemoteEndMarker(int id) {
        return id == REMOTE_END_MARKER;
    }

    public static boolean isRemoteEndMarker(Integer id) {
        return Objects.equals(id, REMOTE_END_MARKER);
    }

    public BatchQueryRewriter(OpServiceInfo serviceInfo, Var idxVar, boolean sequentialUnion, boolean orderRetainingUnion, boolean omitEndMarker) {
        this.serviceInfo = serviceInfo;
        this.idxVar = idxVar;
        this.sequentialUnion = sequentialUnion;
        this.orderRetainingUnion = orderRetainingUnion;
        this.omitEndMarker = omitEndMarker;
    }

    public Var getIdxVar() {
        return this.idxVar;
    }

    public static Set<Var> seenVars(Collection<PartitionRequest<Binding>> batchRequest) {
        LinkedHashSet<Var> result = new LinkedHashSet<Var>();
        batchRequest.forEach(br -> BindingUtils.addAll(result, (Binding)br.getPartitionKey()));
        return result;
    }

    public BatchQueryRewriteResult rewrite(Batch<Integer, PartitionRequest<Binding>> batchRequest) {
        boolean orderNeeded;
        Op newOp = null;
        ArrayList es = new ArrayList(batchRequest.getItems().entrySet());
        Collections.reverse(es);
        Query normedQuery = this.serviceInfo.getNormedQuery();
        Op normedOp = this.serviceInfo.getNormedQueryOp();
        ArrayList<Object> sortConditions = new ArrayList<Object>();
        List localSortConditions = Optional.ofNullable(normedQuery.getOrderBy()).orElse(Collections.emptyList());
        boolean noOrderNeeded = this.orderRetainingUnion || this.sequentialUnion && localSortConditions.isEmpty();
        boolean bl = orderNeeded = !noOrderNeeded;
        if (orderNeeded) {
            SortCondition sc = new SortCondition((Expr)new ExprVar(this.idxVar), 1);
            sortConditions.add(sc);
        }
        sortConditions.addAll(localSortConditions);
        if (!this.omitEndMarker) {
            Op endMarker = OpExtend.create((Op)OpLib.unit(), (Var)this.idxVar, (Expr)NV_REMOTE_END_MARKER);
            newOp = newOp == null ? endMarker : OpUnion.create((Op)newOp, (Op)endMarker);
        }
        for (Map.Entry entry : es) {
            long l;
            PartitionRequest req = (PartitionRequest)entry.getValue();
            long idx = ((Integer)entry.getKey()).intValue();
            Binding scopedBinding = (Binding)req.getPartitionKey();
            Set<Var> scopedBindingVars = BindingUtils.varsMentioned(scopedBinding);
            Map<Var, Var> varMapScopedToNormed = ServiceCacheKeyFactory.createJoinVarMapScopedToNormed(this.serviceInfo, scopedBindingVars);
            Binding normedBinding = BindingUtils.renameKeys(scopedBinding, varMapScopedToNormed);
            Op op = normedOp;
            op = QC.substitute((Op)op, (Binding)normedBinding);
            op = NodeTransformLib.transform(node -> BatchQueryRewriter.relabelBnode(node, idx), (Op)op);
            long o = req.hasOffset() ? req.getOffset() : Long.MIN_VALUE;
            long l2 = l = req.hasLimit() ? req.getLimit() : Long.MIN_VALUE;
            if (o != Long.MIN_VALUE || l != Long.MIN_VALUE) {
                op = new OpSlice(op, o, l);
            }
            op = OpExtend.create((Op)op, (Var)this.idxVar, (Expr)NodeValue.makeInteger((long)idx));
            newOp = newOp == null ? op : OpUnion.create((Op)op, (Op)newOp);
        }
        if (orderNeeded) {
            newOp = new OpOrder(newOp, sortConditions);
        }
        Query q = OpAsQuery.asQuery(newOp);
        Log.info(BatchQueryRewriter.class, (String)("Rewritten bulk query: " + String.valueOf(q)));
        HashMap<Var, Var> hashMap = new HashMap<Var, Var>(this.serviceInfo.getVisibleSubOpVarsNormedToScoped());
        hashMap.put(this.idxVar, this.idxVar);
        return new BatchQueryRewriteResult(newOp, hashMap);
    }

    private static Node relabelBnode(Node node, long idx) {
        return Var.isBlankNodeVar((Node)node) ? Var.alloc((String)(node.getName() + "_" + idx)) : (node.isBlank() ? NodeFactory.createBlankNode((String)(node.getBlankNodeLabel() + "_" + idx)) : node);
    }
}

