/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.collect.DiscreteDomain;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.jena.sparql.service.enhancer.impl.Batch;

public class BatchImpl<K extends Comparable<K>, T>
implements Batch<K, T> {
    protected K firstKey;
    protected DiscreteDomain<K> discreteDomain;
    protected NavigableMap<K, T> items;
    protected NavigableMap<K, T> unmodifiableItems;

    public BatchImpl(K firstKey, DiscreteDomain<K> discreteDomain) {
        this.firstKey = firstKey;
        this.discreteDomain = discreteDomain;
        this.items = new TreeMap<K, T>();
        this.unmodifiableItems = Collections.unmodifiableNavigableMap(this.items);
    }

    public static <T> Batch<Integer, T> forInteger() {
        return new BatchImpl<Integer, T>(0, DiscreteDomain.integers());
    }

    public static <T> Batch<Long, T> forLong() {
        return new BatchImpl<Long, T>(0L, DiscreteDomain.longs());
    }

    @Override
    public void put(K index, T item) {
        K nextValidIndex = this.getNextValidIndex();
        int cmp = index.compareTo(nextValidIndex);
        if (cmp < 0) {
            throw new IllegalArgumentException("Index is lower than an existing one");
        }
        this.items.put(index, item);
    }

    @Override
    public K getNextValidIndex() {
        K result = this.items.isEmpty() ? this.firstKey : this.discreteDomain.next((Comparable)this.items.lastKey());
        return result;
    }

    @Override
    public NavigableMap<K, T> getItems() {
        return this.unmodifiableItems;
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    public String toString() {
        return "Batch [size=" + this.size() + ", itemRanges=" + String.valueOf(this.items) + "]";
    }
}

