/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.example;

import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerInit;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.QueryExecUtils;

public class ServicePluginExamples {
    public static void main(String[] args) {
        ServicePluginExamples.customLinearJoin(DatasetFactory.empty());
    }

    public static void customLinearJoin(Dataset dataset) {
        Context cxt = ARQ.getContext().copy();
        ServiceEnhancerInit.wrapOptimizer(cxt);
        String queryStr = "SELECT * {\n  BIND(<urn:foo> AS ?s)\n  SERVICE <loop:urn:arq:self> {\n      { BIND(?s AS ?x) } UNION { BIND(?s AS ?y) }\n  }\n}";
        ServicePluginExamples.execQueryAndShowResult(dataset, queryStr, cxt);
    }

    public static void execQueryAndShowResult(Dataset dataset, String queryStr, Context cxt) {
        try (QueryExec exec = QueryExecDatasetBuilder.create().dataset(dataset.asDatasetGraph()).query(queryStr).context(cxt).build();){
            QueryExecUtils.exec((QueryExec)exec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

