/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.example;

import com.google.common.base.Stopwatch;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerInit;

public class ServiceCachingExamples {
    public static void main(String[] args) {
        ServiceCachingExamples.basicCachingExample();
        ServiceCachingExamples.moreExamples();
    }

    public static void basicCachingExample() {
        Model model = ModelFactory.createDefaultModel();
        try (QueryExecution qe = QueryExecutionFactory.create((String)String.join((CharSequence)"\n", "SELECT * {  SERVICE <loop:cache:bulk+3:http://dbpedia.org/sparql> {    SELECT DISTINCT ?p { ?s a <http://dbpedia.org/ontology/MusicalArtist> ; ?p ?o }  }}"), (Model)model);){
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ServiceCachingExamples.benchmark(() -> ResultSetFormatter.consume((ResultSet)qe.execSelect()));
        }
        qe = QueryExecutionFactory.create((String)String.join((CharSequence)"\n", "SELECT * {  SERVICE <loop:cache:http://dbpedia.org/sparql> {    SELECT DISTINCT ?p { ?s a <http://dbpedia.org/ontology/MusicalArtist> ; ?p ?o }  }  FILTER(CONTAINS(STR(?p), 'tim'))}"), (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ServiceCachingExamples.benchmark(() -> ResultSetFormatter.consume((ResultSet)qe.execSelect()));
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
    }

    public static void testDbpedia() {
        String queryStr = String.join((CharSequence)"\n", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX dbo: <http://dbpedia.org/ontology/>", "SELECT * WHERE {", "  SERVICE <cache:https://dbpedia.org/sparql> {", "    SELECT * {", "      ?s a dbo:MusicalArtist", "    } ORDER BY ?s LIMIT 10 OFFSET 20", "  }", "  SERVICE <cache:loop:bulk+10:https://dbpedia.org/sparql> {", "    ?s rdfs:label ?l", "  }", "}");
        QueryFactory.create((String)queryStr);
    }

    public static void moreExamples() {
        Model model;
        try (QueryExecution qe = (QueryExecution)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.newBuilder().endpoint("https://dbpedia.org/sparql")).query("CONSTRUCT { ?s ?p ?o } WHERE { { SELECT DISTINCT ?s { ?s a <http://dbpedia.org/ontology/Person> } LIMIT 10 } ?s ?p ?o }")).build();){
            model = qe.execConstruct();
        }
        System.out.println("Backend request spo all");
        qe = QueryExecutionFactory.create((String)"SELECT * { { SELECT DISTINCT ?s { ?s a <http://dbpedia.org/ontology/Person> } LIMIT 3 } SERVICE <loop:cache:bulk+3> { { SELECT * { ?s ?p ?o } } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        System.out.println("Backend request spo 1");
        qe = QueryExecutionFactory.create((String)"SELECT * { { SELECT DISTINCT ?s { ?s a <http://dbpedia.org/ontology/Person> } LIMIT 3 } SERVICE <loop:cache:bulk+3> { { SELECT * { ?s ?p ?o } LIMIT 1 } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        System.out.println("Backend request:");
        qe = QueryExecutionFactory.create((String)"SELECT * { { SELECT DISTINCT ?s { ?s a <http://dbpedia.org/ontology/Person> } LIMIT 3 } SERVICE <loop:cache:bulk+3> { { SELECT * { ?s ?p ?o . FILTER(?p = <http://www.w3.org/2000/01/rdf-schema#label>) } ORDER BY ?p LIMIT 1 } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        System.out.println("Serving from cache:");
        qe = QueryExecutionFactory.create((String)"SELECT * { { SELECT DISTINCT ?s { ?s a <http://dbpedia.org/ontology/Person> } LIMIT 3 } SERVICE <loop:cache:bulk+3> { { SELECT * { ?s ?p ?o . FILTER(?p = <http://www.w3.org/2000/01/rdf-schema#label>) } ORDER BY ?p LIMIT 1 } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        System.out.println("Fetching one more binding per item:");
        qe = QueryExecutionFactory.create((String)"SELECT * { { SELECT DISTINCT ?s { ?s a <http://dbpedia.org/ontology/Person> } LIMIT 3 } SERVICE <loop:cache:bulk+3> { { SELECT * { ?s ?p ?o . FILTER(?p = <http://www.w3.org/2000/01/rdf-schema#label>) } ORDER BY ?p LIMIT 2 } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        qe = QueryExecutionFactory.create((String)"SELECT * { BIND('x' AS ?x) SERVICE <loop:> { BIND(?x AS ?y) SERVICE <loop:> { BIND(?y AS ?z) } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        qe = QueryExecutionFactory.create((String)"SELECT * { { SELECT ?s { ?s a <http://dbpedia.org/ontology/Person> } OFFSET 1 LIMIT 1 } SERVICE <cache:bulk+20:https://dbpedia.org/sparql> { { SELECT ?s ?p ?o { ?s ?p ?o . FILTER(?p = <http://www.w3.org/2000/01/rdf-schema#label>) } ORDER BY ?p } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            qe.getContext().set(ServiceEnhancerConstants.serviceBulkMaxBindingCount, (Object)10);
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        qe = QueryExecutionFactory.create((String)"SELECT * { { SELECT ?s { ?s a <http://dbpedia.org/ontology/Person> } OFFSET 0 LIMIT 3 } SERVICE <https://dbpedia.org/sparql> { { SELECT ?s ?p ?o { ?s ?p ?o . FILTER(?p = <http://www.w3.org/2000/01/rdf-schema#label>) } ORDER BY ?p } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            qe.getContext().set(ServiceEnhancerConstants.serviceBulkMaxBindingCount, (Object)10);
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        qe = QueryExecutionFactory.create((String)"SELECT * { ?s a <http://dbpedia.org/ontology/Person> SERVICE <https://dbpedia.org/sparql> { { SELECT * { ?s ?p ?o } LIMIT 3 OFFSET 5 } } }", (Model)model);
        try {
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        qe = QueryExecutionFactory.create((String)"SELECT * { SERVICE <https://dbpedia.org/sparql> { { SELECT DISTINCT ?p { ?s a <http://dbpedia.org/ontology/Company> ; ?p ?o } ORDER BY ?p } } }", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            qe.getContext().set(ServiceEnhancerConstants.serviceBulkMaxBindingCount, (Object)10);
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
        qe = QueryExecutionFactory.create((String)"SELECT * { SERVICE <https://dbpedia.org/sparql> { { SELECT DISTINCT ?p { ?s a <http://dbpedia.org/ontology/Company> ; ?p ?o } ORDER BY ?p } } FILTER (CONTAINS(STR(?p), 'rdf'))}", (Model)model);
        try {
            ServiceEnhancerInit.wrapOptimizer(qe.getContext());
            qe.getContext().set(ServiceEnhancerConstants.serviceBulkMaxBindingCount, (Object)10);
            ResultSetMgr.write((OutputStream)System.out, (ResultSet)qe.execSelect(), (Lang)ResultSetLang.RS_JSON);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
        }
    }

    public static void benchmark(Callable<?> callable) {
        Object result;
        Stopwatch sw = Stopwatch.createStarted();
        try {
            result = callable.call();
        }
        catch (Exception e) {
            System.out.println("Failed in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms");
            throw new RuntimeException(e);
        }
        System.out.println("Obtained value [" + String.valueOf(result) + "] in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms");
    }

    static {
        LogCtl.setLogging();
    }
}

