/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.claimingcache;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.jena.sparql.service.enhancer.claimingcache.Ref;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefDelegateBase;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefFutureImpl<T>
extends RefDelegateBase<CompletableFuture<T>, Ref<CompletableFuture<T>>>
implements RefFuture<T> {
    private static final Logger logger = LoggerFactory.getLogger(RefFutureImpl.class);

    public RefFutureImpl(Ref<CompletableFuture<T>> delegate) {
        super(delegate);
    }

    @Override
    public RefFuture<T> acquire() {
        return RefFutureImpl.wrap(this.getDelegate().acquire());
    }

    public static <T> RefFuture<T> wrap(Ref<CompletableFuture<T>> delegate) {
        return new RefFutureImpl<T>(delegate);
    }

    public static <T> RefFuture<T> fromRef(Ref<T> ref) {
        RefFuture<T> result = RefFutureImpl.fromFuture(CompletableFuture.completedFuture(ref), ref.getSynchronizer());
        return result;
    }

    public static <T> RefFuture<T> fromFuture(CompletableFuture<Ref<T>> future, Object synchronizer) {
        return RefFutureImpl.wrap(RefImpl.create(future.thenApply(Ref::get), synchronizer, () -> RefFutureImpl.cancelFutureOrCloseRef(future), null));
    }

    public static void cancelFutureOrCloseRef(CompletableFuture<? extends Ref<?>> future) {
        RefFutureImpl.cancelFutureOrCloseValue(future, Ref::close);
    }

    public static <T> void cancelFutureOrCloseValue(CompletableFuture<T> future, Consumer<? super T> valueCloseAction) {
        AtomicBoolean closeActionRun = new AtomicBoolean(false);
        BiConsumer<Object, Throwable> closeAction = (value, t) -> {
            if (!closeActionRun.getAndSet(true) && value != null && valueCloseAction != null) {
                valueCloseAction.accept(value);
            }
            if (t != null) {
                logger.warn("Exception encountered during close", t);
            }
        };
        CompletionStage derived = future.whenComplete(closeAction);
        try {
            if (!((CompletableFuture)derived).isDone()) {
                future.cancel(true);
                ((CompletableFuture)derived).get();
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            logger.warn("Exception raised during close", (Throwable)e);
        }
    }
}

