/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.claimingcache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.jena.sparql.service.enhancer.claimingcache.Ref;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefDelegate;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFutureImpl;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefImpl;

public interface RefFuture<T>
extends RefDelegate<CompletableFuture<T>, Ref<CompletableFuture<T>>> {
    default public T await() {
        Object result;
        CompletableFuture cf = (CompletableFuture)this.get();
        try {
            result = cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public RefFuture<T> acquire();

    default public <U> RefFuture<U> acquireTransformed(Function<? super T, ? extends U> transform) {
        Ref acquired = this.acquire();
        Object synchronizer = acquired.getSynchronizer();
        CompletionStage future = ((CompletableFuture)acquired.get()).thenApply((Function)transform);
        RefFuture result = RefFutureImpl.wrap(RefImpl.create(future, synchronizer, ((RefFuture)acquired)::close));
        return result;
    }

    default public <U> RefFuture<U> acquireTransformedAndCloseThis(Function<? super T, ? extends U> transform) {
        RefFuture<? extends U> result = this.acquireTransformed(transform);
        this.close();
        return result;
    }
}

