/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.claimingcache;

import java.util.function.Function;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefImpl;

public interface Ref<T>
extends AutoCloseable {
    public Ref<T> getRootRef();

    public T get();

    public Object getSynchronizer();

    public Ref<T> acquire(Object var1);

    default public Ref<T> acquire() {
        return this.acquire(null);
    }

    public boolean isAlive();

    public boolean isClosed();

    @Override
    public void close();

    public StackTraceElement[] getAcquisitionStackTrace();

    public StackTraceElement[] getCloseStackTrace();

    public StackTraceElement[] getCloseTriggerStackTrace();

    default public <X> Ref<X> acquireMapped(Function<? super T, ? extends X> mapper) {
        Ref<T> base = this.acquire();
        X mapped = mapper.apply(base.get());
        Ref<X> result = RefImpl.create(mapped, base.getSynchronizer(), base);
        return result;
    }
}

