/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.claimingcache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.sparql.service.enhancer.claimingcache.AsyncClaimingCache;
import org.apache.jena.sparql.service.enhancer.claimingcache.Ref;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFutureImpl;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefImpl;
import org.apache.jena.sparql.service.enhancer.impl.util.LockUtils;
import org.apache.jena.sparql.service.enhancer.slice.api.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClaimingCacheImplGuava<K, V>
implements AsyncClaimingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncClaimingCacheImplGuava.class);
    protected Map<K, RefFuture<V>> level1;
    protected LoadingCache<K, CompletableFuture<V>> level2;
    protected Map<K, V> level3;
    protected BiConsumer<K, RefFuture<V>> claimListener;
    protected BiConsumer<K, RefFuture<V>> unclaimListener;
    protected ReentrantReadWriteLock invalidationLock = new ReentrantReadWriteLock();
    protected final Collection<Predicate<? super K>> evictionGuards;
    protected RemovalListener<K, V> atomicRemovalListener;
    protected Set<K> suppressedRemovalEvents;
    protected Map<K, Latch> keyToSynchronizer = new ConcurrentHashMap<K, Latch>();

    public AsyncClaimingCacheImplGuava(Map<K, RefFuture<V>> level1, LoadingCache<K, CompletableFuture<V>> level2, Map<K, V> level3, Collection<Predicate<? super K>> evictionGuards, BiConsumer<K, RefFuture<V>> claimListener, BiConsumer<K, RefFuture<V>> unclaimListener, RemovalListener<K, V> atomicRemovalListener, Set<K> suppressedRemovalEvents) {
        this.level1 = level1;
        this.level2 = level2;
        this.level3 = level3;
        this.evictionGuards = evictionGuards;
        this.claimListener = claimListener;
        this.unclaimListener = unclaimListener;
        this.atomicRemovalListener = atomicRemovalListener;
        this.suppressedRemovalEvents = suppressedRemovalEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Disposable addEvictionGuard(Predicate<? super K> predicate) {
        Collection<Predicate<? super K>> collection = this.evictionGuards;
        synchronized (collection) {
            this.evictionGuards.add(predicate);
        }
        return () -> {
            Collection<Predicate<? super K>> collection = this.evictionGuards;
            synchronized (collection) {
                this.evictionGuards.remove(predicate);
                this.runLevel3Eviction();
            }
        };
    }

    protected void runLevel3Eviction() {
        Iterator<Map.Entry<K, V>> it = this.level3.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> e = it.next();
            Object k = e.getKey();
            V v = e.getValue();
            boolean isGuarded = this.evictionGuards.stream().anyMatch(p -> p.test(k));
            if (isGuarded) continue;
            this.atomicRemovalListener.onRemoval(RemovalNotification.create(k, v, (RemovalCause)RemovalCause.COLLECTED));
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefFuture<V> claim(K key) {
        Ref result;
        Latch synchronizer;
        Latch latch = synchronizer = this.keyToSynchronizer.compute(key, (k, before) -> before == null ? new Latch() : before.inc());
        synchronized (latch) {
            this.keyToSynchronizer.compute(key, (k, before) -> before.dec());
            boolean[] isFreshSecondaryRef = new boolean[]{false};
            RefFuture secondaryRef = LockUtils.runWithLock((Lock)this.invalidationLock.readLock(), () -> this.level1.computeIfAbsent(key, k -> {
                RefFuture r;
                CompletableFuture future;
                logger.trace("Claiming item [" + String.valueOf(key) + "] from level2");
                try {
                    future = (CompletableFuture)this.level2.get(key);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Should not happen", e);
                }
                this.suppressedRemovalEvents.add(key);
                this.level2.asMap().remove(key);
                this.suppressedRemovalEvents.remove(key);
                RefFuture[] holder = new RefFuture[]{null};
                Ref freshSecondaryRef = RefImpl.create(future, synchronizer, () -> {
                    RefFuture v = holder[0];
                    if (this.unclaimListener != null) {
                        this.unclaimListener.accept(key, v);
                    }
                    RefFutureImpl.cancelFutureOrCloseValue(future, null);
                    this.level1.remove(key);
                    logger.trace("Item [" + String.valueOf(key) + "] was unclaimed. Transferring to level2.");
                    this.level2.put(key, (Object)future);
                    this.keyToSynchronizer.compute(key, (kk, before) -> before.get() == 0 ? null : before);
                });
                isFreshSecondaryRef[0] = true;
                holder[0] = r = RefFutureImpl.wrap(freshSecondaryRef);
                return r;
            }));
            result = secondaryRef.acquire();
            if (this.claimListener != null) {
                this.claimListener.accept(key, (RefFuture<V>)result);
            }
            if (isFreshSecondaryRef[0]) {
                secondaryRef.close();
            }
        }
        return result;
    }

    public static <K, V> Builder<K, V> newBuilder(CacheBuilder<Object, Object> caffeine) {
        Builder result = new Builder();
        result.setCacheBuilder(caffeine);
        return result;
    }

    public static void main(String[] args) throws InterruptedException {
        AsyncClaimingCacheImplGuava<String, String> cache = AsyncClaimingCacheImplGuava.newBuilder((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(1L, TimeUnit.SECONDS)).setCacheLoader(key -> "Loaded " + key).setAtomicRemovalListener((RemovalListener<String, String>)((RemovalListener)n -> System.out.println("Evicted " + (String)n.getKey()))).setClaimListener((k, v) -> System.out.println("Claimed: " + k)).setUnclaimListener((k, v) -> System.out.println("Unclaimed: " + k)).build();
        try (RefFuture<String> ref = cache.claim("test");
             Disposable disposable = cache.addEvictionGuard(k -> k.contains("test"));){
            System.out.println(ref.await());
            ref.close();
            TimeUnit.SECONDS.sleep(5L);
            try (RefFuture<String> reclaim = cache.claim("test");){
                disposable.close();
            }
        }
        TimeUnit.SECONDS.sleep(5L);
        System.out.println("done");
    }

    @Override
    public RefFuture<V> claimIfPresent(K key) {
        RefFuture<V> result = this.level1.containsKey(key) || this.level2.asMap().containsKey(key) ? this.claim(key) : null;
        return result;
    }

    @Override
    public void invalidateAll() {
        ArrayList keys = new ArrayList(this.level2.asMap().keySet());
        this.invalidateAll(keys);
    }

    @Override
    public void invalidateAll(Iterable<? extends K> keys) {
        LockUtils.runWithLock((Lock)this.invalidationLock.writeLock(), () -> {
            ConcurrentMap map = this.level2.asMap();
            for (Object key : keys) {
                map.compute(key, (k, vFuture) -> {
                    Object v = null;
                    if (vFuture.isDone()) {
                        try {
                            v = vFuture.get();
                        }
                        catch (Exception e) {
                            logger.warn("Detected cache entry that failed to load during invalidation", (Throwable)e);
                        }
                    }
                    this.atomicRemovalListener.onRemoval(RemovalNotification.create((Object)k, v, (RemovalCause)RemovalCause.EXPLICIT));
                    return null;
                });
            }
        });
    }

    @Override
    public Collection<K> getPresentKeys() {
        return new LinkedHashSet(this.level2.asMap().keySet());
    }

    private static class Latch {
        volatile int numWaitingThreads = 1;

        private Latch() {
        }

        Latch inc() {
            ++this.numWaitingThreads;
            return this;
        }

        Latch dec() {
            --this.numWaitingThreads;
            return this;
        }

        int get() {
            return this.numWaitingThreads;
        }

        public String toString() {
            return "Latch " + System.identityHashCode(this) + " has " + this.numWaitingThreads + " threads waiting";
        }
    }

    public static class Builder<K, V> {
        protected CacheBuilder<Object, Object> cacheBuilder;
        protected Function<K, V> cacheLoader;
        protected BiConsumer<K, RefFuture<V>> claimListener;
        protected BiConsumer<K, RefFuture<V>> unclaimListener;
        protected RemovalListener<K, V> userAtomicRemovalListener;

        Builder<K, V> setCacheBuilder(CacheBuilder<Object, Object> caffeine) {
            this.cacheBuilder = caffeine;
            return this;
        }

        public Builder<K, V> setClaimListener(BiConsumer<K, RefFuture<V>> claimListener) {
            this.claimListener = claimListener;
            return this;
        }

        public Builder<K, V> setUnclaimListener(BiConsumer<K, RefFuture<V>> unclaimListener) {
            this.unclaimListener = unclaimListener;
            return this;
        }

        public Builder<K, V> setCacheLoader(Function<K, V> cacheLoader) {
            this.cacheLoader = cacheLoader;
            return this;
        }

        public Builder<K, V> setAtomicRemovalListener(RemovalListener<K, V> userAtomicRemovalListener) {
            this.userAtomicRemovalListener = userAtomicRemovalListener;
            return this;
        }

        public AsyncClaimingCacheImplGuava<K, V> build() {
            ConcurrentHashMap level1 = new ConcurrentHashMap();
            ConcurrentHashMap level3 = new ConcurrentHashMap();
            ArrayList evictionGuards = new ArrayList();
            RemovalListener level3AwareAtomicRemovalListener = n -> {
                Object k = n.getKey();
                Object v = n.getValue();
                RemovalCause c = n.getCause();
                if (!level1.containsKey(k)) {
                    boolean isGuarded = false;
                    Collection collection = evictionGuards;
                    synchronized (collection) {
                        for (Predicate evictionGuard : evictionGuards) {
                            isGuarded = evictionGuard.test(k);
                            if (!isGuarded) continue;
                            logger.debug("Protecting from eviction: " + String.valueOf(k) + " - " + level3.size() + " items protected");
                            level3.put(k, v);
                            break;
                        }
                    }
                    if (!isGuarded && this.userAtomicRemovalListener != null) {
                        this.userAtomicRemovalListener.onRemoval(RemovalNotification.create((Object)k, (Object)v, (RemovalCause)c));
                    }
                }
            };
            Set suppressedRemovalEvents = Collections.newSetFromMap(new ConcurrentHashMap());
            this.cacheBuilder.removalListener(n -> {
                Object kk = n.getKey();
                if (!suppressedRemovalEvents.contains(kk)) {
                    CompletableFuture cfv = (CompletableFuture)n.getValue();
                    Object vv = null;
                    if (cfv.isDone()) {
                        try {
                            vv = cfv.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException("Should not happen", e);
                        }
                    }
                    RemovalCause c = n.getCause();
                    level3AwareAtomicRemovalListener.onRemoval(RemovalNotification.create((Object)kk, vv, (RemovalCause)c));
                }
            });
            Function<Object, Object> level3AwareCacheLoader = k -> {
                Object[] tmp = new Object[]{null};
                level3.compute(k, (kk, v) -> {
                    tmp[0] = v;
                    return null;
                });
                Object r = tmp[0];
                if (r == null) {
                    r = this.cacheLoader.apply(k);
                }
                return r;
            };
            LoadingCache level2 = this.cacheBuilder.build(CacheLoader.from(k -> CompletableFuture.completedFuture(level3AwareCacheLoader.apply(k))));
            AsyncClaimingCacheImplGuava result = new AsyncClaimingCacheImplGuava(level1, level2, level3, evictionGuards, this.claimListener, this.unclaimListener, level3AwareAtomicRemovalListener, suppressedRemovalEvents);
            return result;
        }
    }
}

