/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.assembler;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.service.enhancer.assembler.ServiceEnhancerVocab;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.service.enhancer.impl.util.GraphUtilsExtra;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerInit;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetAssemblerServiceEnhancer
extends DatasetAssembler {
    public DatasetGraph createDataset(Assembler a, Resource root) {
        Node selfId;
        Dataset result;
        Resource baseDatasetRes = GraphUtils.getResourceValue((Resource)root, (Property)ServiceEnhancerVocab.baseDataset);
        Objects.requireNonNull(baseDatasetRes, "No ja:baseDataset specified on " + String.valueOf(root));
        Object obj = a.open(baseDatasetRes);
        if (obj instanceof Dataset) {
            result = (Dataset)obj;
            Context cxt = result.getContext();
            ServiceEnhancerInit.wrapOptimizer(cxt, ARQ.getContext());
            RDFNode selfIdRes = GraphUtils.getAsRDFNode((Resource)root, (Property)ServiceEnhancerVocab.datasetId);
            selfId = selfIdRes == null ? baseDatasetRes.asNode() : selfIdRes.asNode();
            RDFNode enableMgmtRdfNode = GraphUtils.getAsRDFNode((Resource)root, (Property)ServiceEnhancerVocab.enableMgmt);
            boolean enableMgmt = enableMgmtRdfNode == null ? false : enableMgmtRdfNode.asLiteral().getBoolean();
            cxt.set(ServiceEnhancerConstants.datasetId, (Object)selfId);
            if (root.hasProperty(ServiceEnhancerVocab.cacheMaxEntryCount) || root.hasProperty(ServiceEnhancerVocab.cachePageSize) || root.hasProperty(ServiceEnhancerVocab.cacheMaxPageCount)) {
                int maxEntryCount = GraphUtilsExtra.getAsInt(root, ServiceEnhancerVocab.cacheMaxEntryCount, 300);
                int pageSize = GraphUtilsExtra.getAsInt(root, ServiceEnhancerVocab.cachePageSize, 10000);
                int maxPageCount = GraphUtilsExtra.getAsInt(root, ServiceEnhancerVocab.cacheMaxPageCount, 15);
                Preconditions.checkArgument((maxEntryCount > 0 ? 1 : 0) != 0, (Object)(ServiceEnhancerVocab.cacheMaxEntryCount.getURI() + " requires a value greater than 0"));
                Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)(ServiceEnhancerVocab.cachePageSize.getURI() + " requires a value greater than 0"));
                Preconditions.checkArgument((maxPageCount > 0 ? 1 : 0) != 0, (Object)(ServiceEnhancerVocab.cacheMaxPageCount.getURI() + " requires a value greater than 0"));
                ServiceResponseCache cache = new ServiceResponseCache(maxEntryCount, pageSize, maxPageCount);
                ServiceResponseCache.set(cxt, cache);
            }
            DatasetAssemblerServiceEnhancer.configureCxt(root, ServiceEnhancerVocab.bulkMaxSize, cxt, ServiceEnhancerConstants.serviceBulkMaxBindingCount, false, 100, GraphUtilsExtra::getAsInt);
            DatasetAssemblerServiceEnhancer.configureCxt(root, ServiceEnhancerVocab.bulkSize, cxt, ServiceEnhancerConstants.serviceBulkBindingCount, false, 30, GraphUtilsExtra::getAsInt);
            DatasetAssemblerServiceEnhancer.configureCxt(root, ServiceEnhancerVocab.bulkMaxOutOfBandSize, cxt, ServiceEnhancerConstants.serviceBulkMaxOutOfBandBindingCount, false, 30, GraphUtilsExtra::getAsInt);
            if (enableMgmt) {
                cxt = cxt.copy();
                cxt.set(ServiceEnhancerConstants.enableMgmt, true);
                result = DatasetFactory.wrap((DatasetGraph)new DatasetGraphWrapper(result.asDatasetGraph(), cxt));
            }
        } else {
            Class<?> cls = obj == null ? null : obj.getClass();
            throw new AssemblerException(root, "Expected ja:baseDataset to be a Dataset but instead got " + Objects.toString(cls));
        }
        Log.info(DatasetAssemblerServiceEnhancer.class, (String)("Dataset self id set to " + String.valueOf(selfId)));
        return result.asDatasetGraph();
    }

    private static <T> void configureCxt(Resource root, Property property, Context cxt, Symbol symbol, boolean applyDefaultValueIfPropertyAbsent, T defaultValue, TriFunction<Resource, Property, T, T> getValue) {
        if (root.hasProperty(property) || applyDefaultValueIfPropertyAbsent) {
            Object value = getValue.apply((Object)root, (Object)property, defaultValue);
            cxt.set(symbol, value);
        }
    }
}

