/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.algebra;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.service.enhancer.impl.ServiceOpts;

public class TransformSE_JoinStrategy
extends TransformCopy {
    public Op transform(OpJoin opJoin, Op left, Op right) {
        OpService op;
        ServiceOpts opts;
        boolean canDoLinear = false;
        Op effectiveRight = right;
        if (right instanceof OpService && (canDoLinear = (opts = ServiceOpts.getEffectiveService(op = (OpService)right)).containsKey("loop"))) {
            NodeTransform joinVarRename = TransformSE_JoinStrategy.renameForImplicitJoinVars(left);
            effectiveRight = NodeTransformLib.transform((NodeTransform)joinVarRename, (Op)right);
        }
        Op result = canDoLinear ? OpSequence.create((Op)left, (Op)effectiveRight) : super.transform(opJoin, left, effectiveRight);
        return result;
    }

    public Op transform(OpSequence opSequence, List<Op> elts) {
        LinkedHashSet<Var> visibleVarsLeft = new LinkedHashSet<Var>();
        OpSequence result = OpSequence.create();
        Iterator<Op> iterator = elts.iterator();
        while (iterator.hasNext()) {
            OpService op;
            ServiceOpts opts;
            boolean isLoop;
            Op right;
            Op newOp = right = iterator.next();
            if (right instanceof OpService && (isLoop = (opts = ServiceOpts.getEffectiveService(op = (OpService)right)).containsKey("loop"))) {
                NodeTransform joinVarRename = TransformSE_JoinStrategy.renameForImplicitJoinVars(visibleVarsLeft);
                newOp = NodeTransformLib.transform((NodeTransform)joinVarRename, (Op)right);
            }
            Set visibleVarsRight = OpVars.visibleVars((Op)newOp);
            visibleVarsLeft.addAll(visibleVarsRight);
            result.add(newOp);
        }
        return result;
    }

    public Op transform(OpDisjunction opSequence, List<Op> elts) {
        LinkedHashSet<Var> visibleVarsLeft = new LinkedHashSet<Var>();
        OpDisjunction result = OpDisjunction.create();
        Iterator<Op> iterator = elts.iterator();
        while (iterator.hasNext()) {
            OpService op;
            ServiceOpts opts;
            boolean isLoop;
            Op right;
            Op newOp = right = iterator.next();
            if (right instanceof OpService && (isLoop = (opts = ServiceOpts.getEffectiveService(op = (OpService)right)).containsKey("loop"))) {
                NodeTransform joinVarRename = TransformSE_JoinStrategy.renameForImplicitJoinVars(visibleVarsLeft);
                newOp = NodeTransformLib.transform((NodeTransform)joinVarRename, (Op)right);
            }
            Set visibleVarsRight = OpVars.visibleVars((Op)newOp);
            visibleVarsLeft.addAll(visibleVarsRight);
            result.add(newOp);
        }
        return result;
    }

    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) {
        OpService op;
        ServiceOpts opts;
        boolean canDoLinear = false;
        Op effectiveRight = right;
        if (right instanceof OpService && (canDoLinear = (opts = ServiceOpts.getEffectiveService(op = (OpService)right)).containsKey("loop"))) {
            NodeTransform joinVarRename = TransformSE_JoinStrategy.renameForImplicitJoinVars(left);
            effectiveRight = NodeTransformLib.transform((NodeTransform)joinVarRename, (Op)right);
            ExprList joinExprs = opLeftJoin.getExprs();
            if (joinExprs != null) {
                ExprList effectiveExprs = NodeTransformLib.transform((NodeTransform)joinVarRename, (ExprList)joinExprs);
                effectiveRight = OpFilter.filterBy((ExprList)effectiveExprs, (Op)effectiveRight);
            }
        }
        OpConditional result = canDoLinear ? new OpConditional(left, effectiveRight) : super.transform(opLeftJoin, left, effectiveRight);
        return result;
    }

    public static NodeTransform renameForImplicitJoinVars(Op left) {
        Set visibleInLhs = OpVars.visibleVars((Op)left);
        return TransformSE_JoinStrategy.renameForImplicitJoinVars(visibleInLhs);
    }

    public static NodeTransform renameForImplicitJoinVars(Set<Var> visibleInLhs) {
        Map<Var, Var> lhsPlainToScoped = visibleInLhs.stream().collect(Collectors.toMap(v -> (Var)Rename.reverseVarRename((Node)v), v -> v));
        HashMap cache = new HashMap();
        NodeTransform joinVarRename = n -> {
            Node plain = cache.computeIfAbsent(n, Rename::reverseVarRename);
            Var scopedLhs = (Var)lhsPlainToScoped.get(plain);
            Node r = scopedLhs == null ? n : scopedLhs;
            return r;
        };
        return joinVarRename;
    }
}

