/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.rewriters;

import java.util.List;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAntiJoin;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementSemiJoin;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnfold;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;

public class BuildElementVisitor
implements ElementVisitor {
    private Element result;

    public Element getResult() {
        return this.result;
    }

    public void setResult(Element result) {
        this.result = result;
    }

    public void visit(ElementTriplesBlock el) {
        this.result = el;
    }

    public void visit(ElementPathBlock el) {
        this.result = el;
    }

    public void visit(ElementFilter el) {
        this.result = el;
    }

    public void visit(ElementAssign el) {
        this.result = el;
    }

    public void visit(ElementBind el) {
        this.result = el;
    }

    public void visit(ElementUnfold el) {
        this.result = el;
    }

    public void visit(ElementData el) {
        this.result = el;
    }

    private void updateList(List<Element> lst) {
        for (int i = 0; i < lst.size(); ++i) {
            lst.get(i).visit((ElementVisitor)this);
            lst.set(i, this.result);
        }
    }

    public void visit(ElementUnion el) {
        List lst = el.getElements();
        if (lst.size() <= 1) {
            ElementGroup eg = new ElementGroup();
            if (lst.size() == 1) {
                ((Element)el.getElements().get(0)).visit((ElementVisitor)this);
                eg.addElement(this.result);
            }
            this.result = eg;
        } else {
            this.updateList(lst);
            this.result = el;
        }
    }

    public void visit(ElementLateral el) {
        el.getLateralElement().visit((ElementVisitor)this);
        this.result = this.result == el.getLateralElement() ? el : new ElementOptional(this.result);
    }

    public void visit(ElementSemiJoin el) {
        el.getSubElement().visit((ElementVisitor)this);
        this.result = this.result == el.getSubElement() ? el : new ElementSemiJoin(this.result);
    }

    public void visit(ElementAntiJoin el) {
        el.getSubElement().visit((ElementVisitor)this);
        this.result = this.result == el.getSubElement() ? el : new ElementAntiJoin(this.result);
    }

    public void visit(ElementOptional el) {
        el.getOptionalElement().visit((ElementVisitor)this);
        this.result = this.result == el.getOptionalElement() ? el : new ElementOptional(this.result);
    }

    public void visit(ElementGroup el) {
        List lst = el.getElements();
        if (lst.isEmpty()) {
            this.result = el;
        } else if (lst.size() == 1) {
            ((Element)lst.get(0)).visit((ElementVisitor)this);
        } else {
            this.updateList(lst);
            this.result = el;
        }
    }

    public void visit(ElementDataset el) {
        this.result = el;
    }

    public void visit(ElementNamedGraph el) {
        el.getElement().visit((ElementVisitor)this);
        this.result = this.result == el.getElement() ? el : new ElementNamedGraph(el.getGraphNameNode(), this.result);
    }

    public void visit(ElementExists el) {
        el.getElement().visit((ElementVisitor)this);
        this.result = this.result == el.getElement() ? el : new ElementExists(this.result);
    }

    public void visit(ElementNotExists el) {
        el.getElement().visit((ElementVisitor)this);
        this.result = this.result == el.getElement() ? el : new ElementNotExists(this.result);
    }

    public void visit(ElementMinus el) {
        el.getMinusElement().visit((ElementVisitor)this);
        this.result = this.result == el.getMinusElement() ? el : new ElementMinus(this.result);
    }

    public void visit(ElementService el) {
        el.getElement().visit((ElementVisitor)this);
        this.result = this.result == el.getElement() ? el : new ElementService(el.getServiceNode(), this.result, el.getSilent());
    }

    public void visit(ElementSubQuery el) {
        WhereHandler other = new WhereHandler(el.getQuery());
        other.build();
        if (other.getElement() != el.getQuery().getQueryPattern()) {
            el.getQuery().setQueryPattern(other.getQuery().getQueryPattern());
        }
        this.result = el;
    }
}

