/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.utils;

import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.vocabulary.RDF;

public class RDFListSecFilter<T extends RDFList>
implements Predicate<T> {
    private final SecuredItem securedItem;
    private final Set<SecurityEvaluator.Action> perms;
    private final Object principal;

    public RDFListSecFilter(SecuredItem securedItem, SecurityEvaluator.Action perm) {
        this(securedItem, SecurityEvaluator.Util.asSet(new SecurityEvaluator.Action[]{perm}));
    }

    public RDFListSecFilter(SecuredItem securedItem, Set<SecurityEvaluator.Action> perms) {
        this.securedItem = securedItem;
        this.perms = perms;
        this.principal = securedItem.getSecurityEvaluator().getPrincipal();
    }

    @Override
    public boolean test(RDFList o) throws AuthenticationRequiredException {
        Statement s = o.getRequiredProperty(RDF.first);
        return this.securedItem.getSecurityEvaluator().evaluate(this.principal, this.perms, this.securedItem.getModelNode(), s.asTriple());
    }
}

