/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.utils;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.shared.AuthenticationRequiredException;

public class PermTripleFilter
implements Predicate<Triple> {
    private final SecurityEvaluator evaluator;
    private final Node modelNode;
    private final Set<SecurityEvaluator.Action> actions;
    private final Object principal;

    public PermTripleFilter(SecurityEvaluator.Action action, SecuredItem securedItem) {
        this.modelNode = securedItem.getModelNode();
        this.actions = SecurityEvaluator.Util.asSet(new SecurityEvaluator.Action[]{action});
        this.evaluator = securedItem.getSecurityEvaluator();
        this.principal = this.evaluator.getPrincipal();
    }

    public PermTripleFilter(SecurityEvaluator.Action action, SecuredItem securedItem, SecurityEvaluator evaluator) {
        this.modelNode = securedItem.getModelNode();
        this.actions = SecurityEvaluator.Util.asSet(new SecurityEvaluator.Action[]{action});
        this.evaluator = evaluator;
        this.principal = evaluator.getPrincipal();
    }

    public PermTripleFilter(SecurityEvaluator.Action[] actions, SecuredItem securedItem) {
        this.modelNode = securedItem.getModelNode();
        this.actions = SecurityEvaluator.Util.asSet(actions);
        this.evaluator = securedItem.getSecurityEvaluator();
        this.principal = this.evaluator.getPrincipal();
    }

    public PermTripleFilter(SecurityEvaluator.Action[] actions, SecuredItem securedItem, SecurityEvaluator evaluator) {
        this.modelNode = securedItem.getModelNode();
        this.actions = SecurityEvaluator.Util.asSet(actions);
        this.evaluator = evaluator;
        this.principal = evaluator.getPrincipal();
    }

    public PermTripleFilter(Collection<SecurityEvaluator.Action> actions, SecuredItem securedItem) {
        this.modelNode = securedItem.getModelNode();
        this.actions = SecurityEvaluator.Util.asSet(actions);
        this.evaluator = securedItem.getSecurityEvaluator();
        this.principal = this.evaluator.getPrincipal();
    }

    public PermTripleFilter(Collection<SecurityEvaluator.Action> actions, SecuredItem securedItem, SecurityEvaluator evaluator) {
        this.modelNode = securedItem.getModelNode();
        this.actions = SecurityEvaluator.Util.asSet(actions);
        this.evaluator = evaluator;
        this.principal = evaluator.getPrincipal();
    }

    @Override
    public boolean test(Triple triple) throws AuthenticationRequiredException {
        return this.evaluator.evaluateAny(this.principal, this.actions, this.modelNode, triple);
    }
}

