/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.query;

import org.apache.jena.graph.Graph;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.graph.SecuredGraph;
import org.apache.jena.permissions.query.SecuredQueryEngine;
import org.apache.jena.permissions.query.SecuredQueryEngineConfig;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class SecuredQueryEngineFactory
implements QueryEngineFactory {
    private boolean silentService = true;
    private SecuredQueryEngineConfig cfgResource;
    private SecurityEvaluator securityEvaluator;
    private static SecuredQueryEngineFactory factory = new SecuredQueryEngineFactory();

    public static SecuredQueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    public SecurityEvaluator getSecurityEvaluator() {
        return this.securityEvaluator;
    }

    public void setSecurityEvaluator(SecurityEvaluator securityEvaluator) {
        this.securityEvaluator = securityEvaluator;
    }

    public boolean isSilentService() {
        return this.silentService;
    }

    public void setSilentService(boolean silentService) {
        this.silentService = silentService;
    }

    public void setSecuredQueryEngineConfig(SecuredQueryEngineConfig cfgResource) {
        this.cfgResource = cfgResource;
    }

    public boolean accept(Query query, DatasetGraph dataset, Context context) {
        Graph g = dataset.getDefaultGraph();
        return g instanceof SecuredGraph;
    }

    public Plan create(Query query, DatasetGraph dataset, Binding initial, Context context) {
        if (this.cfgResource != null) {
            this.cfgResource.initializeContext(context);
        }
        SecuredQueryEngine engine = new SecuredQueryEngine(query, dataset, initial, context);
        return engine.getPlan();
    }

    public boolean accept(Op op, DatasetGraph dataset, Context context) {
        return false;
    }

    public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
        throw new ARQInternalErrorException(this.getClass().getSimpleName() + ": factory called directly with an algebra expression");
    }
}

