/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredLiteral;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.SecuredStatement;
import org.apache.jena.permissions.model.SecuredStatementTerm;
import org.apache.jena.permissions.model.impl.SecuredRDFNodeImpl;
import org.apache.jena.permissions.model.impl.SecuredStatementImpl;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.RDFVisitor;
import org.apache.jena.rdf.model.ResourceRequiredException;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StatementTerm;

public class SecuredStatementTermImpl
extends SecuredRDFNodeImpl
implements SecuredStatementTerm {
    private final ItemHolder<StatementTerm, SecuredStatementTerm> holder;
    private final SecuredModel securedModel;

    public static SecuredStatementTerm getInstance(SecuredModel securedModel, StatementTerm stmtTerm) {
        if (securedModel == null) {
            throw new IllegalArgumentException("Secured securedModel may not be null");
        }
        if (stmtTerm == null) {
            throw new IllegalArgumentException("StatemenTerm may not be null");
        }
        ItemHolder<StatementTerm, SecuredStatementTerm> holder = new ItemHolder<StatementTerm, SecuredStatementTerm>(stmtTerm);
        SecuredStatementTermImpl checker = new SecuredStatementTermImpl(securedModel, holder);
        if (stmtTerm instanceof SecuredStatementTerm && checker.isEquivalent((SecuredStatement)stmtTerm)) {
            return (SecuredStatementTerm)stmtTerm;
        }
        return holder.setSecuredItem(new SecuredItemInvoker(holder.getBaseItem().getClass(), checker));
    }

    private SecuredStatementTermImpl(SecuredModel securedModel, ItemHolder<StatementTerm, SecuredStatementTerm> holder) {
        super(securedModel, holder);
        this.holder = holder;
        this.securedModel = securedModel;
    }

    public SecuredLiteral asLiteral() {
        this.checkRead();
        throw new LiteralRequiredException(this.asNode());
    }

    public SecuredResource asResource() {
        this.checkRead();
        throw new ResourceRequiredException(this.asNode());
    }

    public SecuredStatementTerm asStatementTerm() {
        this.checkRead();
        return this;
    }

    public Statement getStatement() {
        this.checkRead();
        return SecuredStatementImpl.getInstance(this.securedModel, this.holder.getBaseItem().getStatement());
    }

    public Object visitWith(RDFVisitor rv) {
        return rv.visitStmt((StatementTerm)this, this.getStatement());
    }
}

