/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredStatement;
import org.apache.jena.permissions.model.impl.SecuredStatementImpl;
import org.apache.jena.permissions.utils.PermStatementFilter;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SecuredStatementIterator
implements StmtIterator {
    private final ExtendedIterator<Statement> iter;

    public SecuredStatementIterator(SecuredModel securedModel, ExtendedIterator<Statement> wrapped) {
        PermStatementFilter filter = new PermStatementFilter(new SecurityEvaluator.Action[]{SecurityEvaluator.Action.Read}, (SecuredItem)securedModel);
        PermStatementMap map1 = new PermStatementMap(securedModel);
        this.iter = wrapped.filterKeep((Predicate)filter).mapWith((Function)map1);
    }

    public <X extends Statement> ExtendedIterator<Statement> andThen(Iterator<X> other) {
        return this.iter.andThen(other);
    }

    public void close() {
        this.iter.close();
    }

    public ExtendedIterator<Statement> filterDrop(Predicate<Statement> f) {
        return this.iter.filterDrop(f);
    }

    public ExtendedIterator<Statement> filterKeep(Predicate<Statement> f) {
        return this.iter.filterKeep(f);
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public <U> ExtendedIterator<U> mapWith(Function<Statement, U> map1) {
        return this.iter.mapWith(map1);
    }

    public Statement next() {
        return (Statement)this.iter.next();
    }

    public Statement nextStatement() throws NoSuchElementException {
        return this.next();
    }

    public void remove() {
        this.iter.remove();
    }

    public Statement removeNext() {
        return (Statement)this.iter.removeNext();
    }

    public List<Statement> toList() {
        return this.iter.toList();
    }

    public Set<Statement> toSet() {
        return this.iter.toSet();
    }

    private class PermStatementMap
    implements Function<Statement, Statement> {
        private final SecuredModel securedModel;

        public PermStatementMap(SecuredModel securedModel) {
            this.securedModel = securedModel;
        }

        @Override
        public SecuredStatement apply(Statement o) {
            return SecuredStatementImpl.getInstance(this.securedModel, o);
        }
    }
}

