/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredRDFList;
import org.apache.jena.permissions.model.SecuredRDFNode;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.impl.SecuredRDFNodeImpl;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.permissions.utils.RDFListIterator;
import org.apache.jena.permissions.utils.RDFListSecFilter;
import org.apache.jena.rdf.model.EmptyListException;
import org.apache.jena.rdf.model.EmptyListUpdateException;
import org.apache.jena.rdf.model.InvalidListException;
import org.apache.jena.rdf.model.ListIndexException;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDF;

public class SecuredRDFListImpl
extends SecuredResourceImpl
implements SecuredRDFList {
    private static Function<RDFList, RDFNode> valueMapper = new Function<RDFList, RDFNode>(){

        @Override
        public RDFNode apply(RDFList lst) {
            return lst.getRequiredProperty(RDF.first).getObject();
        }
    };
    private final ItemHolder<RDFList, SecuredRDFList> holder;

    private SecuredRDFNode extractSecuredNode(RDFList lst) {
        return SecuredRDFNodeImpl.getInstance(this.getModel(), lst.getRequiredProperty(RDF.first).getObject());
    }

    public static <T extends RDFList> SecuredRDFList getInstance(SecuredModel securedModel, T rdfList) {
        if (securedModel == null) {
            throw new IllegalArgumentException("Secured securedModel may not be null");
        }
        if (rdfList == null) {
            throw new IllegalArgumentException("RDFList may not be null");
        }
        Object goodList = rdfList;
        if (goodList.getModel() == null) {
            goodList = securedModel.createList(rdfList.asJavaList().iterator());
        }
        ItemHolder<RDFList, SecuredRDFList> holder = new ItemHolder<RDFList, SecuredRDFList>((RDFList)goodList);
        SecuredRDFListImpl checker = new SecuredRDFListImpl(securedModel, holder);
        if (goodList instanceof SecuredRDFList && checker.isEquivalent((SecuredRDFList)goodList)) {
            return (SecuredRDFList)goodList;
        }
        return holder.setSecuredItem(new SecuredItemInvoker(rdfList.getClass(), checker));
    }

    protected SecuredRDFListImpl(SecuredModel securedModel, ItemHolder<RDFList, SecuredRDFList> holder) {
        super(securedModel, (ItemHolder<? extends Resource, ? extends SecuredResource>)holder);
        this.holder = holder;
    }

    public void add(RDFNode value) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreateNewList(value, RDF.nil);
        this.holder.getBaseItem().add(value);
    }

    public RDFList append(Iterator<? extends RDFNode> nodes) throws ReadDeniedException, AuthenticationRequiredException {
        SecuredRDFList copy = this.copy();
        if (nodes.hasNext()) {
            if (((RDFList)copy.getBaseItem()).size() > 0) {
                copy.concatenate(copy.getModel().createList(nodes));
            } else {
                copy = (SecuredRDFList)copy.getModel().createList(nodes);
            }
        }
        return copy;
    }

    public RDFList append(RDFList list) throws ReadDeniedException, AuthenticationRequiredException {
        return this.append((Iterator<? extends RDFNode>)list.iterator());
    }

    public void apply(RDFList.ApplyFn fn) throws ReadDeniedException, AuthenticationRequiredException {
        try (ExtendedIterator<RDFNode> i = this.iterator();){
            while (i.hasNext()) {
                fn.apply((RDFNode)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Set<SecurityEvaluator.Action> perms, RDFList.ApplyFn fn) throws ReadDeniedException, AuthenticationRequiredException {
        try (ExtendedIterator<RDFNode> i = this.iterator(perms);){
            while (i.hasNext()) {
                fn.apply((RDFNode)i.next());
            }
        }
    }

    public List<RDFNode> asJavaList() throws ReadDeniedException, AuthenticationRequiredException {
        return this.iterator().toList();
    }

    private RDFList baseRemove(RDFList val) {
        RDFList prev = null;
        RDFList cell = this.holder.getBaseItem();
        boolean searching = true;
        while (!cell.isEmpty()) {
            if (cell.equals(val)) {
                RDFList tail = cell.getTail();
                if (prev != null) {
                    prev.setTail(tail);
                }
                cell.removeProperties();
                return prev == null ? tail : this;
            }
            prev = cell;
            cell = cell.getTail();
        }
        return this;
    }

    private void checkCreateNewList(RDFNode value, Resource tail) throws AddDeniedException, AuthenticationRequiredException {
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.first.asNode(), (Node)value.asNode()));
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.rest.asNode(), (Node)tail.asNode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Statement> collectStatements(Set<SecurityEvaluator.Action> actions) {
        HashSet<Statement> stmts = new HashSet<Statement>();
        try (ExtendedIterator iter = WrappedIterator.create((Iterator)new RDFListIterator(this.holder.getBaseItem())).filterKeep(new RDFListSecFilter((SecuredItem)this, actions));){
            while (iter.hasNext()) {
                stmts.addAll(((RDFList)iter.next()).listProperties().toSet());
            }
            HashSet<Statement> hashSet = stmts;
            return hashSet;
        }
    }

    public void concatenate(Iterator<? extends RDFNode> nodes) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (this.holder.getBaseItem().isEmpty()) {
            throw new EmptyListUpdateException("Tried to concatenate onto the empty list");
        }
        Triple t = Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.first.asNode(), (Node)Node.ANY);
        if (!this.canCreate(t)) {
            ArrayList<RDFNode> list = new ArrayList<RDFNode>();
            while (nodes.hasNext()) {
                RDFNode n = nodes.next();
                t = Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.first.asNode(), (Node)n.asNode());
                this.checkCreate(t);
                list.add(n);
            }
            this.holder.getBaseItem().concatenate(list.iterator());
        } else {
            this.holder.getBaseItem().concatenate(nodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concatenate(RDFList list) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (this.holder.getBaseItem().isEmpty()) {
            throw new EmptyListUpdateException("Tried to concatenate onto the empty list");
        }
        Triple t = Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.first.asNode(), (Node)Node.ANY);
        if (!this.canCreate(t)) {
            try (ExtendedIterator iter = list.iterator();){
                while (iter.hasNext()) {
                    t = Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.first.asNode(), (Node)((RDFNode)iter.next()).asNode());
                    this.checkCreate(t);
                }
            }
        }
        this.holder.getBaseItem().concatenate(list);
    }

    public SecuredRDFList cons(RDFNode value) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreateNewList(value, (Resource)this.holder.getBaseItem());
        return SecuredRDFListImpl.getInstance(this.getModel(), this.holder.getBaseItem().cons(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RDFNode value) throws ReadDeniedException, AuthenticationRequiredException {
        try (ExtendedIterator<RDFNode> iter = this.iterator();){
            while (iter.hasNext()) {
                if (!value.equals(iter.next())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public SecuredRDFList copy() throws ReadDeniedException, AuthenticationRequiredException {
        ExtendedIterator iter;
        this.checkUpdate();
        SecuredRDFList retval = null;
        retval = this.checkSoftRead() ? ((iter = this.getFilteredRDFListIterator(SecurityEvaluator.Action.Read).mapWith(valueMapper)).hasNext() ? (SecuredRDFList)this.getModel().createList((Iterator)iter) : (SecuredRDFList)this.getModel().createList()) : (SecuredRDFList)this.getModel().createList();
        return retval;
    }

    public RDFNode get(int i) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            int idx = 0;
            try (ExtendedIterator<RDFList> iter = this.getFilteredRDFListIterator(SecurityEvaluator.Action.Read);){
                while (iter.hasNext()) {
                    if (i == idx) {
                        SecuredRDFNode securedRDFNode = this.extractSecuredNode((RDFList)iter.next());
                        return securedRDFNode;
                    }
                    ++idx;
                    iter.next();
                }
                throw new ListIndexException();
            }
        }
        throw new ListIndexException();
    }

    public RDFNode getHead() throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Statement s = this.holder.getBaseItem().getRequiredProperty(RDF.first);
            this.checkRead((FrontsTriple)s);
            return SecuredRDFNodeImpl.getInstance(this.getModel(), s.getObject());
        }
        throw new ListIndexException();
    }

    private ExtendedIterator<RDFList> getFilteredRDFListIterator(SecurityEvaluator.Action perm) {
        return WrappedIterator.create((Iterator)new RDFListIterator(this.holder.getBaseItem())).filterKeep(new RDFListSecFilter((SecuredItem)this, perm));
    }

    private ExtendedIterator<RDFList> getFilteredRDFListIterator(Set<SecurityEvaluator.Action> perm) {
        return WrappedIterator.create((Iterator)new RDFListIterator(this.holder.getBaseItem())).filterKeep(new RDFListSecFilter((SecuredItem)this, perm));
    }

    public boolean getStrict() {
        return this.holder.getBaseItem().getStrict();
    }

    public SecuredRDFList getTail() throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Statement s = this.holder.getBaseItem().getRequiredProperty(RDF.rest);
            this.checkRead((FrontsTriple)s);
            return SecuredRDFListImpl.getInstance(this.getModel(), (RDFList)s.getObject().as(RDFList.class));
        }
        throw new ListIndexException();
    }

    public String getValidityErrorMessage() throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().getValidityErrorMessage() : null;
    }

    public int indexOf(RDFNode value) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(RDFNode value, int start) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            try (ExtendedIterator<RDFList> iter = this.getFilteredRDFListIterator(SecurityEvaluator.Action.Read);){
                int retval;
                for (retval = 0; iter.hasNext() && retval < start; ++retval) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    if (value.equals(valueMapper.apply((RDFList)iter.next()))) {
                        int n = retval;
                        return n;
                    }
                    ++retval;
                }
                int n = -1;
                return n;
            }
        }
        return -1;
    }

    public boolean isEmpty() throws ReadDeniedException, AuthenticationRequiredException {
        try (ExtendedIterator<RDFNode> iter = this.iterator();){
            boolean bl = !iter.hasNext();
            return bl;
        }
    }

    public boolean isValid() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().isValid();
    }

    public ExtendedIterator<RDFNode> iterator() throws ReadDeniedException, AuthenticationRequiredException {
        return this.iterator(Set.of());
    }

    @Override
    public ExtendedIterator<RDFNode> iterator(Set<SecurityEvaluator.Action> constraints) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            HashSet<SecurityEvaluator.Action> req = new HashSet<SecurityEvaluator.Action>(constraints);
            req.add(SecurityEvaluator.Action.Read);
            return this.getFilteredRDFListIterator(req).mapWith(valueMapper).mapWith(r -> SecuredRDFNodeImpl.getInstance(this.getModel(), r));
        }
        return NiceIterator.emptyIterator();
    }

    public <T> ExtendedIterator<T> mapWith(Function<RDFNode, T> fn) throws ReadDeniedException, AuthenticationRequiredException {
        return this.iterator().mapWith(fn);
    }

    public Object reduce(RDFList.ReduceFn fn, Object initial) throws ReadDeniedException, AuthenticationRequiredException {
        Object acc = initial;
        ExtendedIterator<RDFNode> i = this.iterator();
        while (i.hasNext()) {
            acc = fn.reduce((RDFNode)i.next(), acc);
        }
        return acc;
    }

    @Override
    public Object reduce(Set<SecurityEvaluator.Action> requiredActions, RDFList.ReduceFn fn, Object initial) throws EmptyListException, ListIndexException, InvalidListException, ReadDeniedException, AuthenticationRequiredException {
        Object acc = initial;
        HashSet<SecurityEvaluator.Action> perms = new HashSet<SecurityEvaluator.Action>(requiredActions);
        perms.add(SecurityEvaluator.Action.Read);
        ExtendedIterator<RDFNode> i = this.iterator(perms);
        while (i.hasNext()) {
            acc = fn.reduce((RDFNode)i.next(), acc);
        }
        return acc;
    }

    public RDFList remove(RDFNode val) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.create((Node)Node.ANY, (Node)RDF.first.asNode(), (Node)val.asNode()))) {
            RDFList cell = null;
            ExtendedIterator<RDFList> iter = this.getFilteredRDFListIterator(SecurityEvaluator.Action.Delete);
            while (iter.hasNext()) {
                cell = (RDFList)iter.next();
                if (!val.equals(valueMapper.apply(cell))) continue;
                return SecuredRDFListImpl.getInstance(this.getModel(), this.baseRemove(cell));
            }
            throw new DeleteDeniedException(SecuredItem.Util.triplePermissionMsg(this.getModelNode()));
        }
        return SecuredRDFListImpl.getInstance(this.getModel(), this.holder.getBaseItem().remove(val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredRDFList removeHead() throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        try (ExtendedIterator<RDFList> iter = this.getFilteredRDFListIterator(SecurityEvaluator.Action.Read);){
            if (!iter.hasNext()) {
                throw new EmptyListException("Attempted to delete the head of a nil list");
            }
            RDFList cell = (RDFList)iter.next();
            Statement s = cell.getRequiredProperty(RDF.first);
            this.checkDelete((FrontsTriple)s);
            SecuredRDFList securedRDFList = SecuredRDFListImpl.getInstance(this.getModel(), this.baseRemove(cell));
            return securedRDFList;
        }
    }

    public void removeList() throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple t = Triple.create((Node)Node.ANY, (Node)RDF.first.asNode(), (Node)Node.ANY);
        Set<SecurityEvaluator.Action> perms = SecurityEvaluator.Util.asSet(new SecurityEvaluator.Action[]{SecurityEvaluator.Action.Delete, SecurityEvaluator.Action.Read});
        if (this.getSecurityEvaluator().evaluate(this.getSecurityEvaluator().getPrincipal(), perms, this.getModelNode(), t)) {
            this.holder.getBaseItem().removeList();
        } else {
            for (Statement s : this.collectStatements(perms)) {
                if (!this.canDelete((FrontsTriple)s)) continue;
                s.remove();
            }
        }
    }

    public SecuredRDFNode replace(int i, RDFNode value) throws UpdateDeniedException, AuthenticationRequiredException, ListIndexException {
        this.checkUpdate();
        int idx = 0;
        try (ExtendedIterator<RDFList> iter = this.getFilteredRDFListIterator(SecurityEvaluator.Action.Read);){
            while (iter.hasNext()) {
                if (i == idx) {
                    RDFList list = (RDFList)iter.next();
                    RDFNode retval = list.getRequiredProperty(RDF.first).getObject();
                    Triple t = Triple.create((Node)list.asNode(), (Node)RDF.first.asNode(), (Node)retval.asNode());
                    Triple t2 = Triple.create((Node)list.asNode(), (Node)RDF.first.asNode(), (Node)value.asNode());
                    this.checkUpdate(t, t2);
                    list.getRequiredProperty(RDF.first).changeObject(value);
                    SecuredRDFNode securedRDFNode = SecuredRDFNodeImpl.getInstance(this.getModel(), retval);
                    return securedRDFNode;
                }
                ++idx;
                iter.next();
            }
            throw new ListIndexException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sameListAs(RDFList list) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            ExtendedIterator<RDFNode> thisIter = null;
            ExtendedIterator thatIter = null;
            try {
                thisIter = this.iterator();
                thatIter = list.iterator();
                while (thisIter.hasNext() && thatIter.hasNext()) {
                    RDFNode thisN = (RDFNode)thisIter.next();
                    RDFNode thatN = (RDFNode)thatIter.next();
                    if (thisN != null && thisN.equals(thatN)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !thisIter.hasNext() && !thatIter.hasNext();
                return bl;
            }
            finally {
                if (thisIter != null) {
                    thisIter.close();
                }
                if (thatIter != null) {
                    thatIter.close();
                }
            }
        }
        return list.isEmpty();
    }

    public SecuredRDFNode setHead(RDFNode value) throws EmptyListException, AuthenticationRequiredException {
        try {
            return this.replace(0, value);
        }
        catch (ListIndexException e) {
            throw new EmptyListException("Tried to set the head of an empty list");
        }
    }

    public void setStrict(boolean strict) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().setStrict(strict);
    }

    public SecuredRDFList setTail(RDFList tail) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Statement rest = this.holder.getBaseItem().getRequiredProperty(RDF.rest);
        RDFNode retval = rest.getObject();
        Triple t = Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.rest.asNode(), (Node)retval.asNode());
        Triple t2 = Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.rest.asNode(), (Node)tail.asNode());
        this.checkUpdate(t, t2);
        rest.changeObject((RDFNode)tail);
        return SecuredRDFListImpl.getInstance(this.getModel(), (RDFList)retval.as(RDFList.class));
    }

    public int size() throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Triple t = Triple.create((Node)Node.ANY, (Node)RDF.first.asNode(), (Node)Node.ANY);
            if (this.canRead(t)) {
                return this.holder.getBaseItem().size();
            }
            ExtendedIterator<RDFNode> iter = this.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ++i;
                iter.next();
            }
            return i;
        }
        return 0;
    }

    public SecuredRDFList with(RDFNode value) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.first.asNode(), (Node)value.asNode()));
        return SecuredRDFListImpl.getInstance(this.getModel(), this.holder.getBaseItem().with(value));
    }
}

