/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.Factory;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.graph.SecuredGraph;
import org.apache.jena.permissions.graph.SecuredPrefixMapping;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemImpl;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredAlt;
import org.apache.jena.permissions.model.SecuredBag;
import org.apache.jena.permissions.model.SecuredLiteral;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredProperty;
import org.apache.jena.permissions.model.SecuredRDFList;
import org.apache.jena.permissions.model.SecuredRDFNode;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.SecuredSeq;
import org.apache.jena.permissions.model.SecuredStatement;
import org.apache.jena.permissions.model.impl.SecuredAltImpl;
import org.apache.jena.permissions.model.impl.SecuredBagImpl;
import org.apache.jena.permissions.model.impl.SecuredLiteralImpl;
import org.apache.jena.permissions.model.impl.SecuredNodeIterator;
import org.apache.jena.permissions.model.impl.SecuredPropertyImpl;
import org.apache.jena.permissions.model.impl.SecuredRDFListImpl;
import org.apache.jena.permissions.model.impl.SecuredRDFNodeImpl;
import org.apache.jena.permissions.model.impl.SecuredResIterator;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.permissions.model.impl.SecuredSeqImpl;
import org.apache.jena.permissions.model.impl.SecuredStatementImpl;
import org.apache.jena.permissions.model.impl.SecuredStatementIterator;
import org.apache.jena.permissions.model.impl.SecuredStatementTermImpl;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NsIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StatementTerm;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.NsIteratorImpl;
import org.apache.jena.rdf.model.impl.RDFReaderFImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.shared.AccessDeniedException;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.shared.WrappedIOException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDF;

public class SecuredModelImpl
extends SecuredItemImpl
implements SecuredModel {
    private static final RDFReaderF readerFactory = new RDFReaderFImpl();
    private final ItemHolder<Model, SecuredModel> holder;
    private final SecuredGraph graph;
    private Map<ModelChangedListener, SecuredModelChangedListener> listeners = new HashMap<ModelChangedListener, SecuredModelChangedListener>();

    public static SecuredModel getInstance(SecuredItem securedItem, Model model) {
        return Factory.getInstance(securedItem.getSecurityEvaluator(), securedItem.getModelIRI(), model);
    }

    public static SecuredModel getInstance(SecurityEvaluator securityEvaluator, String modelIRI, Model model) {
        ItemHolder<Model, SecuredModel> holder = new ItemHolder<Model, SecuredModel>(model);
        SecuredModelImpl checker = new SecuredModelImpl(securityEvaluator, modelIRI, holder);
        if (model instanceof SecuredModel && checker.isEquivalent((SecuredModel)model)) {
            return (SecuredModel)model;
        }
        return holder.setSecuredItem(new SecuredItemInvoker(model.getClass(), checker));
    }

    private SecuredModelImpl(SecurityEvaluator securityEvaluator, String modelURI, ItemHolder<Model, SecuredModel> holder) {
        super(securityEvaluator, modelURI, holder);
        this.graph = Factory.getInstance(securityEvaluator, modelURI, holder.getBaseItem().getGraph());
        this.holder = holder;
    }

    private SecuredStatementIterator stmtIterator(Supplier<ExtendedIterator<Statement>> supplier) throws ReadDeniedException, AuthenticationRequiredException {
        ExtendedIterator<Statement> iter = this.checkSoftRead() ? supplier.get() : NiceIterator.emptyIterator();
        return new SecuredStatementIterator(this.holder.getSecuredItem(), iter);
    }

    private SecuredResIterator resIterator(Supplier<ExtendedIterator<Resource>> supplier, ResourceFilter filter) {
        ExtendedIterator rIter = null;
        if (this.checkSoftRead()) {
            rIter = supplier.get();
            if (!this.canRead(Triple.ANY)) {
                rIter = rIter.filterKeep((Predicate)filter);
            }
        } else {
            rIter = NiceIterator.emptyIterator();
        }
        return new SecuredResIterator(this.holder.getSecuredItem(), rIter);
    }

    private RDFNode asObject(Object o) {
        return o instanceof RDFNode ? (RDFNode)o : ResourceFactory.createTypedLiteral((Object)o);
    }

    public SecuredModel abort() {
        this.holder.getBaseItem().abort();
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(List<Statement> statements) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(() -> WrappedIterator.create(statements.iterator()).mapWith(s -> s.asTriple()));
        this.holder.getBaseItem().add(statements);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Model m) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(() -> m.listStatements().mapWith(s -> s.asTriple()));
        this.holder.getBaseItem().add(m);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Resource s, Property p, RDFNode o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)o.asNode()));
        this.holder.getBaseItem().add(s, p, o);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Resource s, Property p, String o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)NodeFactory.createLiteralLang((String)o, (String)"")));
        this.holder.getBaseItem().add(s, p, o);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Resource s, Property p, String lex, RDFDatatype datatype) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)NodeFactory.createLiteral((String)lex, (RDFDatatype)datatype)));
        this.holder.getBaseItem().add(s, p, lex, datatype);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Resource s, Property p, String o, String l) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)NodeFactory.createLiteralLang((String)o, (String)l)));
        this.holder.getBaseItem().add(s, p, o, l);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Resource s, Property p, String o, String l, String dir) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)NodeFactory.createLiteralDirLang((String)o, (String)l, (String)dir)));
        this.holder.getBaseItem().add(s, p, o, l, dir);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Statement s) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate((FrontsTriple)s);
        this.holder.getBaseItem().add(s);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(Statement[] statements) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(() -> WrappedIterator.create(Arrays.asList(statements).iterator()).mapWith(s -> s.asTriple()));
        this.holder.getBaseItem().add(statements);
        return this.holder.getSecuredItem();
    }

    public SecuredModel add(StmtIterator iter) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        StmtIterator updateFrom = iter;
        if (!this.canCreate(Triple.ANY)) {
            List stmt = iter.filterKeep(s -> {
                this.checkCreate((FrontsTriple)s);
                return true;
            }).toList();
            updateFrom = new StmtIteratorImpl(stmt.iterator());
        }
        this.holder.getBaseItem().add(updateFrom);
        return this.holder.getSecuredItem();
    }

    public SecuredModel addLiteral(Resource s, Property p, boolean o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredModel addLiteral(Resource s, Property p, char o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Character.valueOf(o)));
    }

    public SecuredModel addLiteral(Resource s, Property p, double o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredModel addLiteral(Resource s, Property p, float o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Float.valueOf(o)));
    }

    public SecuredModel addLiteral(Resource s, Property p, int o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredModel addLiteral(Resource s, Property p, Literal o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(s, p, (RDFNode)o);
    }

    public SecuredModel addLiteral(Resource s, Property p, long o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredRDFNode asRDFNode(Node n) {
        return SecuredRDFNodeImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().asRDFNode(n));
    }

    public SecuredStatement asStatement(Triple t) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        ExtendedIterator iter = this.holder.getBaseItem().getGraph().find(t);
        boolean exists = iter.hasNext();
        iter.close();
        if (exists && this.canRead() && this.canRead(t) || this.canUpdate() && this.canCreate(t)) {
            return SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().asStatement(t));
        }
        throw new AccessDeniedException(String.format("Converting %s to Statement", t));
    }

    public SecuredModel begin() {
        this.holder.getBaseItem().begin();
        return this.holder.getSecuredItem();
    }

    public void close() {
        this.holder.getBaseItem().close();
    }

    public SecuredModel commit() {
        this.holder.getBaseItem().commit();
        return this.holder.getSecuredItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAny(Supplier<ExtendedIterator<Statement>> supplier) {
        if (this.checkSoftRead()) {
            try (ExtendedIterator<Statement> iter = supplier.get();){
                boolean bl = iter.filterKeep(stmt -> this.canRead((FrontsTriple)stmt)).hasNext();
                return bl;
            }
        }
        return false;
    }

    public boolean contains(Resource s, Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.containsAny(() -> this.holder.getBaseItem().listStatements(s, p, (RDFNode)null));
    }

    public boolean contains(Resource s, Property p, RDFNode o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.containsAny(() -> this.holder.getBaseItem().listStatements(s, p, o));
    }

    public boolean contains(Resource s, Property p, String o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.containsAny(() -> this.holder.getBaseItem().listStatements(s, p, o));
    }

    public boolean contains(Resource s, Property p, String o, String l) throws ReadDeniedException, AuthenticationRequiredException {
        return this.containsAny(() -> this.holder.getBaseItem().listStatements(s, p, o, l));
    }

    public boolean contains(Resource s, Property p, String o, String l, String dir) throws ReadDeniedException, AuthenticationRequiredException {
        return this.containsAny(() -> this.holder.getBaseItem().listStatements(s, p, o, l, dir));
    }

    public boolean contains(Statement s) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() && this.canRead((FrontsTriple)s) ? this.holder.getBaseItem().contains(s) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAll(Supplier<StmtIterator> supplier) {
        try (StmtIterator iter = supplier.get();){
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                if (this.canRead((FrontsTriple)stmt) && this.holder.getBaseItem().contains(stmt)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public boolean containsAll(Model model) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().containsAll(model);
            }
            return this.containsAll(() -> model.listStatements());
        }
        return false;
    }

    public boolean containsAll(StmtIterator iter) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().containsAll(iter);
            }
            return this.containsAll(() -> iter);
        }
        return false;
    }

    public boolean containsAny(Model model) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().containsAll(model);
            }
            this.containsAny(() -> model.listStatements());
        }
        return false;
    }

    public boolean containsAny(StmtIterator iter) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().containsAny(iter);
            }
            this.containsAny(() -> iter);
        }
        return false;
    }

    public boolean containsLiteral(Resource s, Property p, boolean o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public boolean containsLiteral(Resource s, Property p, char o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Character.valueOf(o)));
    }

    public boolean containsLiteral(Resource s, Property p, double o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public boolean containsLiteral(Resource s, Property p, float o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Float.valueOf(o)));
    }

    public boolean containsLiteral(Resource s, Property p, int o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public boolean containsLiteral(Resource s, Property p, long o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public boolean containsLiteral(Resource s, Property p, Object o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(s, p, this.asObject(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsResource(RDFNode r) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().containsResource(r);
            }
            SecuredStatementIterator iter = this.listStatements(null, null, r);
            if (r.isResource()) {
                iter = r.isURIResource() ? iter.andThen((Iterator)((Object)this.listStatements(null, ResourceFactory.createProperty((String)r.asNode().getURI()), (RDFNode)null))) : iter.andThen((Iterator)((Object)this.listStatements(null, ResourceFactory.createProperty((String)r.asNode().getBlankNodeLabel()), (RDFNode)null)));
                iter = iter.andThen((Iterator)((Object)this.listStatements(r.asResource(), null, (RDFNode)null)));
            }
            try {
                boolean bl = iter.hasNext();
                return bl;
            }
            finally {
                iter.close();
            }
        }
        return false;
    }

    public SecuredAlt createAlt() throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.type.asNode(), (Node)RDF.Alt.asNode()));
        return SecuredAltImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createAlt());
    }

    public SecuredAlt createAlt(String uri) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)NodeFactory.createURI((String)uri), (Node)RDF.type.asNode(), (Node)RDF.Alt.asNode()));
        return SecuredAltImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createAlt(uri));
    }

    public SecuredBag createBag() throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.type.asNode(), (Node)RDF.Bag.asNode()));
        return SecuredBagImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createBag());
    }

    public SecuredBag createBag(String uri) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)NodeFactory.createURI((String)uri), (Node)RDF.type.asNode(), (Node)RDF.Bag.asNode()));
        return SecuredBagImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createBag(uri));
    }

    private Model createCopy() throws ReadDeniedException, AuthenticationRequiredException {
        return ModelFactory.createDefaultModel().add((Model)this.holder.getSecuredItem());
    }

    public SecuredRDFList createList() throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.type.asNode(), (Node)RDF.List.asNode()));
        return SecuredRDFListImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecuredRDFList createList(Supplier<ExtendedIterator<? extends RDFNode>> supplier) {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.type.asNode(), (Node)RDF.List.asNode()));
        ArrayList<RDFNode> lst = new ArrayList<RDFNode>();
        try (ExtendedIterator<? extends RDFNode> iter = supplier.get();){
            if (iter.hasNext()) {
                this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.rest.asNode(), (Node)RDF.nil.asNode()));
                this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.rest.asNode(), (Node)SecurityEvaluator.FUTURE));
            }
            while (iter.hasNext()) {
                RDFNode n = (RDFNode)iter.next();
                this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.first.asNode(), (Node)n.asNode()));
                lst.add(n);
            }
            SecuredRDFList securedRDFList = SecuredRDFListImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createList(lst.iterator()));
            return securedRDFList;
        }
    }

    public SecuredRDFList createList(Iterator<? extends RDFNode> members) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.createList(() -> WrappedIterator.create((Iterator)members));
    }

    public SecuredRDFList createList(RDFNode ... members) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.createList(() -> WrappedIterator.create(Arrays.asList(members).iterator()));
    }

    public SecuredLiteral createLiteral(String v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createLiteral(v));
    }

    public SecuredLiteral createLiteral(String v, String language) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createLiteral(v, language));
    }

    public SecuredLiteral createLiteral(String v, String language, String direction) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createLiteral(v, language, direction));
    }

    public SecuredStatement createLiteralStatement(Resource s, Property p, boolean o) {
        return this.createStatement(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredStatement createLiteralStatement(Resource s, Property p, char o) {
        return this.createStatement(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Character.valueOf(o)));
    }

    public SecuredStatement createLiteralStatement(Resource s, Property p, double o) {
        return this.createStatement(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredStatement createLiteralStatement(Resource s, Property p, float o) {
        return this.createStatement(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Float.valueOf(o)));
    }

    public SecuredStatement createLiteralStatement(Resource s, Property p, int o) {
        return this.createStatement(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredStatement createLiteralStatement(Resource s, Property p, long o) {
        return this.createStatement(s, p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredStatement createLiteralStatement(Resource s, Property p, Object o) {
        return this.createStatement(s, p, this.asObject(o));
    }

    public SecuredProperty createProperty(String uri) {
        return SecuredPropertyImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createProperty(uri));
    }

    public SecuredProperty createProperty(String nameSpace, String localName) {
        return SecuredPropertyImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createProperty(nameSpace, localName));
    }

    public SecuredResource createResource() {
        return SecuredResourceImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createResource());
    }

    public SecuredResource createResource(AnonId id) {
        return SecuredResourceImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createResource(id));
    }

    public SecuredResource createResource(Resource type) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple t = Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.type.asNode(), (Node)type.asNode());
        this.checkCreate(t);
        return SecuredResourceImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createResource(type));
    }

    public SecuredResource createResource(String uri) {
        return SecuredResourceImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createResource(uri));
    }

    public StatementTerm createStatementTerm(Statement statement) {
        return SecuredStatementTermImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createStatementTerm(statement));
    }

    public Resource createReifier(Resource reifier, Statement statement) {
        StatementTerm n = this.createStatementTerm(statement);
        SecuredStatement stmt = this.createStatement(reifier, RDF.reifies, (RDFNode)n);
        SecuredStatement stmtx = SecuredStatementImpl.getInstance(this, stmt);
        this.add(stmtx);
        return reifier;
    }

    private void checkReadOrUpdate(Resource s, Property p, RDFNode o) {
        if (!this.canReadOrUpdate(s, p, o)) {
            throw new AddDeniedException(String.format("Can not create Statement [ %s ,%s %s ]", s, p, o));
        }
    }

    private boolean canReadOrUpdate(Resource s, Property p, RDFNode o) {
        boolean canExecute;
        Triple t = Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)o.asNode());
        boolean bl = canExecute = this.canUpdate() && this.canCreate(t);
        if (!canExecute && this.holder.getBaseItem().contains(s, p, o)) {
            canExecute |= this.canRead() && this.canRead(t);
        }
        return canExecute;
    }

    public SecuredResource createResource(String uri, Resource type) throws AccessDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)type);
        return SecuredResourceImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createResource(uri, type));
    }

    public SecuredSeq createSeq() throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)SecurityEvaluator.FUTURE, (Node)RDF.type.asNode(), (Node)RDF.Alt.asNode()));
        return SecuredSeqImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createSeq());
    }

    public SecuredSeq createSeq(String uri) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)RDF.Alt);
        return SecuredSeqImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createSeq(uri));
    }

    public SecuredStatement createStatement(Resource s, Property p, RDFNode o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(s, p, o);
        return SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createStatement(s, p, o));
    }

    public SecuredStatement createStatement(Resource s, Property p, String o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(s, p, (RDFNode)ResourceFactory.createProperty((String)o));
        return SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createStatement(s, p, o));
    }

    public SecuredStatement createStatement(Resource s, Property p, String o, String l) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        Node n = NodeFactory.createLiteralLang((String)o, (String)l);
        this.checkReadOrUpdate(s, p, this.holder.getBaseItem().getRDFNode(n));
        return SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createStatement(s, p, o, l));
    }

    public SecuredLiteral createTypedLiteral(boolean v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(v));
    }

    public SecuredLiteral createTypedLiteral(Calendar d) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(d));
    }

    public SecuredLiteral createTypedLiteral(char v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(v));
    }

    public SecuredLiteral createTypedLiteral(double v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(v));
    }

    public SecuredLiteral createTypedLiteral(float v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(v));
    }

    public SecuredLiteral createTypedLiteral(int v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(v));
    }

    public SecuredLiteral createTypedLiteral(long v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(v));
    }

    public SecuredLiteral createTypedLiteral(Object value) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(value));
    }

    public SecuredLiteral createTypedLiteral(Object value, RDFDatatype dtype) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(value, dtype));
    }

    public SecuredLiteral createTypedLiteral(Object value, String typeURI) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(value, typeURI));
    }

    public SecuredLiteral createTypedLiteral(String v) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(v));
    }

    public SecuredLiteral createTypedLiteral(String lex, RDFDatatype dtype) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(lex, dtype));
    }

    public SecuredLiteral createTypedLiteral(String lex, String typeURI) {
        return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().createTypedLiteral(lex, typeURI));
    }

    public Model difference(Model model) throws AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().difference(model);
            }
            return this.createCopy().difference(model);
        }
        return ModelFactory.createDefaultModel();
    }

    public void enterCriticalSection(boolean readLockRequested) throws UpdateDeniedException, ReadDeniedException, AuthenticationRequiredException {
        this.holder.getBaseItem().enterCriticalSection(readLockRequested);
    }

    public void executeInTxn(Runnable action) {
        this.holder.getBaseItem().executeInTxn(action);
    }

    public <T> T calculateInTxn(Supplier<T> action) {
        return (T)this.holder.getBaseItem().calculateInTxn(action);
    }

    @Override
    public String expandPrefix(String prefixed) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().expandPrefix(prefixed) : prefixed;
    }

    public SecuredAlt getAlt(Resource r) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(r, RDF.type, (RDFNode)RDF.Alt);
        return SecuredAltImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getAlt(r));
    }

    public SecuredAlt getAlt(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)RDF.Alt);
        return SecuredAltImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getAlt(uri));
    }

    public SecuredBag getBag(Resource r) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(r, RDF.type, (RDFNode)RDF.Bag);
        return SecuredBagImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getBag(r));
    }

    public SecuredBag getBag(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)RDF.Bag);
        return SecuredBagImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getBag(uri));
    }

    public SecuredSeq getSeq(Resource r) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(r, RDF.type, (RDFNode)RDF.Seq);
        return SecuredSeqImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getSeq(r));
    }

    public SecuredSeq getSeq(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)RDF.Seq);
        return SecuredSeqImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getSeq(uri));
    }

    public SecuredRDFList getList(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(ResourceFactory.createResource((String)uri), RDF.type, (RDFNode)RDF.List);
        return SecuredRDFListImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getList(uri));
    }

    public SecuredRDFList getList(Resource r) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkReadOrUpdate(r, RDF.type, (RDFNode)RDF.List);
        return SecuredRDFListImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getList(r));
    }

    public SecuredGraph getGraph() {
        return this.graph;
    }

    public Lock getLock() {
        return this.holder.getBaseItem().getLock();
    }

    @Override
    public Map<String, String> getNsPrefixMap() throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().getNsPrefixMap() : Collections.emptyMap();
    }

    @Override
    public String getNsPrefixURI(String prefix) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().getNsPrefixURI(prefix) : null;
    }

    @Override
    public String getNsURIPrefix(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().getNsURIPrefix(uri) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecuredStatement _getProperty(Supplier<StmtIterator> supplier) {
        if (this.checkSoftRead()) {
            try (ExtendedIterator iter = supplier.get().filterKeep(s -> this.canRead((FrontsTriple)s));){
                SecuredStatement securedStatement = iter.hasNext() ? SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), (Statement)iter.next()) : null;
                return securedStatement;
            }
        }
        return null;
    }

    public SecuredStatement getProperty(Resource s, Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this._getProperty(() -> this.holder.getBaseItem().listStatements(s, p, (RDFNode)null));
    }

    public SecuredStatement getProperty(Resource s, Property p, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        return this._getProperty(() -> this.holder.getBaseItem().listStatements(s, p, null, lang));
    }

    public SecuredProperty getProperty(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredPropertyImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getProperty(uri));
    }

    public SecuredProperty getProperty(String nameSpace, String localName) throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredPropertyImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getProperty(nameSpace, localName));
    }

    public SecuredRDFNode getRDFNode(Node n) throws ReadDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        if (n.isLiteral()) {
            return SecuredLiteralImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getRDFNode(n).asLiteral());
        }
        if (n.isURI() || n.isBlank()) {
            return SecuredResourceImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getRDFNode(n).asResource());
        }
        throw new IllegalArgumentException("Illegal Node type: " + String.valueOf(n.getClass()));
    }

    public RDFReaderI getReader(String lang) {
        return this.holder.getBaseItem().getReader(lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredStatement getRequiredProperty(Resource s, Property p) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getRequiredProperty(s, p));
            }
            try (ExtendedIterator iter = this.holder.getBaseItem().listStatements(s, p, (RDFNode)null).filterKeep(f -> this.canRead((FrontsTriple)f));){
                if (iter.hasNext()) {
                    SecuredStatement securedStatement = SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), (Statement)iter.next());
                    return securedStatement;
                }
            }
        }
        throw new PropertyNotFoundException(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredStatement getRequiredProperty(Resource s, Property p, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().getRequiredProperty(s, p, lang));
            }
            try (ExtendedIterator iter = this.holder.getBaseItem().listStatements(s, p, null, lang).filterKeep(f -> this.canRead((FrontsTriple)f));){
                if (iter.hasNext()) {
                    SecuredStatement securedStatement = SecuredStatementImpl.getInstance(this.holder.getSecuredItem(), (Statement)iter.next());
                    return securedStatement;
                }
            }
        }
        throw new PropertyNotFoundException(p);
    }

    public SecuredResource getResource(String uri) {
        return this.createResource(uri);
    }

    public SecuredResource getResource(AnonId id) {
        return this.createResource(id);
    }

    public RDFWriterI getWriter(String lang) {
        return this.holder.getBaseItem().getWriter(lang);
    }

    public boolean independent() {
        return false;
    }

    public Model intersection(Model model) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            return this.canRead(Triple.ANY) ? this.holder.getBaseItem().intersection(model) : this.createCopy().intersection(model);
        }
        return ModelFactory.createDefaultModel();
    }

    public boolean isClosed() {
        return this.holder.getBaseItem().isClosed();
    }

    public boolean isEmpty() throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? !this.holder.getBaseItem().contains(this.holder.getBaseItem().asStatement(Triple.ANY)) : true;
    }

    public boolean isIsomorphicWith(Model g) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().isIsomorphicWith(g);
            }
            return this.createCopy().isIsomorphicWith(g);
        }
        return g.isEmpty();
    }

    public void leaveCriticalSection() {
        this.holder.getBaseItem().leaveCriticalSection();
    }

    public SecuredStatementIterator listLiteralStatements(Resource subject, Property predicate, boolean object) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listLiteralStatements(subject, predicate, object));
    }

    public SecuredStatementIterator listLiteralStatements(Resource subject, Property predicate, char object) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listLiteralStatements(subject, predicate, object));
    }

    public SecuredStatementIterator listLiteralStatements(Resource subject, Property predicate, double object) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listLiteralStatements(subject, predicate, object));
    }

    public SecuredStatementIterator listLiteralStatements(Resource subject, Property predicate, float object) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listLiteralStatements(subject, predicate, object));
    }

    public SecuredStatementIterator listLiteralStatements(Resource subject, Property predicate, long object) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listLiteralStatements(subject, predicate, object));
    }

    public SecuredStatementIterator listLiteralStatements(Resource subject, Property predicate, int object) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listLiteralStatements(subject, predicate, object));
    }

    public NsIterator listNameSpaces() throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().listNameSpaces() : new NsIteratorImpl(Collections.emptyIterator(), null);
    }

    private SecuredNodeIterator<RDFNode> nodeIterator(Supplier<ExtendedIterator<RDFNode>> supplier, Predicate<RDFNode> filter) {
        ExtendedIterator nIter = null;
        if (this.checkSoftRead()) {
            nIter = supplier.get();
            if (!this.canRead(Triple.ANY)) {
                nIter = nIter.filterKeep(filter);
            }
        } else {
            nIter = NiceIterator.emptyIterator();
        }
        return new SecuredNodeIterator<RDFNode>(this.holder.getSecuredItem(), nIter);
    }

    public SecuredNodeIterator<RDFNode> listObjects() throws ReadDeniedException, AuthenticationRequiredException {
        return this.nodeIterator(() -> this.holder.getBaseItem().listObjects(), new ObjectFilter());
    }

    public SecuredNodeIterator<RDFNode> listObjectsOfProperty(Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.nodeIterator(() -> this.holder.getBaseItem().listObjectsOfProperty(p), new ObjectFilter(p));
    }

    public SecuredNodeIterator<RDFNode> listObjectsOfProperty(Resource s, Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.nodeIterator(() -> this.holder.getBaseItem().listObjectsOfProperty(s, p), new ObjectFilter(p));
    }

    public SecuredResIterator listResourcesWithProperty(Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p), new ResourceFilter(p));
    }

    public SecuredResIterator listResourcesWithProperty(Property p, boolean o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p, o), new ResourceFilter(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o)));
    }

    public SecuredResIterator listResourcesWithProperty(Property p, char o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p, o), new ResourceFilter(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Character.valueOf(o))));
    }

    public SecuredResIterator listResourcesWithProperty(Property p, double o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p, o), new ResourceFilter(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o)));
    }

    public SecuredResIterator listResourcesWithProperty(Property p, float o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p, o), new ResourceFilter(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Float.valueOf(o))));
    }

    public SecuredResIterator listResourcesWithProperty(Property p, long o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p, o), new ResourceFilter(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o)));
    }

    public SecuredResIterator listResourcesWithProperty(Property p, Object o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p, o), new ResourceFilter(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o)));
    }

    public SecuredResIterator listResourcesWithProperty(Property p, RDFNode o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listResourcesWithProperty(p, o), new ResourceFilter(p, o));
    }

    public SecuredStatementIterator listStatements() throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listStatements());
    }

    public SecuredStatementIterator listStatements(Resource s, Property p, RDFNode o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listStatements(s, p, o));
    }

    public SecuredStatementIterator listStatements(Resource subject, Property predicate, String object) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listStatements(subject, predicate, object));
    }

    public SecuredStatementIterator listStatements(Resource subject, Property predicate, String object, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        return this.stmtIterator(() -> this.holder.getBaseItem().listStatements(subject, predicate, object, lang));
    }

    public StmtIterator listStatements(Resource subject, Property predicate, String object, String lang, String direction) {
        return this.stmtIterator(() -> this.holder.getBaseItem().listStatements(subject, predicate, object, lang, direction));
    }

    public SecuredResIterator listSubjects() throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listSubjects(), new ResourceFilter());
    }

    public SecuredResIterator listSubjectsWithProperty(Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listSubjectsWithProperty(p), new ResourceFilter(p));
    }

    public SecuredResIterator listSubjectsWithProperty(Property p, RDFNode o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listSubjectsWithProperty(p, o), new ResourceFilter(p, o));
    }

    public SecuredResIterator listSubjectsWithProperty(Property p, String o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listSubjectsWithProperty(p, o), new ResourceFilter(p, (RDFNode)ResourceFactory.createPlainLiteral((String)o)));
    }

    public SecuredResIterator listSubjectsWithProperty(Property p, String o, String l) throws ReadDeniedException, AuthenticationRequiredException {
        return this.resIterator(() -> this.holder.getBaseItem().listSubjectsWithProperty(p, o, l), new ResourceFilter(p, (RDFNode)ResourceFactory.createLangLiteral((String)o, (String)l)));
    }

    @Override
    public SecuredPrefixMapping lock() throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().lock();
        return this.holder.getSecuredItem();
    }

    public SecuredModel notifyEvent(Object e) {
        this.holder.getBaseItem().notifyEvent(e);
        return this.holder.getSecuredItem();
    }

    @Override
    public String qnameFor(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().qnameFor(uri) : null;
    }

    public SecuredModel read(InputStream in, String base) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        readerFactory.getReader(null).read((Model)this.holder.getSecuredItem(), in, base);
        return this.holder.getSecuredItem();
    }

    public SecuredModel read(InputStream in, String base, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        readerFactory.getReader(lang).read((Model)this.holder.getSecuredItem(), in, base);
        return this.holder.getSecuredItem();
    }

    public SecuredModel read(Reader reader, String base) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        readerFactory.getReader(null).read((Model)this.holder.getSecuredItem(), reader, base);
        return this.holder.getSecuredItem();
    }

    public SecuredModel read(Reader reader, String base, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        readerFactory.getReader(lang).read((Model)this.holder.getSecuredItem(), reader, base);
        return this.holder.getSecuredItem();
    }

    public SecuredModel read(String url) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        readerFactory.getReader(null).read((Model)this.holder.getSecuredItem(), url);
        return this.holder.getSecuredItem();
    }

    public SecuredModel read(String url, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        readerFactory.getReader(lang).read((Model)this.holder.getSecuredItem(), url);
        return this.holder.getSecuredItem();
    }

    public SecuredModel read(String url, String base, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        try (InputStream is = new URL(url).openStream();){
            this.read(is, base, lang);
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        return this.holder.getSecuredItem();
    }

    public SecuredModel register(ModelChangedListener listener) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (!this.listeners.containsKey(listener)) {
                SecuredModelChangedListener secL = new SecuredModelChangedListener(listener);
                this.listeners.put(listener, secL);
                this.holder.getBaseItem().register((ModelChangedListener)secL);
            }
            return this.holder.getSecuredItem();
        }
        throw new ReadDeniedException(SecuredItem.Util.modelPermissionMsg(this.getModelNode()));
    }

    public SecuredModel remove(List<Statement> statements) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.ANY)) {
            for (Statement s : statements) {
                this.checkDelete((FrontsTriple)s);
            }
        }
        this.holder.getBaseItem().remove(statements);
        return this.holder.getSecuredItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredModel remove(Model m) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.ANY)) {
            try (StmtIterator iter = m.listStatements();){
                while (iter.hasNext()) {
                    Statement stmt = (Statement)iter.next();
                    this.checkDelete((FrontsTriple)stmt);
                }
            }
        }
        this.holder.getBaseItem().remove(m);
        return this.holder.getSecuredItem();
    }

    public SecuredModel remove(Resource s, Property p, RDFNode o) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkDelete(Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)o.asNode()));
        this.holder.getBaseItem().remove(s, p, o);
        return this.holder.getSecuredItem();
    }

    public SecuredModel remove(Statement s) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkDelete(this.wildCardTriple(s));
        this.holder.getBaseItem().remove(s);
        return this.holder.getSecuredItem();
    }

    public SecuredModel remove(Statement[] statements) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.ANY)) {
            for (Statement s : statements) {
                this.checkDelete((FrontsTriple)s);
            }
        }
        this.holder.getBaseItem().remove(statements);
        return this.holder.getSecuredItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredModel remove(StmtIterator iter) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.ANY)) {
            ArrayList<Triple> lst = new ArrayList<Triple>();
            try {
                while (iter.hasNext()) {
                    Statement s = (Statement)iter.next();
                    this.checkDelete((FrontsTriple)s);
                    lst.add(s.asTriple());
                }
                Graph g = GraphMemFactory.createDefaultGraph();
                Model m = ModelFactory.createModelForGraph((Graph)g);
                this.holder.getBaseItem().remove(m.listStatements());
            }
            finally {
                iter.close();
            }
        } else {
            this.holder.getBaseItem().remove(iter);
        }
        return this.holder.getSecuredItem();
    }

    public SecuredModel removeAll() throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.ANY)) {
            try (StmtIterator iter = this.holder.getBaseItem().listStatements();){
                while (iter.hasNext()) {
                    this.checkDelete((FrontsTriple)iter.next());
                }
            }
        }
        this.holder.getBaseItem().removeAll();
        return this.holder.getSecuredItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredModel removeAll(Resource s, Property p, RDFNode r) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.create((Node)this.wildCardNode((RDFNode)s), (Node)this.wildCardNode((RDFNode)p), (Node)this.wildCardNode(r)))) {
            try (StmtIterator iter = this.holder.getBaseItem().listStatements(s, p, r);){
                while (iter.hasNext()) {
                    this.checkDelete((FrontsTriple)iter.next());
                }
            }
        }
        this.holder.getBaseItem().removeAll(s, p, r);
        return this.holder.getSecuredItem();
    }

    @Override
    public SecuredModel removeNsPrefix(String prefix) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().removeNsPrefix(prefix);
        return this.holder.getSecuredItem();
    }

    public SecuredModel clearNsPrefixMap() {
        this.checkUpdate();
        this.holder.getBaseItem().clearNsPrefixMap();
        return this.holder.getSecuredItem();
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().samePrefixMappingAs(other) : other.hasNoMappings();
    }

    @Override
    public SecuredModel setNsPrefix(String prefix, String uri) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().setNsPrefix(prefix, uri);
        return this.holder.getSecuredItem();
    }

    @Override
    public SecuredModel setNsPrefixes(Map<String, String> map) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().setNsPrefixes(map);
        return this.holder.getSecuredItem();
    }

    @Override
    public SecuredModel setNsPrefixes(PrefixMapping other) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().setNsPrefixes(other);
        return this.holder.getSecuredItem();
    }

    @Override
    public String shortForm(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().shortForm(uri) : uri;
    }

    public boolean hasNoMappings() {
        return this.checkSoftRead() ? this.holder.getBaseItem().hasNoMappings() : true;
    }

    public int numPrefixes() {
        return this.checkSoftRead() ? this.holder.getBaseItem().numPrefixes() : 0;
    }

    public long size() throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().size();
            }
            return this.createCopy().size();
        }
        return 0L;
    }

    public boolean supportsSetOperations() {
        return this.holder.getBaseItem().supportsSetOperations();
    }

    public boolean supportsTransactions() {
        return this.holder.getBaseItem().supportsTransactions();
    }

    public Model union(Model model) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().union(model);
            }
            return this.createCopy().union(model);
        }
        return ModelFactory.createDefaultModel().add(model);
    }

    public SecuredModel unregister(ModelChangedListener listener) {
        if (this.listeners.containsKey(listener)) {
            SecuredModelChangedListener secL = this.listeners.get(listener);
            this.holder.getBaseItem().unregister((ModelChangedListener)secL);
            this.listeners.remove(listener);
        }
        return this.holder.getSecuredItem();
    }

    private Node wildCardNode(RDFNode node) {
        return node == null ? Node.ANY : node.asNode();
    }

    private Triple wildCardTriple(Statement s) {
        return Triple.create((Node)this.wildCardNode((RDFNode)s.getSubject()), (Node)this.wildCardNode((RDFNode)s.getPredicate()), (Node)this.wildCardNode(s.getObject()));
    }

    @Override
    public SecuredModel withDefaultMappings(PrefixMapping map) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().withDefaultMappings(map);
        return this.holder.getSecuredItem();
    }

    public SecuredResource wrapAsResource(Node n) {
        return SecuredResourceImpl.getInstance(this.holder.getSecuredItem(), this.holder.getBaseItem().wrapAsResource(n));
    }

    public SecuredModel write(OutputStream out) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                this.holder.getBaseItem().write(out);
            } else {
                this.getWriter(null).write((Model)this.holder.getSecuredItem(), out, "");
            }
        }
        return this.holder.getSecuredItem();
    }

    public SecuredModel write(OutputStream out, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                this.holder.getBaseItem().write(out, lang);
            } else {
                this.getWriter(lang).write((Model)this.holder.getSecuredItem(), out, "");
            }
        }
        return this.holder.getSecuredItem();
    }

    public SecuredModel write(OutputStream out, String lang, String base) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                this.holder.getBaseItem().write(out, lang, base);
            } else {
                this.getWriter(lang).write((Model)this.holder.getSecuredItem(), out, base);
            }
        }
        return this.holder.getSecuredItem();
    }

    public SecuredModel write(Writer writer) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                this.holder.getBaseItem().write(writer);
            } else {
                this.getWriter(null).write((Model)this.holder.getSecuredItem(), writer, "");
            }
        }
        return this.holder.getSecuredItem();
    }

    public SecuredModel write(Writer writer, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                this.holder.getBaseItem().write(writer, lang);
            } else {
                this.getWriter(lang).write((Model)this.holder.getSecuredItem(), writer, "");
            }
        }
        return this.holder.getSecuredItem();
    }

    public SecuredModel write(Writer writer, String lang, String base) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                this.holder.getBaseItem().write(writer, lang, base);
            } else {
                this.getWriter(lang).write((Model)this.holder.getSecuredItem(), writer, base);
            }
        }
        return this.holder.getSecuredItem();
    }

    public ResIterator listSubjectsWithProperty(Property p, String str, String lang, String dir) {
        return null;
    }

    private class ObjectFilter
    implements Predicate<RDFNode> {
        Resource s;
        Property p;

        ObjectFilter() {
            this(null, null);
        }

        ObjectFilter(Property p) {
            this(null, p);
        }

        ObjectFilter(Resource s, Property p) {
            this.s = s;
            this.p = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(RDFNode o) {
            try (SecuredStatementIterator iter = SecuredModelImpl.this.listStatements(this.s, this.p, o);){
                boolean bl = iter.hasNext();
                return bl;
            }
        }
    }

    private class ResourceFilter
    implements Predicate<Resource> {
        Property p;
        RDFNode o;

        ResourceFilter() {
            this(null, null);
        }

        ResourceFilter(Property p) {
            this(p, null);
        }

        ResourceFilter(Property p, RDFNode o) {
            this.p = p;
            this.o = o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(Resource s) {
            try (SecuredStatementIterator iter = SecuredModelImpl.this.listStatements(s, this.p, this.o);){
                boolean bl = iter.hasNext();
                return bl;
            }
        }
    }

    private class SecuredModelChangedListener
    implements ModelChangedListener {
        private final ModelChangedListener wrapped;

        private SecuredModelChangedListener(ModelChangedListener wrapped) {
            this.wrapped = wrapped;
        }

        public void addedStatement(Statement s) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead((FrontsTriple)s)) {
                this.wrapped.addedStatement(s);
            }
        }

        public void addedStatements(List<Statement> statements) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.addedStatements(statements);
            } else {
                try (SecuredStatementIterator iter = new SecuredStatementIterator(SecuredModelImpl.this.holder.getSecuredItem(), (ExtendedIterator<Statement>)WrappedIterator.create(statements.iterator()));){
                    this.wrapped.addedStatements(iter.toList());
                }
            }
        }

        public void addedStatements(Model m) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.addedStatements(m);
            } else {
                this.wrapped.addedStatements((Model)SecuredModelImpl.getInstance(SecuredModelImpl.this.holder.getSecuredItem(), m));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addedStatements(Statement[] statements) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.addedStatements(statements);
            } else {
                try (SecuredStatementIterator iter = new SecuredStatementIterator(SecuredModelImpl.this.holder.getSecuredItem(), (ExtendedIterator<Statement>)WrappedIterator.create(Arrays.asList(statements).iterator()));){
                    List<Statement> stmts = iter.toList();
                    this.wrapped.addedStatements(stmts.toArray(new Statement[stmts.size()]));
                }
            }
        }

        public void addedStatements(StmtIterator statements) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.addedStatements(statements);
            } else {
                try (SecuredStatementIterator iter = new SecuredStatementIterator(SecuredModelImpl.this.holder.getSecuredItem(), (ExtendedIterator<Statement>)statements);){
                    this.wrapped.addedStatements((StmtIterator)iter);
                }
            }
        }

        public void notifyEvent(Model m, Object event) {
            this.wrapped.notifyEvent(m, event);
        }

        public void removedStatement(Statement s) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead((FrontsTriple)s)) {
                this.wrapped.removedStatement(s);
            }
        }

        public void removedStatements(List<Statement> statements) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.removedStatements(statements);
            } else {
                try (SecuredStatementIterator iter = new SecuredStatementIterator(SecuredModelImpl.this.holder.getSecuredItem(), (ExtendedIterator<Statement>)WrappedIterator.create(statements.iterator()));){
                    this.wrapped.removedStatements(iter.toList());
                }
            }
        }

        public void removedStatements(Model m) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.removedStatements(m);
            } else {
                this.wrapped.removedStatements((Model)SecuredModelImpl.getInstance(SecuredModelImpl.this.holder.getSecuredItem(), m));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedStatements(Statement[] statements) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.removedStatements(statements);
            } else {
                try (SecuredStatementIterator iter = new SecuredStatementIterator(SecuredModelImpl.this.holder.getSecuredItem(), (ExtendedIterator<Statement>)WrappedIterator.create(Arrays.asList(statements).iterator()));){
                    List<Statement> stmts = iter.toList();
                    this.wrapped.removedStatements(stmts.toArray(new Statement[stmts.size()]));
                }
            }
        }

        public void removedStatements(StmtIterator statements) throws AuthenticationRequiredException {
            if (SecuredModelImpl.this.canRead(Triple.ANY)) {
                this.wrapped.removedStatements(statements);
            } else {
                try (SecuredStatementIterator iter = new SecuredStatementIterator(SecuredModelImpl.this.holder.getSecuredItem(), (ExtendedIterator<Statement>)statements);){
                    this.wrapped.removedStatements((StmtIterator)iter);
                }
            }
        }
    }
}

