/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.impl;

import java.lang.reflect.Proxy;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.sparql.util.NodeCmp;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.RDF;

public abstract class SecuredItemImpl
implements SecuredItem {
    public static int MAX_CACHE = 100;
    public static final ThreadLocal<LRUMap<CacheKey, Boolean>> CACHE = new ThreadLocal();
    public static final ThreadLocal<Integer> COUNT = new ThreadLocal();
    private final SecurityEvaluator securityEvaluator;
    private final Node modelNode;
    private final ItemHolder<?, ?> itemHolder;

    private static Node convert(Node jenaNode) {
        if (jenaNode.isVariable()) {
            return SecurityEvaluator.VARIABLE;
        }
        return jenaNode;
    }

    private static Triple convert(Triple jenaTriple) {
        if (jenaTriple.getSubject().isVariable() || jenaTriple.getPredicate().isVariable() || jenaTriple.getObject().isVariable()) {
            return Triple.create((Node)SecuredItemImpl.convert(jenaTriple.getSubject()), (Node)SecuredItemImpl.convert(jenaTriple.getPredicate()), (Node)SecuredItemImpl.convert(jenaTriple.getObject()));
        }
        return jenaTriple;
    }

    public static void decrementUse() {
        Integer i = COUNT.get();
        if (i == null) {
            throw new IllegalStateException("No count on exit");
        }
        if (i < 1) {
            throw new IllegalStateException("No count less than 1");
        }
        if (i == 1) {
            CACHE.remove();
            COUNT.remove();
        } else {
            COUNT.set(i - 1);
        }
    }

    public static void incrementUse() {
        Integer i = COUNT.get();
        if (i == null) {
            CACHE.set((LRUMap<CacheKey, Boolean>)new LRUMap(Math.max(MAX_CACHE, 100)));
            COUNT.set(1);
        } else {
            COUNT.set(i + 1);
        }
    }

    protected SecuredItemImpl(SecuredItem securedItem, ItemHolder<?, ?> holder) {
        if (securedItem == null) {
            throw new IllegalArgumentException("Secured item may not be null");
        }
        if (securedItem.getSecurityEvaluator() == null) {
            throw new IllegalArgumentException("Security evaluator in secured item may not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("ItemHolder may not be null");
        }
        this.securityEvaluator = securedItem.getSecurityEvaluator();
        this.modelNode = securedItem.getModelNode();
        this.itemHolder = holder;
    }

    protected SecuredItemImpl(SecurityEvaluator securityEvaluator, String modelURI, ItemHolder<?, ?> holder) {
        if (securityEvaluator == null) {
            throw new IllegalArgumentException("Security evaluator may not be null");
        }
        if (StringUtils.isEmpty((CharSequence)modelURI)) {
            throw new IllegalArgumentException("ModelURI may not be empty or null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("ItemHolder may not be null");
        }
        this.securityEvaluator = securityEvaluator;
        this.modelNode = NodeFactory.createURI((String)modelURI);
        this.itemHolder = holder;
    }

    public final String toString() throws AuthenticationRequiredException {
        Object o = this.itemHolder.getBaseItem();
        boolean ok = this.canRead();
        if (ok) {
            if (o instanceof Triple) {
                ok = this.canRead((Triple)o);
            } else if (o instanceof FrontsTriple) {
                ok = this.canRead(((FrontsTriple)o).asTriple());
            }
        }
        return ok ? this.itemHolder.getBaseItem().toString() : String.format("SecuredItem[0x%X]", this.itemHolder.getBaseItem().hashCode());
    }

    private Boolean cacheGet(CacheKey key) {
        LRUMap<CacheKey, Boolean> cache = CACHE.get();
        return cache == null ? null : (Boolean)cache.get((Object)key);
    }

    private void cachePut(CacheKey key, boolean value) {
        LRUMap<CacheKey, Boolean> cache = CACHE.get();
        if (cache != null) {
            cache.put((Object)key, (Object)value);
            CACHE.set(cache);
        }
    }

    @Override
    public boolean canCreate() throws AuthenticationRequiredException {
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Create, this.modelNode);
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Create, this.modelNode);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canCreate(Triple triple) throws AuthenticationRequiredException {
        Triple t = SecuredItemImpl.convert(triple);
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Create, this.modelNode, t);
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Create, this.modelNode, t);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canCreate(FrontsTriple frontsTriple) throws AuthenticationRequiredException {
        return this.canCreate(frontsTriple.asTriple());
    }

    @Override
    public boolean canDelete() throws AuthenticationRequiredException {
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Delete, this.modelNode);
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Delete, this.modelNode);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canDelete(Triple triple) throws AuthenticationRequiredException {
        Triple t = SecuredItemImpl.convert(triple);
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Delete, this.modelNode, t);
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Delete, this.modelNode, t);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canDelete(FrontsTriple frontsTriple) throws AuthenticationRequiredException {
        return this.canDelete(frontsTriple.asTriple());
    }

    @Override
    public boolean canRead() throws AuthenticationRequiredException {
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Read, this.modelNode);
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Read, this.modelNode);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canRead(Triple triple) throws AuthenticationRequiredException {
        Triple t = SecuredItemImpl.convert(triple);
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Read, this.modelNode, t);
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Read, this.modelNode, t);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canRead(FrontsTriple frontsTriple) throws AuthenticationRequiredException {
        return this.canRead(frontsTriple.asTriple());
    }

    @Override
    public boolean canUpdate() throws AuthenticationRequiredException {
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Update, this.modelNode);
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Update, this.modelNode);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canUpdate(Triple f, Triple t) throws AuthenticationRequiredException {
        Triple to;
        Triple from = SecuredItemImpl.convert(f);
        CacheKey key = new CacheKey(SecurityEvaluator.Action.Update, this.modelNode, from, to = SecuredItemImpl.convert(t));
        Boolean retval = this.cacheGet(key);
        if (retval == null) {
            retval = this.securityEvaluator.evaluateUpdate(this.securityEvaluator.getPrincipal(), this.modelNode, from, to);
            this.cachePut(key, retval);
        }
        return retval;
    }

    @Override
    public boolean canUpdate(FrontsTriple from, FrontsTriple to) throws AuthenticationRequiredException {
        return this.canUpdate(from.asTriple(), to.asTriple());
    }

    protected void checkCreate() throws AddDeniedException, AuthenticationRequiredException {
        if (!this.canCreate()) {
            throw new AddDeniedException(SecuredItem.Util.modelPermissionMsg(this.modelNode));
        }
    }

    protected void checkCreate(Triple t) throws AddDeniedException, AuthenticationRequiredException {
        if (!this.canCreate(t)) {
            throw new AddDeniedException(SecuredItem.Util.triplePermissionMsg(this.modelNode), t);
        }
    }

    protected void checkCreate(FrontsTriple frontsTriple) throws AddDeniedException, AuthenticationRequiredException {
        this.checkCreate(frontsTriple.asTriple());
    }

    protected void checkCreateReified(String uri, FrontsTriple front) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple t = front.asTriple();
        Node n = uri == null ? SecurityEvaluator.FUTURE : NodeFactory.createURI((String)uri);
        this.checkCreate(Triple.create((Node)n, (Node)RDF.subject.asNode(), (Node)t.getSubject()));
        this.checkCreate(Triple.create((Node)n, (Node)RDF.predicate.asNode(), (Node)t.getPredicate()));
        this.checkCreate(Triple.create((Node)n, (Node)RDF.object.asNode(), (Node)t.getObject()));
    }

    protected void checkCreate(Supplier<ExtendedIterator<Triple>> supplier) throws AddDeniedException, AuthenticationRequiredException {
        if (!this.canCreate(Triple.ANY)) {
            try (ExtendedIterator<Triple> iter = supplier.get();){
                while (iter.hasNext()) {
                    this.checkCreate((Triple)iter.next());
                }
            }
        }
    }

    protected void checkDelete() throws DeleteDeniedException, AuthenticationRequiredException {
        if (!this.canDelete()) {
            throw new DeleteDeniedException(SecuredItem.Util.modelPermissionMsg(this.modelNode));
        }
    }

    protected void checkDelete(Triple triple) throws DeleteDeniedException, AuthenticationRequiredException {
        if (!this.canDelete(triple)) {
            throw new DeleteDeniedException(SecuredItem.Util.triplePermissionMsg(this.modelNode), triple);
        }
    }

    protected void checkDelete(FrontsTriple frontsTriple) throws DeleteDeniedException, AuthenticationRequiredException {
        this.checkDelete(frontsTriple.asTriple());
    }

    protected void checkDeleteFrontsTriples(ExtendedIterator<? extends FrontsTriple> frontsTriplesIter) throws DeleteDeniedException, AuthenticationRequiredException {
        if (!this.canDelete(Triple.ANY)) {
            try {
                while (frontsTriplesIter.hasNext()) {
                    this.checkDelete((FrontsTriple)frontsTriplesIter.next());
                }
            }
            finally {
                frontsTriplesIter.close();
            }
        }
    }

    protected void checkDeleteTriples(ExtendedIterator<Triple> triples) throws DeleteDeniedException, AuthenticationRequiredException {
        if (!this.canDelete(Triple.ANY)) {
            try {
                while (triples.hasNext()) {
                    this.checkDelete((Triple)triples.next());
                }
            }
            finally {
                triples.close();
            }
        }
    }

    protected void checkRead() throws ReadDeniedException, AuthenticationRequiredException {
        if (!this.canRead()) {
            throw new ReadDeniedException(SecuredItem.Util.modelPermissionMsg(this.modelNode));
        }
    }

    protected boolean checkSoftRead() throws ReadDeniedException, AuthenticationRequiredException {
        if (!this.canRead()) {
            if (this.securityEvaluator.isHardReadError()) {
                throw new ReadDeniedException(SecuredItem.Util.modelPermissionMsg(this.modelNode));
            }
            return false;
        }
        return true;
    }

    protected boolean checkRead(Triple triple) throws ReadDeniedException, AuthenticationRequiredException {
        if (!this.canRead(triple)) {
            if (this.securityEvaluator.isHardReadError()) {
                throw new ReadDeniedException(SecuredItem.Util.triplePermissionMsg(this.modelNode), triple);
            }
            return false;
        }
        return true;
    }

    protected boolean checkRead(FrontsTriple frontsTriple) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkRead(frontsTriple.asTriple());
    }

    protected boolean checkReadFrontsTriples(ExtendedIterator<FrontsTriple> frontsTripleIter) throws ReadDeniedException, AuthenticationRequiredException {
        try {
            while (frontsTripleIter.hasNext()) {
                if (this.checkRead((FrontsTriple)frontsTripleIter.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            frontsTripleIter.close();
        }
    }

    protected boolean checkReadTriples(ExtendedIterator<Triple> triples) throws ReadDeniedException, AuthenticationRequiredException {
        try {
            while (triples.hasNext()) {
                if (this.checkRead((Triple)triples.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            triples.close();
        }
    }

    protected void checkUpdate() throws UpdateDeniedException, AuthenticationRequiredException {
        if (!this.canUpdate()) {
            throw new UpdateDeniedException(SecuredItem.Util.modelPermissionMsg(this.modelNode));
        }
    }

    protected void checkUpdate(Triple from, Triple to) throws UpdateDeniedException, AuthenticationRequiredException {
        if (!this.canUpdate(from, to)) {
            throw new UpdateDeniedException(String.format("%s: %s to %s", SecuredItem.Util.modelPermissionMsg(this.modelNode), from, to));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (Proxy.isProxyClass(o.getClass())) {
            return o.equals(this.itemHolder.getSecuredItem());
        }
        if (o instanceof SecuredItemImpl) {
            return this.itemHolder.getBaseItem().equals(((SecuredItemImpl)o).getBaseItem());
        }
        return false;
    }

    public int hashCode() {
        return this.itemHolder.getBaseItem().hashCode();
    }

    @Override
    public Object getBaseItem() {
        return this.itemHolder.getBaseItem();
    }

    @Override
    public String getModelIRI() {
        return this.modelNode.getURI();
    }

    @Override
    public Node getModelNode() {
        return this.modelNode;
    }

    @Override
    public SecurityEvaluator getSecurityEvaluator() {
        return this.securityEvaluator;
    }

    @Override
    public boolean isEquivalent(SecuredItem securedItem) {
        return SecuredItem.Util.isEquivalent(this, securedItem);
    }

    protected <T> ExtendedIterator<T> createIterator(Supplier<ExtendedIterator<T>> find, Supplier<Predicate<T>> filter) {
        if (this.checkSoftRead()) {
            ExtendedIterator retval = find.get();
            if (!this.canRead(Triple.ANY)) {
                retval = retval.filterKeep(filter.get());
            }
            return retval;
        }
        return NullIterator.instance();
    }

    private class CacheKey
    implements Comparable<CacheKey> {
        private final SecurityEvaluator.Action action;
        private final Node mNode;
        private final Triple from;
        private final Triple to;
        private Integer hashCode;

        public CacheKey(SecurityEvaluator.Action action, Node modelNode) {
            this(action, modelNode, null, null);
        }

        public CacheKey(SecurityEvaluator.Action action, Node modelNode, Triple to) {
            this(action, modelNode, to, null);
        }

        public CacheKey(SecurityEvaluator.Action action, Node modelNode, Triple to, Triple from) {
            this.action = action;
            this.mNode = modelNode;
            this.to = to;
            this.from = from;
        }

        private int compare(Node n1, Node n2) {
            if (Node.ANY.equals((Object)n1)) {
                if (Node.ANY.equals((Object)n2)) {
                    return 0;
                }
                return -1;
            }
            if (Node.ANY.equals((Object)n2)) {
                return 1;
            }
            return NodeCmp.compareRDFTerms((Node)n1, (Node)n2);
        }

        private int compare(Triple t1, Triple t2) {
            if (t1 == null) {
                if (t2 == null) {
                    return 0;
                }
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            int retval = this.compare(t1.getSubject(), t2.getSubject());
            if (retval == 0) {
                retval = this.compare(t1.getPredicate(), t2.getPredicate());
            }
            if (retval == 0) {
                retval = this.compare(t1.getObject(), t2.getObject());
            }
            return retval;
        }

        @Override
        public int compareTo(CacheKey other) {
            int retval = this.action.compareTo(other.action);
            if (retval == 0) {
                retval = NodeCmp.compareRDFTerms((Node)this.mNode, (Node)other.mNode);
            }
            if (retval == 0) {
                retval = this.compare(this.to, other.to);
            }
            if (retval == 0) {
                retval = this.compare(this.from, other.from);
            }
            return retval;
        }

        public boolean equals(Object o) {
            if (o instanceof CacheKey) {
                return this.compareTo((CacheKey)o) == 0;
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = new HashCodeBuilder().append((Object)this.action).append((Object)this.mNode).append((Object)this.from).append((Object)this.to).toHashCode();
            }
            return this.hashCode;
        }
    }
}

