/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.vocabulary.RDF;

public class RDFListIterator
implements Iterator<RDFList> {
    private RDFList current;
    private Boolean found;

    public RDFListIterator(RDFList start) {
        this.current = start;
    }

    private boolean endOfList() {
        return this.current.equals(RDF.nil);
    }

    @Override
    public boolean hasNext() {
        if (this.found == null && !this.endOfList()) {
            this.found = !this.endOfList();
        }
        return this.found == null ? false : this.found;
    }

    private void incrementCurrent() {
        if (!this.endOfList()) {
            this.current = (RDFList)this.current.getRequiredProperty(RDF.rest).getResource().as(RDFList.class);
        }
    }

    @Override
    public RDFList next() {
        if (this.hasNext()) {
            this.found = null;
            RDFList retval = this.current;
            this.incrementCurrent();
            return retval;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

