/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.query.rewriter;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;

public class SecuredFunction
extends ExprFunctionN {
    private final SecurityEvaluator securityEvaluator;
    private final List<Node> variables;
    private final List<Triple> bgp;
    private final Node graphIRI;

    private static ExprList createArgs(List<Node> variables) {
        ExprList retval = new ExprList();
        for (Node n : variables) {
            retval.add((Expr)new ExprVar(n));
        }
        return retval;
    }

    public SecuredFunction(Node graphIRI, SecurityEvaluator securityEvaluator, List<Node> variables, List<Triple> bgp) {
        super(String.format("<java:%s>", SecuredFunction.class.getName()), SecuredFunction.createArgs(variables));
        this.securityEvaluator = securityEvaluator;
        this.variables = variables;
        this.bgp = bgp;
        this.graphIRI = graphIRI;
    }

    private boolean checkAccess(Binding values) throws AuthenticationRequiredException {
        Object principal = this.securityEvaluator.getPrincipal();
        for (Triple t : this.bgp) {
            Triple secT = this.resolveTriple(t, values);
            if (this.securityEvaluator.evaluate(principal, SecurityEvaluator.Action.Read, this.graphIRI, secT)) continue;
            return false;
        }
        return true;
    }

    private Triple resolveTriple(Triple t, Binding values) {
        int idx = this.variables.indexOf(t.getSubject());
        Node s = idx == -1 ? t.getSubject() : values.get(Var.alloc((Node)this.variables.get(idx)));
        idx = this.variables.indexOf(t.getPredicate());
        Node p = idx == -1 ? t.getPredicate() : values.get(Var.alloc((Node)this.variables.get(idx)));
        idx = this.variables.indexOf(t.getObject());
        Node o = idx == -1 ? t.getObject() : values.get(Var.alloc((Node)this.variables.get(idx)));
        return Triple.create((Node)s, (Node)p, (Node)o);
    }

    public Expr copySubstitute(Binding binding) {
        return this;
    }

    public Expr applyNodeTransform(NodeTransform transform) {
        return this;
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit((ExprFunctionN)this);
    }

    public NodeValue eval(List<NodeValue> args) {
        return null;
    }

    public Expr copy(ExprList newArgs) {
        return this;
    }

    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        return NodeValue.booleanReturn((boolean)this.checkAccess(binding));
    }
}

