/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.query.rewriter;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.query.rewriter.SecuredFunction;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAntiJoin;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSemiJoin;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnfold;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpRewriter
implements OpVisitor {
    private static Logger LOG = LoggerFactory.getLogger(OpRewriter.class);
    private OpSequence result;
    private final Node graphIRI;
    private final SecurityEvaluator securityEvaluator;
    private final boolean silentFail;

    public OpRewriter(SecurityEvaluator securityEvaluator, Node graphIRI) {
        this.securityEvaluator = securityEvaluator;
        this.graphIRI = graphIRI;
        this.silentFail = false;
        this.reset();
    }

    public OpRewriter(SecurityEvaluator securityEvaluator, String graphIRI) {
        this(securityEvaluator, NodeFactory.createURI((String)graphIRI));
    }

    private void addOp(Op op) {
        this.result.add(op);
    }

    public Op getResult() {
        if (this.result.size() == 0) {
            return OpNull.create();
        }
        if (this.result.size() == 1) {
            return this.result.get(0);
        }
        return this.result;
    }

    private Node registerVariables(Node n, List<Node> variables) {
        if (n.isVariable() && !variables.contains(n)) {
            variables.add(n);
        }
        return n;
    }

    public OpRewriter reset() {
        this.result = OpSequence.create();
        return this;
    }

    private Triple registerBGPTriple(Triple t, List<Node> variables) {
        this.registerVariables(t.getSubject(), variables);
        this.registerVariables(t.getPredicate(), variables);
        this.registerVariables(t.getObject(), variables);
        return t;
    }

    private Op rewriteOp1(Op1 op1) {
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        op1.getSubOp().visit((OpVisitor)rewriter);
        return rewriter.getResult();
    }

    private Op rewriteOp2(Op2 op2, OpRewriter rewriter) {
        op2.getLeft().visit((OpVisitor)rewriter.reset());
        Op left = rewriter.getResult();
        op2.getRight().visit((OpVisitor)rewriter.reset());
        return left;
    }

    private OpN rewriteOpN(OpN source, OpN dest) {
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        for (Op o : source.getElements()) {
            o.visit((OpVisitor)rewriter.reset());
            dest.add(rewriter.getResult());
        }
        return dest;
    }

    public void visit(OpAssign opAssign) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpAssign");
        }
        this.addOp(OpAssign.assign((Op)this.rewriteOp1((Op1)opAssign), (VarExprList)opAssign.getVarExprList()));
    }

    public void visit(OpBGP opBGP) throws ReadDeniedException, AuthenticationRequiredException {
        Object principal;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpBGP");
        }
        if (!this.securityEvaluator.evaluate(principal = this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Read, this.graphIRI)) {
            if (this.silentFail) {
                return;
            }
            throw new ReadDeniedException(SecuredItem.Util.modelPermissionMsg(this.graphIRI));
        }
        if (this.securityEvaluator.evaluate(principal, SecurityEvaluator.Action.Read, this.graphIRI, Triple.ANY)) {
            this.addOp((Op)opBGP);
        } else {
            ArrayList<Triple> newBGP = new ArrayList<Triple>();
            ArrayList<Node> variables = new ArrayList<Node>();
            for (Triple t : opBGP.getPattern().getList()) {
                newBGP.add(this.registerBGPTriple(t, variables));
            }
            SecuredFunction secFunc = new SecuredFunction(this.graphIRI, this.securityEvaluator, variables, newBGP);
            Op filter = OpFilter.filter((Expr)secFunc, (Op)new OpBGP(BasicPattern.wrap(newBGP)));
            this.addOp(filter);
        }
    }

    public void visit(OpLateral opLateral) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpLateral");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp(OpLateral.create((Op)this.rewriteOp2((Op2)opLateral, rewriter), (Op)rewriter.getResult()));
    }

    public void visit(OpSemiJoin opSemiJoin) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpSemiJoin");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp(OpLateral.create((Op)this.rewriteOp2((Op2)opSemiJoin, rewriter), (Op)rewriter.getResult()));
    }

    public void visit(OpAntiJoin opAntiJoin) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpSemiJoin");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp(OpLateral.create((Op)this.rewriteOp2((Op2)opAntiJoin, rewriter), (Op)rewriter.getResult()));
    }

    public void visit(OpConditional opCondition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpConditional");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp((Op)new OpConditional(this.rewriteOp2((Op2)opCondition, rewriter), rewriter.getResult()));
    }

    public void visit(OpDatasetNames dsNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpDatasetName");
        }
        this.addOp((Op)dsNames);
    }

    public void visit(OpDisjunction opDisjunction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpDisjunction");
        }
        this.addOp((Op)this.rewriteOpN((OpN)opDisjunction, (OpN)OpDisjunction.create()));
    }

    public void visit(OpDistinct opDistinct) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpDistinct");
        }
        this.addOp((Op)new OpDistinct(this.rewriteOp1((Op1)opDistinct)));
    }

    public void visit(OpExt opExt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpExt");
        }
        this.addOp((Op)opExt);
    }

    public void visit(OpExtend opExtend) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpExtend");
        }
        this.addOp(OpExtend.extend((Op)this.rewriteOp1((Op1)opExtend), (VarExprList)opExtend.getVarExprList()));
    }

    public void visit(OpUnfold opUnfold) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpUnfold");
        }
        Op subOp = this.rewriteOp1((Op1)opUnfold);
        OpUnfold opUnfold2 = new OpUnfold(subOp, opUnfold.getExpr(), opUnfold.getVar1(), opUnfold.getVar2());
        this.addOp((Op)opUnfold2);
    }

    public void visit(OpFilter opFilter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpFilter");
        }
        this.addOp(OpFilter.filterBy((ExprList)opFilter.getExprs(), (Op)this.rewriteOp1((Op1)opFilter)));
    }

    public void visit(OpGraph opGraph) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpGraph");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, opGraph.getNode());
        opGraph.getSubOp().visit((OpVisitor)rewriter);
        this.addOp((Op)new OpGraph(opGraph.getNode(), rewriter.getResult()));
    }

    public void visit(OpGroup opGroup) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpGroup");
        }
        this.addOp((Op)OpGroup.create((Op)this.rewriteOp1((Op1)opGroup), (VarExprList)opGroup.getGroupVars(), (List)opGroup.getAggregators()));
    }

    public void visit(OpJoin opJoin) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpJoin");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp(OpJoin.create((Op)this.rewriteOp2((Op2)opJoin, rewriter), (Op)rewriter.getResult()));
    }

    public void visit(OpLabel opLabel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpLabel");
        }
        this.addOp((Op)opLabel);
    }

    public void visit(OpLeftJoin opLeftJoin) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpLeftJoin");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp(OpLeftJoin.create((Op)this.rewriteOp2((Op2)opLeftJoin, rewriter), (Op)rewriter.getResult(), (ExprList)opLeftJoin.getExprs()));
    }

    public void visit(OpList opList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpList");
        }
        this.addOp((Op)new OpList(this.rewriteOp1((Op1)opList)));
    }

    public void visit(OpMinus opMinus) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpMinus");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp(OpMinus.create((Op)this.rewriteOp2((Op2)opMinus, rewriter), (Op)rewriter.getResult()));
    }

    public void visit(OpNull opNull) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpNull");
        }
        this.addOp((Op)opNull);
    }

    public void visit(OpOrder opOrder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpOrder");
        }
        this.addOp((Op)new OpOrder(this.rewriteOp1((Op1)opOrder), opOrder.getConditions()));
    }

    public void visit(OpPath opPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpPath");
        }
        this.addOp((Op)opPath);
    }

    public void visit(OpProcedure opProc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpProc");
        }
        if (opProc.getProcId() != null) {
            this.addOp((Op)new OpProcedure(opProc.getProcId(), opProc.getArgs(), this.rewriteOp1((Op1)opProc)));
        } else {
            this.addOp((Op)new OpProcedure(opProc.getURI(), opProc.getArgs(), this.rewriteOp1((Op1)opProc)));
        }
    }

    public void visit(OpProject opProject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpProject");
        }
        this.addOp((Op)new OpProject(this.rewriteOp1((Op1)opProject), opProject.getVars()));
    }

    public void visit(OpPropFunc opPropFunc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpPropFunc");
        }
        this.addOp((Op)new OpPropFunc(opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs(), this.rewriteOp1((Op1)opPropFunc)));
    }

    public void visit(OpQuad opQuad) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpQuad");
        }
        this.addOp((Op)opQuad);
    }

    public void visit(OpQuadPattern quadPattern) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpQuadPattern");
        }
        this.addOp((Op)quadPattern);
    }

    public void visit(OpReduced opReduced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpReduced");
        }
        this.addOp(OpReduced.create((Op)this.rewriteOp1((Op1)opReduced)));
    }

    public void visit(OpSequence opSequence) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpSequence");
        }
        this.addOp((Op)this.rewriteOpN((OpN)opSequence, (OpN)OpSequence.create()));
    }

    public void visit(OpService opService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting opService");
        }
        this.addOp((Op)opService);
    }

    public void visit(OpSlice opSlice) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpSlice");
        }
        this.addOp((Op)opSlice);
    }

    public void visit(OpTable opTable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpTable");
        }
        this.addOp((Op)opTable);
    }

    public void visit(OpTopN opTop) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpTop");
        }
        this.addOp((Op)new OpTopN(this.rewriteOp1((Op1)opTop), opTop.getLimit(), opTop.getConditions()));
    }

    public void visit(OpTriple opTriple) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpTriple");
        }
        this.visit(opTriple.asBGP());
    }

    public void visit(OpUnion opUnion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpUnion");
        }
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        this.addOp(OpUnion.create((Op)this.rewriteOp2((Op2)opUnion, rewriter), (Op)rewriter.getResult()));
    }

    public void visit(OpQuadBlock quadBlock) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting visiting OpQuadBlock");
        }
        this.addOp((Op)quadBlock);
    }
}

