/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.query;

import java.security.Principal;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.graph.SecuredGraph;
import org.apache.jena.permissions.query.rewriter.OpRewriter;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredQueryEngine
extends QueryEngineMain {
    private static Logger LOG = LoggerFactory.getLogger(SecuredQueryEngine.class);
    private SecurityEvaluator securityEvaluator;
    private Node graphIRI;

    public SecuredQueryEngine(Query query, DatasetGraph dataset, Binding input, Context context) {
        super(query, dataset, input, context);
        this.setGraphIRI(dataset);
    }

    public SecurityEvaluator getSecurityEvaluator() {
        return this.securityEvaluator;
    }

    protected Op modifyOp(Op op) {
        OpRewriter rewriter = new OpRewriter(this.securityEvaluator, this.graphIRI);
        LOG.debug("Before: {}", (Object)op);
        op.visit((OpVisitor)rewriter);
        Op result = rewriter.getResult();
        result = result == null ? op : result;
        LOG.debug("After: {}", (Object)result);
        result = super.modifyOp(result);
        LOG.debug("After Optimize: {}", (Object)result);
        return result;
    }

    private void setGraphIRI(DatasetGraph dataset) {
        Graph g = dataset.getDefaultGraph();
        if (g instanceof SecuredGraph) {
            SecuredGraph sg = (SecuredGraph)g;
            this.graphIRI = sg.getModelNode();
            this.securityEvaluator = sg.getSecurityEvaluator();
        } else {
            this.graphIRI = NodeFactory.createURI((String)"urn:x-arq:DefaultGraph");
            this.securityEvaluator = new SecurityEvaluator(){

                @Override
                public boolean evaluate(Object principal, SecurityEvaluator.Action action, Node graphIRI) {
                    return true;
                }

                @Override
                public boolean evaluate(Object principal, SecurityEvaluator.Action action, Node graphIRI, Triple triple) {
                    return true;
                }

                @Override
                public boolean evaluate(Object principal, Set<SecurityEvaluator.Action> action, Node graphIRI) {
                    return true;
                }

                @Override
                public boolean evaluate(Object principal, Set<SecurityEvaluator.Action> action, Node graphIRI, Triple triple) {
                    return true;
                }

                @Override
                public boolean evaluateAny(Object principal, Set<SecurityEvaluator.Action> action, Node graphIRI) {
                    return true;
                }

                @Override
                public boolean evaluateAny(Object principal, Set<SecurityEvaluator.Action> action, Node graphIRI, Triple triple) {
                    return true;
                }

                @Override
                public boolean evaluateUpdate(Object principal, Node graphIRI, Triple from, Triple to) {
                    return true;
                }

                @Override
                public Principal getPrincipal() {
                    return null;
                }

                @Override
                public boolean isPrincipalAuthenticated(Object principal) {
                    return true;
                }
            };
        }
    }
}

