/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemImpl;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredAlt;
import org.apache.jena.permissions.model.SecuredBag;
import org.apache.jena.permissions.model.SecuredLiteral;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredProperty;
import org.apache.jena.permissions.model.SecuredRDFList;
import org.apache.jena.permissions.model.SecuredRDFNode;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.SecuredSeq;
import org.apache.jena.permissions.model.SecuredStatement;
import org.apache.jena.permissions.model.impl.SecuredAltImpl;
import org.apache.jena.permissions.model.impl.SecuredBagImpl;
import org.apache.jena.permissions.model.impl.SecuredLiteralImpl;
import org.apache.jena.permissions.model.impl.SecuredPropertyImpl;
import org.apache.jena.permissions.model.impl.SecuredRDFListImpl;
import org.apache.jena.permissions.model.impl.SecuredRDFNodeImpl;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.permissions.model.impl.SecuredSeqImpl;
import org.apache.jena.permissions.model.impl.SecuredStatementIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SecuredStatementImpl
extends SecuredItemImpl
implements SecuredStatement {
    private final ItemHolder<Statement, SecuredStatement> holder;
    private final SecuredModel securedModel;

    public static SecuredStatement getInstance(SecuredModel securedModel, Statement stmt) {
        if (securedModel == null) {
            throw new IllegalArgumentException("Secured securedModel may not be null");
        }
        if (stmt == null) {
            throw new IllegalArgumentException("Statement may not be null");
        }
        ItemHolder<Statement, SecuredStatement> holder = new ItemHolder<Statement, SecuredStatement>(stmt);
        SecuredStatementImpl checker = new SecuredStatementImpl(securedModel, holder);
        if (stmt instanceof SecuredStatement && checker.isEquivalent((SecuredStatement)stmt)) {
            return (SecuredStatement)stmt;
        }
        return holder.setSecuredItem(new SecuredItemInvoker(holder.getBaseItem().getClass(), checker));
    }

    private SecuredStatementImpl(SecuredModel securedModel, ItemHolder<Statement, SecuredStatement> holder) {
        super(securedModel, holder);
        this.holder = holder;
        this.securedModel = securedModel;
    }

    public Triple asTriple() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        Triple retval = this.holder.getBaseItem().asTriple();
        this.checkRead(retval);
        return retval;
    }

    @Override
    public boolean canCreate() throws AuthenticationRequiredException {
        return super.canCreate() && this.canCreate((FrontsTriple)this.holder.getBaseItem());
    }

    @Override
    public boolean canDelete() throws AuthenticationRequiredException {
        return super.canDelete() && this.canDelete((FrontsTriple)this.holder.getBaseItem());
    }

    @Override
    public boolean canRead() throws AuthenticationRequiredException {
        return super.canRead() && this.canRead((FrontsTriple)this.holder.getBaseItem());
    }

    public SecuredStatement changeLiteralObject(boolean o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = this.getNewTriple(base, o);
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeLiteralObject(o));
    }

    public SecuredStatement changeLiteralObject(char o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = this.getNewTriple(base, Character.valueOf(o));
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeLiteralObject(o));
    }

    public SecuredStatement changeLiteralObject(double o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = this.getNewTriple(base, o);
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeLiteralObject(o));
    }

    public SecuredStatement changeLiteralObject(float o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = this.getNewTriple(base, Float.valueOf(o));
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeLiteralObject(o));
    }

    public SecuredStatement changeLiteralObject(int o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = this.getNewTriple(base, o);
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeLiteralObject(o));
    }

    public SecuredStatement changeLiteralObject(long o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = this.getNewTriple(base, o);
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeLiteralObject(o));
    }

    public SecuredStatement changeObject(RDFNode o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = Triple.create((Node)base.getSubject(), (Node)base.getPredicate(), (Node)o.asNode());
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeObject(o));
    }

    public SecuredStatement changeObject(String o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = this.getNewTriple(base, o);
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeObject(o));
    }

    public SecuredStatement changeObject(String o, String l) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple base = this.holder.getBaseItem().asTriple();
        Triple newBase = Triple.create((Node)base.getSubject(), (Node)base.getPredicate(), (Node)NodeFactory.createLiteralLang((String)o, (String)l));
        this.checkUpdate(base, newBase);
        return SecuredStatementImpl.getInstance(this.getModel(), this.holder.getBaseItem().changeObject(o, l));
    }

    public SecuredAlt getAlt() {
        return SecuredAltImpl.getInstance(this.getModel(), this.holder.getBaseItem().getAlt());
    }

    public SecuredBag getBag() {
        return SecuredBagImpl.getInstance(this.getModel(), this.holder.getBaseItem().getBag());
    }

    public SecuredSeq getSeq() {
        return SecuredSeqImpl.getInstance(this.getModel(), this.holder.getBaseItem().getSeq());
    }

    public SecuredRDFList getList() {
        return SecuredRDFListImpl.getInstance(this.getModel(), this.holder.getBaseItem().getList());
    }

    public boolean getBoolean() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getBoolean();
    }

    public byte getByte() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getByte();
    }

    public char getChar() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getChar();
    }

    public double getDouble() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getDouble();
    }

    public float getFloat() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getFloat();
    }

    public int getInt() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getInt();
    }

    public String getLanguage() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getLiteral().getLanguage();
    }

    public SecuredLiteral getLiteral() {
        return SecuredLiteralImpl.getInstance(this.getModel(), this.holder.getBaseItem().getLiteral());
    }

    public long getLong() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getLong();
    }

    public SecuredModel getModel() {
        return this.securedModel;
    }

    private Triple getNewTriple(Triple t, Object o) {
        return Triple.create((Node)t.getSubject(), (Node)t.getPredicate(), (Node)NodeFactory.createLiteralLang((String)String.valueOf(o), (String)""));
    }

    public SecuredRDFNode getObject() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        RDFNode rdfNode = this.holder.getBaseItem().getObject();
        return SecuredRDFNodeImpl.getInstance(this.getModel(), rdfNode);
    }

    public SecuredProperty getPredicate() {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return SecuredPropertyImpl.getInstance(this.getModel(), this.holder.getBaseItem().getPredicate());
    }

    public SecuredStatement getProperty(Property p) throws AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        StmtIterator s = this.holder.getBaseItem().getModel().listStatements(this.holder.getBaseItem().getObject().asResource(), p, (RDFNode)null);
        try (SecuredStatementIterator iter = new SecuredStatementIterator(this.getModel(), (ExtendedIterator<Statement>)s);){
            if (iter.hasNext()) {
                SecuredStatement securedStatement = SecuredStatementImpl.getInstance(this.getModel(), iter.next());
                return securedStatement;
            }
            throw new PropertyNotFoundException(p);
        }
    }

    public SecuredResource getResource() {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return SecuredResourceImpl.getInstance(this.getModel(), this.holder.getBaseItem().getResource());
    }

    public short getShort() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.holder.getBaseItem().getShort();
    }

    public SecuredStatement getStatementProperty(Property p) {
        Statement stmt;
        if (this.canRead() && this.checkRead((FrontsTriple)(stmt = this.holder.getBaseItem().getStatementProperty(p)))) {
            return SecuredStatementImpl.getInstance(this.getModel(), stmt);
        }
        throw new PropertyNotFoundException(p);
    }

    public String getString() {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return this.getLiteral().getLexicalForm();
    }

    public SecuredResource getSubject() {
        this.checkRead();
        this.checkRead(this.holder.getBaseItem().asTriple());
        return SecuredResourceImpl.getInstance(this.getModel(), this.holder.getBaseItem().getSubject());
    }

    public SecuredStatement remove() throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkDelete((FrontsTriple)this.holder.getBaseItem());
        this.holder.getBaseItem().remove();
        return this.holder.getSecuredItem();
    }
}

