/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.util.function.Predicate;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredAlt;
import org.apache.jena.permissions.model.SecuredBag;
import org.apache.jena.permissions.model.SecuredContainer;
import org.apache.jena.permissions.model.SecuredLiteral;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredRDFNode;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.SecuredSeq;
import org.apache.jena.permissions.model.impl.SecuredAltImpl;
import org.apache.jena.permissions.model.impl.SecuredBagImpl;
import org.apache.jena.permissions.model.impl.SecuredContainerImpl;
import org.apache.jena.permissions.model.impl.SecuredLiteralImpl;
import org.apache.jena.permissions.model.impl.SecuredRDFNodeImpl;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.SeqIndexBoundsException;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class SecuredSeqImpl
extends SecuredContainerImpl
implements SecuredSeq {
    private final ItemHolder<? extends Seq, ? extends SecuredSeq> holder;

    public static SecuredSeq getInstance(SecuredModel securedModel, Seq seq) {
        if (securedModel == null) {
            throw new IllegalArgumentException("Secured securedModel may not be null");
        }
        if (seq == null) {
            throw new IllegalArgumentException("Seq may not be null");
        }
        ItemHolder holder = new ItemHolder(seq);
        SecuredSeqImpl checker = new SecuredSeqImpl(securedModel, holder);
        if (seq instanceof SecuredSeq && checker.isEquivalent((SecuredSeq)seq)) {
            return (SecuredSeq)seq;
        }
        return (SecuredSeq)holder.setSecuredItem(new SecuredItemInvoker(seq.getClass(), checker));
    }

    protected SecuredSeqImpl(SecuredModel securedModel, ItemHolder<? extends Seq, ? extends SecuredSeq> holder) {
        super(securedModel, (ItemHolder<? extends Container, ? extends SecuredContainer>)holder);
        this.holder = holder;
    }

    public Seq add(int index, boolean o) {
        return this.add(index, this.asObject(o));
    }

    public Seq add(int index, long o) {
        return this.add(index, this.asObject(o));
    }

    public Seq add(int index, char o) {
        return this.add(index, this.asObject(Character.valueOf(o)));
    }

    public Seq add(int index, float o) {
        return this.add(index, this.asObject(Float.valueOf(o)));
    }

    public Seq add(int index, double o) {
        return this.add(index, this.asObject(o));
    }

    public Seq add(int index, Object o) {
        return this.add(index, this.asObject(o));
    }

    public Seq add(int index, String o) {
        return this.add(index, o, "");
    }

    public Seq add(int index, RDFNode o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(index, o);
        this.holder.getBaseItem().add(index, o);
        return this.holder.getSecuredItem();
    }

    public Seq add(int index, String o, String l) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.add(index, (RDFNode)this.holder.getBaseItem().getModel().createLiteral(o, l));
    }

    private void checkCreate(int index, RDFNode n) {
        this.checkCreate(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)n.asNode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement containerIndexOf(RDFNode n) {
        try (ExtendedIterator<Statement> iter = this.listProperties().filterKeep(new RDFNodeFilter(n));){
            if (iter.hasNext()) {
                Statement statement = (Statement)iter.next();
                return statement;
            }
            Statement statement = null;
            return statement;
        }
    }

    public SecuredAlt getAlt(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Alt a = this.holder.getBaseItem().getAlt(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)a.asNode()));
            return SecuredAltImpl.getInstance(this.getModel(), a);
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public SecuredBag getBag(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Bag b = this.holder.getBaseItem().getBag(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)b.asNode()));
            return SecuredBagImpl.getInstance(this.getModel(), b);
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public boolean getBoolean(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            boolean retval = this.holder.getBaseItem().getBoolean(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)this.asObject(retval).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public byte getByte(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            byte retval = this.holder.getBaseItem().getByte(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)this.asObject(retval).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public char getChar(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            char retval = this.holder.getBaseItem().getChar(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)this.asObject(Character.valueOf(retval)).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public double getDouble(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            double retval = this.holder.getBaseItem().getDouble(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)this.asObject(retval).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public float getFloat(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            float retval = this.holder.getBaseItem().getFloat(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)this.asObject(Float.valueOf(retval)).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public int getInt(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            int retval = this.holder.getBaseItem().getInt(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)this.asObject(retval).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public String getLanguage(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Literal literal = this.holder.getBaseItem().getLiteral(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)literal.asNode()));
            return literal.getLanguage();
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public SecuredLiteral getLiteral(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Literal literal = this.holder.getBaseItem().getLiteral(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)literal.asNode()));
            return SecuredLiteralImpl.getInstance(this.getModel(), literal);
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public long getLong(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            long retval = this.holder.getBaseItem().getLong(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)this.asObject(retval).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public SecuredRDFNode getObject(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            RDFNode retval = this.holder.getBaseItem().getObject(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)retval.asNode()));
            return SecuredRDFNodeImpl.getInstance(this.getModel(), retval);
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public SecuredResource getResource(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Resource retval = this.holder.getBaseItem().getResource(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)retval.asNode()));
            return SecuredResourceImpl.getInstance(this.getModel(), retval);
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public SecuredSeq getSeq(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            Seq retval = this.holder.getBaseItem().getSeq(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)retval.asNode()));
            return SecuredSeqImpl.getInstance(this.getModel(), retval);
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public short getShort(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            short retval = this.holder.getBaseItem().getShort(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)ResourceFactory.createTypedLiteral((Object)retval).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public String getString(int index) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            String retval = this.holder.getBaseItem().getString(index);
            this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)ResourceFactory.createTypedLiteral((Object)retval).asNode()));
            return retval;
        }
        throw new SeqIndexBoundsException(index, 0);
    }

    public int indexOf(boolean o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asObject(o));
    }

    public int indexOf(char o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asObject(Character.valueOf(o)));
    }

    public int indexOf(double o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asObject(o));
    }

    public int indexOf(float o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asObject(Float.valueOf(o)));
    }

    public int indexOf(long o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asObject(o));
    }

    public int indexOf(Object o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asObject(o));
    }

    public int indexOf(RDFNode o) throws ReadDeniedException, AuthenticationRequiredException {
        Statement stmt;
        if (this.checkSoftRead() && (stmt = this.containerIndexOf(o)) != null) {
            this.checkRead((FrontsTriple)stmt);
            return stmt.getPredicate().getOrdinal();
        }
        return 0;
    }

    public int indexOf(String o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asLiteral(o, ""));
    }

    public int indexOf(String o, String l) throws ReadDeniedException, AuthenticationRequiredException {
        return this.indexOf(this.asLiteral(o, l));
    }

    public SecuredSeq remove(int index) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        RDFNode rdfNode = this.holder.getBaseItem().getObject(index);
        if (rdfNode != null) {
            this.checkDelete(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)rdfNode.asNode()));
            this.holder.getBaseItem().remove(index);
        }
        return this.holder.getSecuredItem();
    }

    public SecuredSeq set(int index, boolean o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredSeq set(int index, char o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, (RDFNode)ResourceFactory.createTypedLiteral((Object)Character.valueOf(o)));
    }

    public SecuredSeq set(int index, double o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredSeq set(int index, float o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, (RDFNode)ResourceFactory.createTypedLiteral((Object)Float.valueOf(o)));
    }

    public SecuredSeq set(int index, long o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredSeq set(int index, Object o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, this.asObject(o));
    }

    public SecuredSeq set(int index, RDFNode o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple t2 = Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)o.asNode());
        RDFNode rdfNode = this.holder.getBaseItem().getObject(index);
        Triple t1 = Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)index).asNode(), (Node)rdfNode.asNode());
        this.checkUpdate(t1, t2);
        this.holder.getBaseItem().set(index, o);
        return this.holder.getSecuredItem();
    }

    public SecuredSeq set(int index, String o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, this.asLiteral(o, ""));
    }

    public SecuredSeq set(int index, String o, String l) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.set(index, this.asLiteral(o, l));
    }

    private class RDFNodeFilter
    implements Predicate<Statement> {
        private final RDFNode n;

        public RDFNodeFilter(RDFNode n) {
            this.n = n;
        }

        @Override
        public boolean test(Statement o) {
            return o.getPredicate().getOrdinal() != 0 && this.n.equals(o.getObject());
        }
    }
}

