/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.SecuredStatement;
import org.apache.jena.permissions.model.impl.SecuredRDFNodeImpl;
import org.apache.jena.permissions.model.impl.SecuredStatementImpl;
import org.apache.jena.permissions.model.impl.SecuredStatementIterator;
import org.apache.jena.permissions.utils.PermStatementFilter;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFVisitor;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class SecuredResourceImpl
extends SecuredRDFNodeImpl
implements SecuredResource {
    private final ItemHolder<? extends Resource, ? extends SecuredResource> holder;

    public static SecuredResource getInstance(SecuredModel securedModel, Resource resource) {
        if (securedModel == null) {
            throw new IllegalArgumentException("Secured securedModel may not be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Resource may not be null");
        }
        if (resource.isLiteral()) {
            throw new IllegalArgumentException("Resource may not be a literal");
        }
        Resource goodResource = resource;
        if (goodResource.getModel() == null) {
            Node n = resource.asNode();
            goodResource = resource.isAnon() ? securedModel.createResource(new AnonId(n.getBlankNodeLabel())) : securedModel.createResource(n.getURI());
        }
        ItemHolder holder = new ItemHolder(goodResource);
        SecuredResourceImpl checker = new SecuredResourceImpl(securedModel, holder);
        if (goodResource instanceof SecuredResource && checker.isEquivalent((SecuredResource)goodResource)) {
            return (SecuredResource)goodResource;
        }
        return (SecuredResource)holder.setSecuredItem(new SecuredItemInvoker(resource.getClass(), checker));
    }

    protected SecuredResourceImpl(SecuredModel securedModel, ItemHolder<? extends Resource, ? extends SecuredResource> holder) {
        super(securedModel, holder);
        this.holder = holder;
    }

    public SecuredResource abort() {
        this.holder.getBaseItem().abort();
        return this.holder.getSecuredItem();
    }

    public SecuredResource addLiteral(Property p, boolean o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredResource addLiteral(Property p, char o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)Character.valueOf(o)));
    }

    public SecuredResource addLiteral(Property value, double d) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(value, (RDFNode)ResourceFactory.createTypedLiteral((Object)d));
    }

    public SecuredResource addLiteral(Property value, float d) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(value, (RDFNode)ResourceFactory.createTypedLiteral((Object)Float.valueOf(d)));
    }

    public SecuredResource addLiteral(Property p, Literal o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(p, (RDFNode)o);
    }

    public SecuredResource addLiteral(Property p, long o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredResource addLiteral(Property p, Object o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(p, (RDFNode)ResourceFactory.createTypedLiteral((Object)o));
    }

    public SecuredResource addProperty(Property p, RDFNode o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)o.asNode()));
        this.holder.getBaseItem().addProperty(p, o);
        return this.holder.getSecuredItem();
    }

    public SecuredResource addProperty(Property p, String o) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        return this.addProperty(p, o, "");
    }

    public SecuredResource addProperty(Property p, String lexicalForm, RDFDatatype datatype) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Literal l = ResourceFactory.createTypedLiteral((String)lexicalForm, (RDFDatatype)datatype);
        this.checkCreate(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)l.asNode()));
        this.holder.getBaseItem().addProperty(p, (RDFNode)l);
        return this.holder.getSecuredItem();
    }

    public SecuredResource addProperty(Property p, String o, String l) throws UpdateDeniedException, AddDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)NodeFactory.createLiteralLang((String)o, (String)l)));
        this.holder.getBaseItem().addProperty(p, o, l);
        return this.holder.getSecuredItem();
    }

    public Literal asLiteral() {
        this.checkRead();
        throw new LiteralRequiredException(this.asNode());
    }

    public SecuredResource asResource() {
        return this.holder.getSecuredItem();
    }

    public SecuredResource begin() {
        this.holder.getBaseItem().begin();
        return this.holder.getSecuredItem();
    }

    public boolean canReadProperty(Node p) throws AuthenticationRequiredException {
        return this.canRead() && this.canRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p, (Node)Node.ANY));
    }

    protected void checkReadProperty(Node p) throws ReadDeniedException, AuthenticationRequiredException {
        if (!this.canReadProperty(p)) {
            throw new ReadDeniedException(SecuredItem.Util.triplePermissionMsg(this.getModelNode()), Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p, (Node)Node.ANY));
        }
    }

    public SecuredResource commit() {
        this.holder.getBaseItem().commit();
        return this.holder.getSecuredItem();
    }

    public AnonId getId() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().getId();
    }

    public String getLocalName() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().getLocalName();
    }

    public String getNameSpace() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().getNameSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecuredStatement getProperty(Supplier<ExtendedIterator<Statement>> supplier) {
        if (this.checkSoftRead()) {
            try (ExtendedIterator iter = supplier.get().filterKeep((Predicate)new PermStatementFilter(SecurityEvaluator.Action.Read, (SecuredItem)this));){
                if (iter.hasNext()) {
                    SecuredStatement securedStatement = SecuredStatementImpl.getInstance(this.getModel(), (Statement)iter.next());
                    return securedStatement;
                }
            }
        }
        return null;
    }

    public SecuredStatement getProperty(Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.getProperty(() -> this.holder.getBaseItem().listProperties(p));
    }

    public SecuredStatement getProperty(Property p, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        return this.getProperty(() -> this.holder.getBaseItem().listProperties(p, lang));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredResource getPropertyResourceValue(Property p) throws AuthenticationRequiredException {
        try (SecuredStatementIterator iter = this.listProperties(p);){
            while (iter.hasNext()) {
                Statement s = iter.next();
                if (!s.getObject().isResource()) continue;
                SecuredResource securedResource = SecuredResourceImpl.getInstance(this.getModel(), s.getObject().asResource());
                return securedResource;
            }
        }
        return null;
    }

    public SecuredStatement getRequiredProperty(Property p) throws PropertyNotFoundException, ReadDeniedException, AuthenticationRequiredException {
        SecuredStatement stmt = this.getProperty(() -> this.holder.getBaseItem().listProperties(p));
        if (stmt == null) {
            throw new PropertyNotFoundException(p);
        }
        return stmt;
    }

    public SecuredStatement getRequiredProperty(Property p, String lang) throws PropertyNotFoundException, ReadDeniedException, AuthenticationRequiredException {
        SecuredStatement stmt = this.getProperty(() -> this.holder.getBaseItem().listProperties(p, lang));
        if (stmt == null) {
            throw new PropertyNotFoundException(p);
        }
        return stmt;
    }

    public String getURI() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().getURI();
    }

    public Statement getStmtTerm() {
        Statement stmt;
        if (this.checkSoftRead() && (stmt = this.holder.getBaseItem().getStmtTerm()) != null && this.canRead((FrontsTriple)stmt)) {
            return SecuredStatementImpl.getInstance(this.getModel(), stmt);
        }
        return null;
    }

    public boolean hasLiteral(Property p, boolean o) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead() && this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)o).asNode()))) {
            return this.holder.getBaseItem().hasLiteral(p, o);
        }
        return false;
    }

    public boolean hasLiteral(Property p, char o) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead() && this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)Character.valueOf(o)).asNode()))) {
            return this.holder.getBaseItem().hasLiteral(p, o);
        }
        return false;
    }

    public boolean hasLiteral(Property p, double o) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead() && this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)o).asNode()))) {
            return this.holder.getBaseItem().hasLiteral(p, o);
        }
        return false;
    }

    public boolean hasLiteral(Property p, float o) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead() && this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)Float.valueOf(o)).asNode()))) {
            return this.holder.getBaseItem().hasLiteral(p, o);
        }
        return false;
    }

    public boolean hasLiteral(Property p, long o) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead() && this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)o).asNode()))) {
            return this.holder.getBaseItem().hasLiteral(p, o);
        }
        return false;
    }

    public boolean hasLiteral(Property p, Object o) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead() && this.checkRead(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)o).asNode()))) {
            return this.holder.getBaseItem().hasLiteral(p, o);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProperty(Supplier<ExtendedIterator<Statement>> supplier) {
        if (this.checkSoftRead()) {
            try (ExtendedIterator iter = supplier.get().filterKeep((Predicate)new PermStatementFilter(SecurityEvaluator.Action.Read, (SecuredItem)this));){
                boolean bl = iter.hasNext();
                return bl;
            }
        }
        return false;
    }

    public boolean hasProperty(Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.hasProperty(() -> this.holder.getBaseItem().listProperties(p));
    }

    public boolean hasProperty(Property p, RDFNode o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.hasProperty(() -> this.holder.getBaseItem().getModel().listStatements((Resource)this, p, o));
    }

    public boolean hasProperty(Property p, String o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.hasProperty(() -> this.holder.getBaseItem().getModel().listStatements((Resource)this, p, o));
    }

    public boolean hasProperty(Property p, String o, String l) throws ReadDeniedException, AuthenticationRequiredException {
        Literal ll = this.holder.getBaseItem().getModel().createLiteral(o, l);
        return this.hasProperty(() -> this.holder.getBaseItem().getModel().listStatements((Resource)this, p, (RDFNode)ll));
    }

    public boolean hasURI(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().hasURI(uri);
    }

    public Resource inModel(Model m) {
        this.checkRead();
        return this.holder.getBaseItem().inModel(m);
    }

    private SecuredStatementIterator listProperties(Supplier<StmtIterator> supplier) {
        ExtendedIterator iter = this.checkSoftRead() ? (ExtendedIterator)supplier.get() : NiceIterator.emptyIterator();
        return new SecuredStatementIterator(this.getModel(), (ExtendedIterator<Statement>)iter);
    }

    public SecuredStatementIterator listProperties() throws ReadDeniedException, AuthenticationRequiredException {
        return this.listProperties(() -> this.holder.getBaseItem().listProperties());
    }

    public SecuredStatementIterator listProperties(Property p) throws ReadDeniedException, AuthenticationRequiredException {
        return this.listProperties(() -> this.holder.getBaseItem().listProperties(p));
    }

    public SecuredStatementIterator listProperties(Property p, String lang) throws ReadDeniedException, AuthenticationRequiredException {
        return this.listProperties(() -> this.holder.getBaseItem().listProperties(p, lang));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredResource removeAll(Property p) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)p.asNode(), (Node)Node.ANY))) {
            try (StmtIterator iter = this.holder.getBaseItem().listProperties(p);){
                if (!iter.hasNext()) {
                    SecuredResource securedResource = this.holder.getSecuredItem();
                    return securedResource;
                }
                while (iter.hasNext()) {
                    this.checkDelete(((Statement)iter.next()).asTriple());
                }
            }
        }
        this.holder.getBaseItem().removeAll(p);
        return this.holder.getSecuredItem();
    }

    public SecuredResource removeProperties() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)Node.ANY, (Node)Node.ANY))) {
            try (StmtIterator iter = this.holder.getBaseItem().listProperties();){
                if (!iter.hasNext()) {
                    SecuredResource securedResource = this.holder.getSecuredItem();
                    return securedResource;
                }
                while (iter.hasNext()) {
                    this.checkDelete(((Statement)iter.next()).asTriple());
                }
            }
        }
        this.holder.getBaseItem().removeProperties();
        return this.holder.getSecuredItem();
    }

    public Object visitWith(RDFVisitor rv) {
        return this.isAnon() ? rv.visitBlank((Resource)this, this.getId()) : rv.visitURI((Resource)this, this.getURI());
    }
}

