/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SecuredResIterator
implements ResIterator {
    private final ExtendedIterator<Resource> iter;

    public SecuredResIterator(SecuredModel securedModel, ExtendedIterator<Resource> wrapped) {
        PermResourceMap map1 = new PermResourceMap(securedModel);
        this.iter = wrapped.mapWith((Function)map1);
    }

    public <X extends Resource> ExtendedIterator<Resource> andThen(Iterator<X> other) {
        return this.iter.andThen(other);
    }

    public void close() {
        this.iter.close();
    }

    public ExtendedIterator<Resource> filterDrop(Predicate<Resource> f) {
        return this.iter.filterDrop(f);
    }

    public ExtendedIterator<Resource> filterKeep(Predicate<Resource> f) {
        return this.iter.filterKeep(f);
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public <U> ExtendedIterator<U> mapWith(Function<Resource, U> map1) {
        return this.iter.mapWith(map1);
    }

    public Resource next() {
        return (Resource)this.iter.next();
    }

    public Resource nextResource() {
        return this.next();
    }

    public void remove() {
        this.iter.remove();
    }

    public Resource removeNext() {
        return (Resource)this.iter.removeNext();
    }

    public List<Resource> toList() {
        return this.iter.toList();
    }

    public Set<Resource> toSet() {
        return this.iter.toSet();
    }

    private class PermResourceMap
    implements Function<Resource, Resource> {
        private final SecuredModel securedModel;

        public PermResourceMap(SecuredModel securedModel) {
            this.securedModel = securedModel;
        }

        @Override
        public SecuredResource apply(Resource o) {
            return SecuredResourceImpl.getInstance(this.securedModel, o);
        }
    }
}

