/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jena.enhanced.UnsupportedPolymorphismException;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemImpl;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredRDFNode;
import org.apache.jena.permissions.model.SecuredUnsupportedPolymorphismException;
import org.apache.jena.permissions.model.impl.SecuredLiteralImpl;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.ReadDeniedException;

public abstract class SecuredRDFNodeImpl
extends SecuredItemImpl
implements SecuredRDFNode {
    private final ItemHolder<? extends RDFNode, ? extends SecuredRDFNode> holder;
    private final SecuredModel securedModel;

    public static SecuredRDFNode getInstance(SecuredModel securedModel, RDFNode rdfNode) {
        if (rdfNode instanceof Literal) {
            return SecuredLiteralImpl.getInstance(securedModel, (Literal)rdfNode);
        }
        return SecuredResourceImpl.getInstance(securedModel, (Resource)rdfNode);
    }

    protected SecuredRDFNodeImpl(SecuredModel securedModel, ItemHolder<? extends RDFNode, ? extends SecuredRDFNode> holder) {
        super(securedModel, holder);
        if (holder.getBaseItem().getModel() == null) {
            throw new IllegalArgumentException(String.format("Holder base item (%s) must have a securedModel", holder.getBaseItem().getClass()));
        }
        this.securedModel = securedModel;
        this.holder = holder;
    }

    public <T extends RDFNode> T as(Class<T> view) throws ReadDeniedException, AuthenticationRequiredException, SecuredUnsupportedPolymorphismException {
        this.checkRead();
        RDFNode baseAs = this.holder.getBaseItem().as(view);
        if (view.equals(SecuredRDFNodeImpl.class) || view.equals(RDFNode.class)) {
            return (T)this;
        }
        Method m = this.getConstructor(view);
        if (m == null) {
            throw new SecuredUnsupportedPolymorphismException(this, view);
        }
        try {
            return (T)((RDFNode)m.invoke(null, this.securedModel, baseAs));
        }
        catch (UnsupportedPolymorphismException e) {
            throw new SecuredUnsupportedPolymorphismException(this, view);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Node asNode() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().asNode();
    }

    public <T extends RDFNode> boolean canAs(Class<T> view) throws AuthenticationRequiredException {
        if (this.canRead() && this.holder.getBaseItem().canAs(view)) {
            return this.getConstructor(view) != null;
        }
        return false;
    }

    private <T extends RDFNode> Method getConstructor(Class<T> view) {
        String classNm = SecuredRDFNodeImpl.class.getName();
        classNm = String.format("%s.Secured%sImpl", classNm.substring(0, classNm.lastIndexOf(".")), view.getSimpleName());
        try {
            Class<?> c = Class.forName(classNm);
            return c.getDeclaredMethod("getInstance", SecuredModel.class, view);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public SecuredModel getModel() {
        return this.securedModel;
    }

    public RDFNode inModel(Model m) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        if (this.securedModel.equals(m)) {
            return this;
        }
        if (m instanceof SecuredModel) {
            return SecuredRDFNodeImpl.getInstance((SecuredModel)m, this.holder.getBaseItem().inModel(m));
        }
        return this.holder.getBaseItem().inModel(m);
    }

    public boolean isAnon() {
        return this.holder.getBaseItem().isAnon();
    }

    public boolean isLiteral() {
        return this.holder.getBaseItem().isLiteral();
    }

    public boolean isResource() {
        return this.holder.getBaseItem().isResource();
    }

    public boolean isURIResource() {
        return this.holder.getBaseItem().isURIResource();
    }

    public boolean isStmtResource() {
        return this.holder.getBaseItem().isStmtResource();
    }

    @Override
    public final boolean equals(Object o) throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return o instanceof FrontsNode && this.asNode().equals((Object)((FrontsNode)o).asNode());
    }

    @Override
    public final int hashCode() {
        return this.holder.getBaseItem().asNode().hashCode();
    }
}

