/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import org.apache.jena.graph.Node;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredProperty;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.ReadDeniedException;

public class SecuredPropertyImpl
extends SecuredResourceImpl
implements SecuredProperty {
    private final ItemHolder<? extends Property, ? extends SecuredProperty> holder;

    public static SecuredProperty getInstance(SecuredModel securedModel, Property property) {
        if (securedModel == null) {
            throw new IllegalArgumentException("SecuredModel may not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property may not be null");
        }
        Property goodProp = property;
        if (goodProp.getModel() == null) {
            Node n = property.asNode();
            goodProp = property.isAnon() ? securedModel.createProperty(n.getBlankNodeLabel()) : securedModel.createProperty(property.asNode().getURI());
        }
        ItemHolder holder = new ItemHolder(goodProp);
        SecuredPropertyImpl checker = new SecuredPropertyImpl(securedModel, holder);
        if (goodProp instanceof SecuredProperty && checker.isEquivalent((SecuredProperty)goodProp)) {
            return (SecuredProperty)goodProp;
        }
        return (SecuredProperty)holder.setSecuredItem(new SecuredItemInvoker(property.getClass(), checker));
    }

    private SecuredPropertyImpl(SecuredModel securedModel, ItemHolder<? extends Property, ? extends SecuredProperty> holder) {
        super(securedModel, (ItemHolder<? extends Resource, ? extends SecuredResource>)holder);
        this.holder = holder;
    }

    public int getOrdinal() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().getOrdinal();
    }

    public Property inModel(Model m) {
        return (Property)super.inModel(m);
    }

    public boolean isProperty() {
        return true;
    }
}

