/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredContainer;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.impl.SecuredNodeIterator;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.permissions.model.impl.SecuredStatementIterator;
import org.apache.jena.permissions.utils.ContainerFilter;
import org.apache.jena.permissions.utils.PermStatementFilter;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDF;

public class SecuredContainerImpl
extends SecuredResourceImpl
implements SecuredContainer {
    private final ItemHolder<? extends Container, ? extends SecuredContainer> holder;

    public static SecuredContainer getInstance(SecuredModel securedModel, Container container) {
        if (securedModel == null) {
            throw new IllegalArgumentException("Secured securedModel may not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("Container may not be null");
        }
        Container goodContainer = container;
        if (goodContainer.getModel() == null) {
            container.asNode();
            goodContainer = securedModel.createBag();
        }
        ItemHolder holder = new ItemHolder(goodContainer);
        SecuredContainerImpl checker = new SecuredContainerImpl(securedModel, holder);
        if (goodContainer instanceof SecuredContainer && checker.isEquivalent((SecuredContainer)goodContainer)) {
            return (SecuredContainer)goodContainer;
        }
        return (SecuredContainer)holder.setSecuredItem(new SecuredItemInvoker(container.getClass(), checker));
    }

    protected SecuredContainerImpl(SecuredModel securedModel, ItemHolder<? extends Container, ? extends SecuredContainer> holder) {
        super(securedModel, (ItemHolder<? extends Resource, ? extends SecuredResource>)holder);
        this.holder = holder;
    }

    protected RDFNode asObject(Object o) {
        return o instanceof RDFNode ? (RDFNode)o : this.holder.getBaseItem().getModel().createTypedLiteral(o);
    }

    protected RDFNode asLiteral(String value, String language) {
        return this.holder.getBaseItem().getModel().createLiteral(value, language);
    }

    public SecuredContainer add(boolean o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(this.asObject(o));
    }

    public SecuredContainer add(char o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(this.asObject(Character.valueOf(o)));
    }

    public SecuredContainer add(double o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(this.asObject(o));
    }

    public SecuredContainer add(float o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(this.asObject(Float.valueOf(o)));
    }

    public SecuredContainer add(long o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(this.asObject(o));
    }

    public SecuredContainer add(Object o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(this.asObject(o));
    }

    public SecuredContainer add(RDFNode o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        int pos = this.holder.getBaseItem().size();
        this.checkAdd(pos, o.asNode());
        this.holder.getBaseItem().add(o);
        return this.holder.getSecuredItem();
    }

    public SecuredContainer add(String o) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(o, "");
    }

    public SecuredContainer add(String o, String l) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        return this.add(this.asLiteral(o, l));
    }

    protected void checkAdd(int pos, Literal literal) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        this.checkAdd(pos, literal.asNode());
    }

    protected void checkAdd(int pos, Node node) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        this.checkCreate(Triple.create((Node)this.holder.getBaseItem().asNode(), (Node)RDF.li((int)pos).asNode(), (Node)node));
    }

    public boolean contains(boolean o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(this.asObject(o));
    }

    public boolean contains(char o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(this.asObject(Character.valueOf(o)));
    }

    public boolean contains(double o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(this.asObject(o));
    }

    public boolean contains(float o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(this.asObject(Float.valueOf(o)));
    }

    public boolean contains(long o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(this.asObject(o));
    }

    public boolean contains(Object o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(this.asObject(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RDFNode o) throws ReadDeniedException, AuthenticationRequiredException {
        try (NodeIterator iter = this.iterator();){
            while (iter.hasNext()) {
                if (!iter.next().asNode().equals((Object)o.asNode())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean contains(String o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(o, "");
    }

    public boolean contains(String o, String l) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(this.asLiteral(o, l));
    }

    protected int getAddIndex() {
        int pos = -1;
        try (StmtIterator iter = this.holder.getBaseItem().listProperties();){
            while (iter.hasNext()) {
                pos = Math.max(pos, SecuredContainerImpl.getIndex(((Statement)iter.next()).getPredicate()));
            }
        }
        return pos + 1;
    }

    protected static int getIndex(Property p) {
        if (p.getNameSpace().equals(RDF.getURI()) && p.getLocalName().startsWith("_")) {
            try {
                return Integer.parseInt(p.getLocalName().substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected ExtendedIterator<Statement> getStatementIterator(SecurityEvaluator.Action perm) {
        return this.holder.getBaseItem().listProperties().filterKeep((Predicate)new ContainerFilter()).filterKeep((Predicate)new PermStatementFilter(perm, (SecuredItem)this));
    }

    protected ExtendedIterator<Statement> getStatementIterator(Set<SecurityEvaluator.Action> perm) {
        return this.holder.getBaseItem().listProperties().filterKeep((Predicate)new ContainerFilter()).filterKeep((Predicate)new PermStatementFilter(perm, (SecuredItem)this));
    }

    public boolean isAlt() {
        return this.holder.getBaseItem().isAlt();
    }

    public boolean isBag() {
        return this.holder.getBaseItem().isBag();
    }

    public boolean isSeq() {
        return this.holder.getBaseItem().isSeq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredNodeIterator<RDFNode> iterator() {
        try (SecuredStatementIterator iter = this.listProperties();){
            TreeSet<Statement> result = new TreeSet<Statement>(new ContainerComparator());
            while (iter.hasNext()) {
                Statement stmt = iter.next();
                if (stmt.getPredicate().getOrdinal() <= 0) continue;
                result.add(stmt);
            }
            SecuredNodeIterator<RDFNode> securedNodeIterator = new SecuredNodeIterator<RDFNode>(this.getModel(), new StatementRemovingIterator(result.iterator()).mapWith(s -> s.getObject()));
            return securedNodeIterator;
        }
    }

    protected SecuredNodeIterator<RDFNode> iterator(Set<SecurityEvaluator.Action> perms) {
        this.checkRead();
        HashSet<SecurityEvaluator.Action> permsCopy = new HashSet<SecurityEvaluator.Action>(perms);
        permsCopy.add(SecurityEvaluator.Action.Read);
        ExtendedIterator ni = this.getStatementIterator(perms).mapWith(o -> o.getObject());
        return new SecuredNodeIterator<RDFNode>(this.getModel(), ni);
    }

    public SecuredContainer remove(Statement s) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkDelete(s.asTriple());
        this.holder.getBaseItem().remove(s);
        return this.holder.getSecuredItem();
    }

    public int size() throws ReadDeniedException, AuthenticationRequiredException {
        this.checkRead();
        return this.holder.getBaseItem().size();
    }

    static class ContainerComparator
    implements Comparator<Statement> {
        ContainerComparator() {
        }

        @Override
        public int compare(Statement arg0, Statement arg1) {
            return Integer.valueOf(arg0.getPredicate().getOrdinal()).compareTo(arg1.getPredicate().getOrdinal());
        }
    }

    static class StatementRemovingIterator
    extends WrappedIterator<Statement> {
        private Statement stmt;

        public StatementRemovingIterator(Iterator<? extends Statement> base) {
            super(base);
        }

        public Statement next() {
            this.stmt = (Statement)super.next();
            return this.stmt;
        }

        public void remove() {
            this.stmt.remove();
            super.remove();
        }
    }
}

