/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.model.impl;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemInvoker;
import org.apache.jena.permissions.model.SecuredAlt;
import org.apache.jena.permissions.model.SecuredBag;
import org.apache.jena.permissions.model.SecuredContainer;
import org.apache.jena.permissions.model.SecuredLiteral;
import org.apache.jena.permissions.model.SecuredModel;
import org.apache.jena.permissions.model.SecuredRDFNode;
import org.apache.jena.permissions.model.SecuredResource;
import org.apache.jena.permissions.model.SecuredSeq;
import org.apache.jena.permissions.model.impl.SecuredBagImpl;
import org.apache.jena.permissions.model.impl.SecuredContainerImpl;
import org.apache.jena.permissions.model.impl.SecuredLiteralImpl;
import org.apache.jena.permissions.model.impl.SecuredRDFNodeImpl;
import org.apache.jena.permissions.model.impl.SecuredResourceImpl;
import org.apache.jena.permissions.model.impl.SecuredSeqImpl;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.AltHasNoDefaultException;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SecuredAltImpl
extends SecuredContainerImpl
implements SecuredAlt {
    private final ItemHolder<? extends Alt, ? extends SecuredAlt> holder;

    public static SecuredAlt getInstance(SecuredModel securedModel, Alt alt) {
        if (securedModel == null) {
            throw new IllegalArgumentException("Secured securedModel may not be null");
        }
        if (alt == null) {
            throw new IllegalArgumentException("Alt may not be null");
        }
        ItemHolder holder = new ItemHolder(alt);
        SecuredAltImpl checker = new SecuredAltImpl(securedModel, holder);
        if (alt instanceof SecuredAlt && checker.isEquivalent((SecuredAlt)alt)) {
            return (SecuredAlt)alt;
        }
        return (SecuredAlt)holder.setSecuredItem(new SecuredItemInvoker(alt.getClass(), checker));
    }

    protected SecuredAltImpl(SecuredModel securedModel, ItemHolder<? extends Alt, ? extends SecuredAlt> holder) {
        super(securedModel, (ItemHolder<? extends Container, ? extends SecuredContainer>)holder);
        this.holder = holder;
    }

    public SecuredRDFNode getDefault() throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredRDFNodeImpl.getInstance(this.getModel(), this.getDefaultStatement().getObject());
    }

    public SecuredAlt getDefaultAlt() throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredAltImpl.getInstance(this.getModel(), this.getDefaultStatement().getAlt());
    }

    public SecuredBag getDefaultBag() throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredBagImpl.getInstance(this.getModel(), this.getDefaultStatement().getBag());
    }

    public boolean getDefaultBoolean() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getBoolean();
    }

    public byte getDefaultByte() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getByte();
    }

    public char getDefaultChar() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getChar();
    }

    public double getDefaultDouble() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getDouble();
    }

    public float getDefaultFloat() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getFloat();
    }

    public int getDefaultInt() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getInt();
    }

    public String getDefaultLanguage() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getLanguage();
    }

    public SecuredLiteral getDefaultLiteral() throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredLiteralImpl.getInstance(this.getModel(), this.getDefaultStatement().getLiteral());
    }

    public long getDefaultLong() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getLong();
    }

    public SecuredResource getDefaultResource() throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredResourceImpl.getInstance(this.getModel(), this.getDefaultStatement().getResource());
    }

    public SecuredSeq getDefaultSeq() throws ReadDeniedException, AuthenticationRequiredException {
        return SecuredSeqImpl.getInstance(this.getModel(), this.getDefaultStatement().getSeq());
    }

    public short getDefaultShort() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getShort();
    }

    private Statement getDefaultStatement() throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            try (ExtendedIterator<Statement> iter = this.getStatementIterator(SecurityEvaluator.Action.Read);){
                if (iter.hasNext()) {
                    Statement statement = (Statement)iter.next();
                    return statement;
                }
            }
        }
        throw new AltHasNoDefaultException((Alt)this);
    }

    public String getDefaultString() throws ReadDeniedException, AuthenticationRequiredException {
        return this.getDefaultStatement().getString();
    }

    public SecuredAlt setDefault(boolean o) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asObject(o));
    }

    public SecuredAlt setDefault(char o) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asObject(Character.valueOf(o)));
    }

    public SecuredAlt setDefault(double o) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asObject(o));
    }

    public SecuredAlt setDefault(float o) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asObject(Float.valueOf(o)));
    }

    public SecuredAlt setDefault(long o) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asObject(o));
    }

    public SecuredAlt setDefault(Object o) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asObject(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredAlt setDefault(RDFNode o) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        try (ExtendedIterator<Statement> iter = this.getStatementIterator(SecurityEvaluator.Action.Read);){
            if (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                Triple t = stmt.asTriple();
                Triple t2 = Triple.create((Node)t.getSubject(), (Node)t.getPredicate(), (Node)o.asNode());
                this.checkUpdate(t, t2);
                stmt.changeObject(o);
                SecuredAlt securedAlt = this.holder.getSecuredItem();
                return securedAlt;
            }
            this.add(o);
            SecuredAlt securedAlt = this.holder.getSecuredItem();
            return securedAlt;
        }
    }

    public SecuredAlt setDefault(String o) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asLiteral(o, ""));
    }

    public SecuredAlt setDefault(String o, String l) throws UpdateDeniedException, AuthenticationRequiredException {
        return this.setDefault(this.asLiteral(o, l));
    }
}

