/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ClassUtils;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.impl.SecuredItemImpl;
import org.apache.jena.permissions.impl.SecuredItemInvoker;

public class ItemHolder<Base, Secured extends SecuredItem> {
    private final Base baseItem;
    private Secured securedItem;

    public ItemHolder(Base baseItem) {
        this.baseItem = baseItem;
    }

    public Base getBaseItem() {
        return this.baseItem;
    }

    public Secured getSecuredItem() {
        return this.securedItem;
    }

    public final Secured setSecuredItem(SecuredItemInvoker handler) {
        LinkedHashSet ifac = new LinkedHashSet();
        if (this.baseItem.getClass().isInterface()) {
            ifac.add(this.baseItem.getClass());
        }
        ifac.addAll(ClassUtils.getAllInterfaces(this.baseItem.getClass()));
        if (handler.securedItem.getClass().isInterface()) {
            ifac.add(handler.securedItem.getClass());
        }
        ifac.addAll(ClassUtils.getAllInterfaces(handler.securedItem.getClass()));
        this.securedItem = (SecuredItem)Proxy.newProxyInstance(SecuredItemImpl.class.getClassLoader(), ifac.toArray(new Class[ifac.size()]), (InvocationHandler)handler);
        return this.securedItem;
    }
}

