/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.graph.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.jena.permissions.graph.SecuredPrefixMapping;
import org.apache.jena.permissions.graph.impl.SecuredGraphImpl;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemImpl;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.shared.impl.PrefixMappingImpl;

public class SecuredPrefixMappingImpl
extends SecuredItemImpl
implements SecuredPrefixMapping {
    private final ItemHolder<PrefixMapping, SecuredPrefixMapping> holder;

    SecuredPrefixMappingImpl(SecuredGraphImpl graph, ItemHolder<PrefixMapping, SecuredPrefixMapping> holder) {
        super(graph, holder);
        this.holder = holder;
    }

    @Override
    public String expandPrefix(String prefixed) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().expandPrefix(prefixed) : prefixed;
    }

    @Override
    public Map<String, String> getNsPrefixMap() throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().getNsPrefixMap() : Collections.emptyMap();
    }

    @Override
    public String getNsPrefixURI(String prefix) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().getNsPrefixURI(prefix) : null;
    }

    @Override
    public String getNsURIPrefix(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().getNsURIPrefix(uri) : null;
    }

    @Override
    public SecuredPrefixMapping lock() throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().lock();
        return this.holder.getSecuredItem();
    }

    @Override
    public String qnameFor(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().qnameFor(uri) : null;
    }

    @Override
    public SecuredPrefixMapping removeNsPrefix(String prefix) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().removeNsPrefix(prefix);
        return this.holder.getSecuredItem();
    }

    public PrefixMapping clearNsPrefixMap() {
        this.checkUpdate();
        this.holder.getBaseItem().clearNsPrefixMap();
        return this.holder.getSecuredItem();
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().samePrefixMappingAs(other) : false;
    }

    @Override
    public SecuredPrefixMapping setNsPrefix(String prefix, String uri) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().setNsPrefix(prefix, uri);
        return this.holder.getSecuredItem();
    }

    @Override
    public SecuredPrefixMapping setNsPrefixes(Map<String, String> map) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().setNsPrefixes(map);
        return this.holder.getSecuredItem();
    }

    @Override
    public SecuredPrefixMapping setNsPrefixes(PrefixMapping other) throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.holder.getBaseItem().setNsPrefixes(other);
        return this.holder.getSecuredItem();
    }

    @Override
    public String shortForm(String uri) throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().shortForm(uri) : uri;
    }

    public boolean hasNoMappings() {
        return this.checkSoftRead() ? this.holder.getBaseItem().hasNoMappings() : true;
    }

    public int numPrefixes() {
        return this.checkSoftRead() ? this.holder.getBaseItem().numPrefixes() : 0;
    }

    @Override
    public SecuredPrefixMapping withDefaultMappings(PrefixMapping map) throws UpdateDeniedException, AuthenticationRequiredException {
        PrefixMapping m = this.holder.getBaseItem();
        PrefixMappingImpl pm = new PrefixMappingImpl();
        for (Map.Entry e : map.getNsPrefixMap().entrySet()) {
            if (m.getNsPrefixURI((String)e.getKey()) != null || m.getNsURIPrefix((String)e.getValue()) != null) continue;
            pm.setNsPrefix((String)e.getKey(), (String)e.getValue());
        }
        if (!pm.getNsPrefixMap().isEmpty()) {
            this.checkUpdate();
            this.holder.getBaseItem().withDefaultMappings((PrefixMapping)pm);
        }
        return this.holder.getSecuredItem();
    }
}

