/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.graph.impl;

import org.apache.commons.collections4.IteratorUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.graph.SecuredCapabilities;
import org.apache.jena.permissions.graph.SecuredGraph;
import org.apache.jena.permissions.graph.SecuredGraphEventManager;
import org.apache.jena.permissions.graph.SecuredPrefixMapping;
import org.apache.jena.permissions.graph.impl.Factory;
import org.apache.jena.permissions.impl.ItemHolder;
import org.apache.jena.permissions.impl.SecuredItemImpl;
import org.apache.jena.permissions.utils.PermTripleFilter;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.ReadDeniedException;
import org.apache.jena.shared.UpdateDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SecuredGraphImpl
extends SecuredItemImpl
implements SecuredGraph {
    private SecuredPrefixMapping prefixMapping;
    private final ItemHolder<Graph, SecuredGraphImpl> holder;
    private final SecuredGraphEventManager eventManager;

    SecuredGraphImpl(SecurityEvaluator securityEvaluator, String modelURI, ItemHolder<Graph, SecuredGraphImpl> holder) {
        super(securityEvaluator, modelURI, holder);
        this.holder = holder;
        this.eventManager = new SecuredGraphEventManager(this, holder.getBaseItem(), holder.getBaseItem().getEventManager());
    }

    public void add(Triple t) throws AddDeniedException, UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkCreate(t);
        this.holder.getBaseItem().add(t);
    }

    public void clear() throws UpdateDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        if (!this.canDelete(Triple.ANY)) {
            ExtendedIterator iter = this.holder.getBaseItem().find(Triple.ANY);
            while (iter.hasNext()) {
                this.checkDelete((Triple)iter.next());
            }
        }
        this.holder.getBaseItem().clear();
    }

    public void close() {
        this.holder.getBaseItem().close();
    }

    public boolean contains(Node s, Node p, Node o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.contains(Triple.create((Node)s, (Node)p, (Node)o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Triple t) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(t)) {
                return this.holder.getBaseItem().contains(t);
            }
            try (ExtendedIterator iter = this.holder.getBaseItem().find(t);){
                while (iter.hasNext()) {
                    if (!this.canRead((Triple)iter.next())) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    public void delete(Triple t) throws DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        this.checkDelete(t);
        this.holder.getBaseItem().delete(t);
    }

    public boolean dependsOn(Graph other) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (other.equals(this.holder.getBaseItem())) {
                return true;
            }
            return this.holder.getBaseItem().dependsOn(other);
        }
        return false;
    }

    public ExtendedIterator<Triple> find() throws ReadDeniedException, AuthenticationRequiredException {
        return this.createIterator(() -> this.holder.getBaseItem().find(Triple.ANY), () -> new PermTripleFilter(SecurityEvaluator.Action.Read, (SecuredItem)this));
    }

    public ExtendedIterator<Triple> find(Node s, Node p, Node o) throws ReadDeniedException, AuthenticationRequiredException {
        return this.createIterator(() -> this.holder.getBaseItem().find(s, p, o), () -> new PermTripleFilter(SecurityEvaluator.Action.Read, (SecuredItem)this));
    }

    public ExtendedIterator<Triple> find(Triple t) throws ReadDeniedException, AuthenticationRequiredException {
        return this.createIterator(() -> this.holder.getBaseItem().find(t), () -> new PermTripleFilter(SecurityEvaluator.Action.Read, (SecuredItem)this));
    }

    public SecuredCapabilities getCapabilities() {
        return new SecuredCapabilities(this.getSecurityEvaluator(), this.getModelIRI(), this.holder.getBaseItem().getCapabilities());
    }

    public SecuredGraphEventManager getEventManager() {
        return this.eventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredPrefixMapping getPrefixMapping() {
        if (this.prefixMapping == null) {
            SecuredGraphImpl securedGraphImpl = this;
            synchronized (securedGraphImpl) {
                if (this.prefixMapping == null) {
                    this.prefixMapping = Factory.getInstance(this, this.holder.getBaseItem().getPrefixMapping());
                }
            }
        }
        return this.prefixMapping;
    }

    public TransactionHandler getTransactionHandler() {
        return this.holder.getBaseItem().getTransactionHandler();
    }

    public boolean isClosed() {
        return this.holder.getBaseItem().isClosed();
    }

    public boolean isEmpty() throws ReadDeniedException, AuthenticationRequiredException {
        return this.checkSoftRead() ? this.holder.getBaseItem().isEmpty() : true;
    }

    public boolean isIsomorphicWith(Graph g) throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (g.size() != this.holder.getBaseItem().size()) {
                return false;
            }
            Triple t = Triple.create((Node)Node.ANY, (Node)Node.ANY, (Node)Node.ANY);
            if (!this.canRead(t)) {
                ExtendedIterator iter = g.find(t);
                while (iter.hasNext()) {
                    if (this.checkRead((Triple)iter.next())) continue;
                    return false;
                }
            }
            return this.holder.getBaseItem().isIsomorphicWith(g);
        }
        return g.isEmpty();
    }

    public void remove(Node s, Node p, Node o) throws UpdateDeniedException, DeleteDeniedException, AuthenticationRequiredException {
        this.checkUpdate();
        Triple t = Triple.create((Node)s, (Node)p, (Node)o);
        if (t.isConcrete()) {
            this.checkDelete(t);
        } else {
            ExtendedIterator iter = this.holder.getBaseItem().find(t);
            while (iter.hasNext()) {
                this.checkDelete((Triple)iter.next());
            }
        }
        this.holder.getBaseItem().remove(s, p, o);
    }

    public int size() throws ReadDeniedException, AuthenticationRequiredException {
        if (this.checkSoftRead()) {
            if (this.canRead(Triple.ANY)) {
                return this.holder.getBaseItem().size();
            }
            return IteratorUtils.size(this.find(Triple.ANY));
        }
        return 0;
    }
}

