/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.graph;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.CollectionGraph;
import org.apache.jena.permissions.SecuredItem;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.graph.SecuredGraph;
import org.apache.jena.permissions.impl.CachedSecurityEvaluator;
import org.apache.jena.permissions.utils.PermTripleFilter;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class SecuredGraphEventManager
implements GraphEventManager {
    private final SecuredGraph securedGraph;
    private final Graph baseGraph;
    private final Map<GraphListener, Deque<SecuredGraphListener>> listenerMap = new HashMap<GraphListener, Deque<SecuredGraphListener>>();
    private static Set<SecurityEvaluator.Action> DELETE;
    private static Set<SecurityEvaluator.Action> ADD;

    public SecuredGraphEventManager(SecuredGraph securedGraph, Graph baseGraph, GraphEventManager manager) {
        this.securedGraph = securedGraph;
        this.baseGraph = baseGraph;
        manager.register((GraphListener)this);
    }

    private synchronized Collection<SecuredGraphListener> getListenerCollection() {
        ExtendedIterator retval = NiceIterator.emptyIterator();
        for (Collection collection : this.listenerMap.values()) {
            retval = retval.andThen(collection.iterator());
        }
        return retval.toList();
    }

    public boolean listening() {
        return !this.listenerMap.isEmpty();
    }

    public void notifyAddArray(Graph g, Triple[] triples) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyAddArray(this.securedGraph, triples);
                continue;
            }
            sgl.notifyAddArray(g, triples);
        }
    }

    public void notifyAddGraph(Graph g, Graph added) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyAddGraph(this.securedGraph, added);
                continue;
            }
            sgl.notifyAddGraph(g, added);
        }
    }

    public void notifyAddIterator(Graph g, Iterator<Triple> it) throws AuthenticationRequiredException {
        this.notifyAddIterator(g, WrappedIterator.create(it).toList());
        this.baseGraph.equals(g);
    }

    public void notifyAddIterator(Graph g, List<Triple> triples) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyAddIterator(this.securedGraph, triples.iterator());
                continue;
            }
            sgl.notifyAddIterator(g, triples.iterator());
        }
    }

    public void notifyAddList(Graph g, List<Triple> triples) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyAddList(this.securedGraph, triples);
                continue;
            }
            sgl.notifyAddList(g, triples);
        }
    }

    public void notifyAddTriple(Graph g, Triple t) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyAddTriple(this.securedGraph, t);
                continue;
            }
            sgl.notifyAddTriple(g, t);
        }
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyDeleteArray(this.securedGraph, triples);
                continue;
            }
            sgl.notifyDeleteArray(g, triples);
        }
    }

    public void notifyDeleteGraph(Graph g, Graph removed) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyDeleteGraph(this.securedGraph, removed);
                continue;
            }
            sgl.notifyDeleteGraph(g, removed);
        }
    }

    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) throws AuthenticationRequiredException {
        this.notifyDeleteIterator(g, WrappedIterator.create(it).toList());
    }

    public void notifyDeleteIterator(Graph g, List<Triple> triples) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyDeleteIterator(this.securedGraph, triples.iterator());
                continue;
            }
            sgl.notifyDeleteIterator(g, triples.iterator());
        }
    }

    public void notifyDeleteList(Graph g, List<Triple> L) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyDeleteList(this.securedGraph, L);
                continue;
            }
            sgl.notifyDeleteList(g, L);
        }
    }

    public void notifyDeleteTriple(Graph g, Triple t) throws AuthenticationRequiredException {
        boolean wrap = this.baseGraph.equals(g);
        for (SecuredGraphListener sgl : this.getListenerCollection()) {
            if (wrap) {
                sgl.notifyDeleteTriple(this.securedGraph, t);
                continue;
            }
            sgl.notifyDeleteTriple(g, t);
        }
    }

    public void notifyEvent(Graph source, Object value) throws AuthenticationRequiredException {
        if (source instanceof SecuredGraph && this.securedGraph.equals(source)) {
            this.baseGraph.getEventManager().notifyEvent(this.baseGraph, value);
        } else {
            boolean wrap = this.baseGraph.equals(source);
            for (SecuredGraphListener sgl : this.getListenerCollection()) {
                if (wrap) {
                    sgl.notifyEvent(this.securedGraph, value);
                    continue;
                }
                sgl.notifyEvent(source, value);
            }
        }
    }

    public synchronized GraphEventManager register(GraphListener listener) {
        Deque<SecuredGraphListener> sgl = this.listenerMap.get(listener);
        if (sgl == null) {
            sgl = new ArrayDeque<SecuredGraphListener>();
        }
        sgl.push(new SecuredGraphListener(listener));
        this.listenerMap.put(listener, sgl);
        return this;
    }

    public synchronized GraphEventManager unregister(GraphListener listener) {
        Deque<SecuredGraphListener> sgl = this.listenerMap.get(listener);
        if (sgl != null) {
            if (sgl.size() == 1) {
                this.listenerMap.remove(listener);
            } else {
                sgl.pop();
                this.listenerMap.put(listener, sgl);
            }
        }
        return this;
    }

    static {
        ADD = new HashSet<SecurityEvaluator.Action>(Arrays.asList(SecurityEvaluator.Action.Create, SecurityEvaluator.Action.Read));
        DELETE = new HashSet<SecurityEvaluator.Action>(Arrays.asList(SecurityEvaluator.Action.Delete, SecurityEvaluator.Action.Read));
    }

    private class SecuredGraphListener
    implements GraphListener {
        private final GraphListener wrapped;
        private final Object runAs;

        SecuredGraphListener(GraphListener wrapped) {
            if (wrapped == null) {
                throw new IllegalArgumentException("Wrapped listener may not be null");
            }
            this.wrapped = wrapped;
            this.runAs = SecuredGraphEventManager.this.securedGraph.getSecurityEvaluator().getPrincipal();
        }

        private Triple[] getArray(Graph g, Triple[] triples, Set<SecurityEvaluator.Action> perms) throws AuthenticationRequiredException {
            Triple[] retval = triples;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                if (evaluator.evaluateAny(this.runAs, perms, sg.getModelNode())) {
                    if (!evaluator.evaluateAny(this.runAs, perms, sg.getModelNode(), Triple.ANY)) {
                        List list = this.wrapPermIterator(sg, Arrays.asList(triples).iterator(), perms).toList();
                        retval = list.toArray(new Triple[list.size()]);
                    } else {
                        retval = triples;
                    }
                } else {
                    retval = new Triple[]{};
                }
            }
            return retval;
        }

        public void notifyAddArray(Graph g, Triple[] triples) throws AuthenticationRequiredException {
            Triple[] added = this.getArray(g, triples, ADD);
            if (added.length > 0) {
                this.wrapped.notifyAddArray(g, added);
            }
        }

        public void notifyAddGraph(Graph g, Graph added) throws AuthenticationRequiredException {
            Graph addGraph = added;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                if (evaluator.evaluateAny(this.runAs, ADD, sg.getModelNode())) {
                    if (!evaluator.evaluateAny(this.runAs, ADD, sg.getModelNode(), Triple.ANY)) {
                        List lst = added.find(Triple.ANY).toList();
                        addGraph = new CollectionGraph(Arrays.asList(this.getArray(g, lst.toArray(new Triple[lst.size()]), ADD)));
                    } else {
                        addGraph = added;
                    }
                } else {
                    addGraph = new CollectionGraph(Collections.emptyList());
                }
            }
            if (addGraph.size() > 0) {
                this.wrapped.notifyAddGraph(g, addGraph);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyAddIterator(Graph g, Iterator<Triple> it) throws AuthenticationRequiredException {
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                if (evaluator.evaluateAny(this.runAs, ADD, sg.getModelNode())) {
                    try (ExtendedIterator<Triple> iter = this.wrapPermIterator(sg, it, ADD);){
                        this.wrapped.notifyAddIterator(g, iter);
                    }
                }
            } else {
                this.wrapped.notifyAddIterator(g, it);
            }
        }

        public void notifyAddList(Graph g, List<Triple> triples) throws AuthenticationRequiredException {
            List<Object> list = triples;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                list = evaluator.evaluateAny(this.runAs, ADD, sg.getModelNode()) ? (!evaluator.evaluateAny(this.runAs, ADD, sg.getModelNode(), Triple.ANY) ? this.wrapPermIterator(sg, triples.iterator(), ADD).toList() : triples) : Collections.emptyList();
            }
            if (list.size() > 0) {
                this.wrapped.notifyAddList(g, list);
            }
        }

        public void notifyAddTriple(Graph g, Triple t) throws AuthenticationRequiredException {
            boolean notify = false;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                notify = evaluator.evaluateAny(this.runAs, ADD, sg.getModelNode());
                if (notify) {
                    notify = evaluator.evaluateAny(this.runAs, ADD, sg.getModelNode(), t);
                }
            } else {
                notify = true;
            }
            if (notify) {
                this.wrapped.notifyAddTriple(g, t);
            }
        }

        public void notifyDeleteArray(Graph g, Triple[] triples) throws AuthenticationRequiredException {
            Triple[] deleted = triples;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                if (evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode())) {
                    if (!evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode(), Triple.ANY)) {
                        List list = this.wrapPermIterator(sg, Arrays.asList(triples).iterator(), DELETE).toList();
                        deleted = list.toArray(new Triple[list.size()]);
                    } else {
                        deleted = triples;
                    }
                } else {
                    deleted = new Triple[]{};
                }
            }
            if (deleted.length > 0) {
                this.wrapped.notifyDeleteArray(g, deleted);
            }
        }

        public void notifyDeleteGraph(Graph g, Graph removed) throws AuthenticationRequiredException {
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                if (evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode())) {
                    Graph g2 = removed;
                    if (!evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode(), Triple.ANY)) {
                        g2 = new CollectionGraph((Collection)removed.find(Triple.ANY).filterKeep((Predicate)new PermTripleFilter(DELETE, (SecuredItem)sg, (SecurityEvaluator)evaluator)).toList());
                    }
                    this.wrapped.notifyDeleteGraph(g, g2);
                }
            } else {
                this.wrapped.notifyDeleteGraph(g, removed);
            }
        }

        public void notifyDeleteIterator(Graph g, Iterator<Triple> it) throws AuthenticationRequiredException {
            ExtendedIterator iter = it;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                if (evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode())) {
                    if (!evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode(), Triple.ANY)) {
                        iter = WrappedIterator.create(it).filterKeep((Predicate)new PermTripleFilter(DELETE, (SecuredItem)sg, (SecurityEvaluator)evaluator));
                    }
                    this.wrapped.notifyDeleteIterator(g, iter);
                }
            } else {
                this.wrapped.notifyDeleteIterator(g, iter);
            }
        }

        public void notifyDeleteList(Graph g, List<Triple> triples) throws AuthenticationRequiredException {
            List list = triples;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                if (evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode())) {
                    if (!evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode(), Triple.ANY)) {
                        list = WrappedIterator.create(triples.iterator()).filterKeep((Predicate)new PermTripleFilter(DELETE, (SecuredItem)sg, (SecurityEvaluator)evaluator)).toList();
                    }
                } else {
                    list = Collections.emptyList();
                }
            }
            if (list.size() > 0) {
                this.wrapped.notifyDeleteList(g, list);
            }
        }

        public void notifyDeleteTriple(Graph g, Triple t) throws AuthenticationRequiredException {
            boolean notify = false;
            if (g instanceof SecuredGraph) {
                SecuredGraph sg = (SecuredGraph)g;
                CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
                notify = evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode());
                if (notify) {
                    notify = evaluator.evaluateAny(this.runAs, DELETE, sg.getModelNode(), t);
                }
            } else {
                notify = true;
            }
            if (notify) {
                this.wrapped.notifyDeleteTriple(g, t);
            }
        }

        public void notifyEvent(Graph source, Object value) {
            this.wrapped.notifyEvent(source, value);
        }

        private ExtendedIterator<Triple> wrapPermIterator(SecuredGraph sg, Iterator<Triple> it, Set<SecurityEvaluator.Action> perms) throws AuthenticationRequiredException {
            CachedSecurityEvaluator evaluator = new CachedSecurityEvaluator(sg.getSecurityEvaluator(), this.runAs);
            if (!evaluator.evaluateAny(this.runAs, perms, sg.getModelNode(), Triple.ANY)) {
                return WrappedIterator.create(it).filterKeep((Predicate)new PermTripleFilter(perms, (SecuredItem)sg, (SecurityEvaluator)evaluator));
            }
            return WrappedIterator.create(it);
        }
    }
}

