/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.graph;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.permissions.SecurityEvaluator;

public class SecuredCapabilities
implements Capabilities {
    private final SecurityEvaluator securityEvaluator;
    private final Node graphIRI;
    private final Capabilities capabilities;

    public SecuredCapabilities(SecurityEvaluator securityEvaluator, String graphURI, Capabilities capabilities) {
        this.securityEvaluator = securityEvaluator;
        this.graphIRI = NodeFactory.createURI((String)graphURI);
        this.capabilities = capabilities;
    }

    public boolean addAllowed() {
        return this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Update, this.graphIRI) && this.capabilities.addAllowed();
    }

    public boolean deleteAllowed() {
        return this.securityEvaluator.evaluate(this.securityEvaluator.getPrincipal(), SecurityEvaluator.Action.Update, this.graphIRI) && this.capabilities.deleteAllowed();
    }

    public boolean handlesLiteralTyping() {
        return this.capabilities.handlesLiteralTyping();
    }

    public boolean sizeAccurate() {
        return this.capabilities.sizeAccurate();
    }
}

