/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.example;

import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroExampleEvaluator
implements SecurityEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroExampleEvaluator.class);
    private Model model;
    private RDFNode msgType = ResourceFactory.createResource((String)"http://example.com/msg");
    private Property pTo = ResourceFactory.createProperty((String)"http://example.com/to");
    private Property pFrom = ResourceFactory.createProperty((String)"http://example.com/from");

    public ShiroExampleEvaluator(Model model) {
        this.model = model;
    }

    @Override
    public boolean evaluate(Object principal, SecurityEvaluator.Action action, Node graphIRI) {
        return true;
    }

    private boolean evaluate(Object principalObj, Resource r) {
        Subject subject = (Subject)principalObj;
        if (!subject.isAuthenticated()) {
            LOG.info("User not authenticated");
            return false;
        }
        LOG.debug("checking {}", subject.getPrincipal());
        Object principal = subject.getPrincipal();
        if ("admin".equals(principal.toString())) {
            return true;
        }
        if (r.hasProperty(RDF.type, this.msgType)) {
            return r.hasProperty(this.pTo, subject.getPrincipal().toString()) || r.hasProperty(this.pFrom, subject.getPrincipal().toString());
        }
        return true;
    }

    private boolean evaluate(Object principal, Node node) {
        if (node.equals((Object)Node.ANY)) {
            return false;
        }
        if (node.isURI() || node.isBlank()) {
            Resource r = this.model.getRDFNode(node).asResource();
            return this.evaluate(principal, r);
        }
        return true;
    }

    private boolean evaluate(Object principal, Triple triple) {
        return this.evaluate(principal, triple.getSubject()) && this.evaluate(principal, triple.getObject()) && this.evaluate(principal, triple.getPredicate());
    }

    @Override
    public boolean evaluate(Object principal, SecurityEvaluator.Action action, Node graphIRI, Triple triple) {
        return this.evaluate(principal, triple);
    }

    @Override
    public boolean evaluate(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI) {
        return true;
    }

    @Override
    public boolean evaluate(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI, Triple triple) {
        return this.evaluate(principal, triple);
    }

    @Override
    public boolean evaluateAny(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI) {
        return true;
    }

    @Override
    public boolean evaluateAny(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI, Triple triple) {
        return this.evaluate(principal, triple);
    }

    @Override
    public boolean evaluateUpdate(Object principal, Node graphIRI, Triple from, Triple to) {
        return this.evaluate(principal, from) && this.evaluate(principal, to);
    }

    @Override
    public Object getPrincipal() {
        return SecurityUtils.getSubject();
    }

    @Override
    public boolean isPrincipalAuthenticated(Object principal) {
        if (principal instanceof Subject) {
            return ((Subject)principal).isAuthenticated();
        }
        return false;
    }
}

