/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions.example;

import java.security.Principal;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.AuthenticationRequiredException;
import org.apache.jena.vocabulary.RDF;

public class ExampleEvaluator
implements SecurityEvaluator {
    private Principal principal;
    private Model model;
    private RDFNode msgType = ResourceFactory.createResource((String)"http://example.com/msg");
    private Property pTo = ResourceFactory.createProperty((String)"http://example.com/to");
    private Property pFrom = ResourceFactory.createProperty((String)"http://example.com/from");

    public ExampleEvaluator(Model model) {
        this.model = model;
    }

    @Override
    public boolean evaluate(Object principal, SecurityEvaluator.Action action, Node graphIRI) {
        return true;
    }

    private boolean evaluate(Object principalObj, Resource r) {
        Principal principal = (Principal)principalObj;
        if (principal == null) {
            throw new AuthenticationRequiredException();
        }
        if (r.hasProperty(RDF.type, this.msgType)) {
            return r.hasProperty(this.pTo, principal.getName()) || r.hasProperty(this.pFrom, principal.getName());
        }
        return true;
    }

    private boolean evaluate(Object principal, Node node) {
        if (node.equals((Object)Node.ANY)) {
            return false;
        }
        if (node.isURI() || node.isBlank()) {
            Resource r = this.model.getRDFNode(node).asResource();
            return this.evaluate(principal, r);
        }
        return true;
    }

    private boolean evaluate(Object principal, Triple triple) {
        return this.evaluate(principal, triple.getSubject()) && this.evaluate(principal, triple.getObject()) && this.evaluate(principal, triple.getPredicate());
    }

    @Override
    public boolean evaluate(Object principal, SecurityEvaluator.Action action, Node graphIRI, Triple triple) {
        return this.evaluate(principal, triple);
    }

    @Override
    public boolean evaluate(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI) {
        return true;
    }

    @Override
    public boolean evaluate(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI, Triple triple) {
        return this.evaluate(principal, triple);
    }

    @Override
    public boolean evaluateAny(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI) {
        return true;
    }

    @Override
    public boolean evaluateAny(Object principal, Set<SecurityEvaluator.Action> actions, Node graphIRI, Triple triple) {
        return this.evaluate(principal, triple);
    }

    @Override
    public boolean evaluateUpdate(Object principal, Node graphIRI, Triple from, Triple to) {
        return this.evaluate(principal, from) && this.evaluate(principal, to);
    }

    public void setPrincipal(final String userName) {
        if (userName == null) {
            this.principal = null;
        }
        this.principal = new Principal(){

            @Override
            public String getName() {
                return userName;
            }
        };
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isPrincipalAuthenticated(Object principal) {
        return principal != null;
    }
}

