/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.permissions.AssemblerConstants;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;

public class SecurityEvaluatorAssembler
extends AssemblerBase
implements Assembler,
AssemblerConstants {
    public SecurityEvaluator open(Assembler a, Resource root, Mode mode) {
        Class<?> clazz;
        Literal className = SecurityEvaluatorAssembler.getUniqueLiteral((Resource)root, (Property)EVALUATOR_CLASS);
        if (className == null) {
            throw new AssemblerException(root, String.format("No %s provided for %s", EVALUATOR_CLASS, root));
        }
        try {
            clazz = Class.forName(className.getString());
        }
        catch (ClassNotFoundException e1) {
            throw new AssemblerException(root, String.format("Can not locate class %s as specified by %s in %s", className, EVALUATOR_CLASS, root));
        }
        if (!SecurityEvaluator.class.isAssignableFrom(clazz)) {
            throw new AssemblerException(root, String.format("Class %s as specified by %s in %s does not implement SecurityEvaluator", className, EVALUATOR_CLASS, root));
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Resource argRes = SecurityEvaluatorAssembler.getUniqueResource((Resource)root, (Property)ARGUMENT_LIST);
        if (argRes != null) {
            Seq seq = (Seq)argRes.as(Seq.class);
            NodeIterator iter = seq.iterator();
            RDFNode n = null;
            while (iter.hasNext()) {
                n = iter.next();
                if (n.isLiteral()) {
                    args.add(n.asLiteral().getValue());
                    continue;
                }
                if (n.isResource()) {
                    args.add(a.open(a, n.asResource(), mode));
                    continue;
                }
                throw new AssemblerException(root, String.format("%s must be a literal or a resource", n));
            }
        }
        for (Constructor<?> c : clazz.getConstructors()) {
            if (c.getParameterTypes().length != args.size()) continue;
            try {
                if (args.size() == 0) {
                    return (SecurityEvaluator)c.newInstance(new Object[0]);
                }
                return (SecurityEvaluator)c.newInstance(args.toArray());
            }
            catch (InstantiationException e) {
                throw new AssemblerException(root, e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new AssemblerException(root, e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new AssemblerException(root, e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AssemblerException(root, e.getMessage(), (Throwable)e);
            }
        }
        throw new AssemblerException(root, String.format("Class %s does not have a %s argument constructor", className, args.size()));
    }
}

