/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AuthenticationRequiredException;

public interface SecurityEvaluator {
    public static final Node VARIABLE = NodeFactory.createBlankNode((String)"urn:jena-permissions:VARIABLE");
    public static final Node FUTURE = NodeFactory.createBlankNode((String)"urn:jena-permissions:FUTURE");

    public boolean evaluate(Object var1, Action var2, Node var3) throws AuthenticationRequiredException;

    public boolean evaluate(Object var1, Action var2, Node var3, Triple var4) throws AuthenticationRequiredException;

    default public boolean evaluate(Object principal, Set<Action> actions, Node graphIRI) throws AuthenticationRequiredException {
        return actions.stream().allMatch(action -> this.evaluate(principal, (Action)((Object)action), graphIRI));
    }

    default public boolean evaluate(Object principal, Set<Action> actions, Node graphIRI, Triple triple) throws AuthenticationRequiredException {
        return actions.stream().allMatch(action -> this.evaluate(principal, (Action)((Object)action), graphIRI));
    }

    default public boolean evaluateAny(Object principal, Set<Action> actions, Node graphIRI) throws AuthenticationRequiredException {
        return actions.stream().anyMatch(action -> this.evaluate(principal, (Action)((Object)action), graphIRI));
    }

    default public boolean evaluateAny(Object principal, Set<Action> actions, Node graphIRI, Triple triple) throws AuthenticationRequiredException {
        return actions.stream().anyMatch(action -> this.evaluate(principal, (Action)((Object)action), graphIRI, triple));
    }

    default public boolean evaluateUpdate(Object principal, Node graphIRI, Triple from, Triple to) throws AuthenticationRequiredException {
        return this.evaluate(principal, Action.Delete, graphIRI, from) && this.evaluate(principal, Action.Create, graphIRI, to);
    }

    public Object getPrincipal();

    public boolean isPrincipalAuthenticated(Object var1);

    default public boolean isHardReadError() {
        return false;
    }

    public static enum Action {
        Create,
        Read,
        Update,
        Delete;

    }

    public static class Util {
        public static Set<Action> asSet(Action[] actions) {
            return Util.asSet(Arrays.asList(actions));
        }

        public static Set<Action> asSet(Collection<Action> actions) {
            if (actions instanceof Set) {
                return (Set)actions;
            }
            return new LinkedHashSet<Action>(actions);
        }
    }
}

