/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions;

import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.shared.AuthenticationRequiredException;

public interface SecuredItem {
    public boolean canCreate() throws AuthenticationRequiredException;

    public boolean canCreate(Triple var1) throws AuthenticationRequiredException;

    public boolean canCreate(FrontsTriple var1) throws AuthenticationRequiredException;

    public boolean canDelete() throws AuthenticationRequiredException;

    public boolean canDelete(Triple var1) throws AuthenticationRequiredException;

    public boolean canDelete(FrontsTriple var1) throws AuthenticationRequiredException;

    public boolean canRead() throws AuthenticationRequiredException;

    public boolean canRead(Triple var1) throws AuthenticationRequiredException;

    public boolean canRead(FrontsTriple var1) throws AuthenticationRequiredException;

    public boolean canUpdate() throws AuthenticationRequiredException;

    public boolean canUpdate(Triple var1, Triple var2) throws AuthenticationRequiredException;

    public boolean canUpdate(FrontsTriple var1, FrontsTriple var2) throws AuthenticationRequiredException;

    public boolean equals(Object var1);

    public Object getBaseItem();

    public String getModelIRI();

    public Node getModelNode();

    public SecurityEvaluator getSecurityEvaluator();

    public boolean isEquivalent(SecuredItem var1);

    public static class Util {
        public static boolean isEquivalent(SecuredItem si1, SecuredItem si2) {
            return si1.getSecurityEvaluator().equals(si2.getSecurityEvaluator()) && si1.getModelIRI().equals(si2.getModelIRI());
        }

        public static String modelPermissionMsg(Node modelURI) {
            return String.format("Model permissions violation: %s", modelURI);
        }

        public static String triplePermissionMsg(Node modelURI) {
            return String.format("Triple permissions violation: %s", modelURI);
        }
    }
}

