/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.permissions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.assembler.assemblers.ModelAssembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.permissions.AssemblerConstants;
import org.apache.jena.permissions.Factory;
import org.apache.jena.permissions.SecurityEvaluator;
import org.apache.jena.permissions.SecurityEvaluatorAssembler;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.MappingRegistry;

public class SecuredAssembler
extends ModelAssembler
implements AssemblerConstants {
    private static boolean initialized;
    private static final String ERROR_FINDING_FACTORY = "Error finding factory class %s:  %s";

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        MappingRegistry.addPrefixMapping((String)"sec", (String)"http://apache.org/jena/permissions/Assembler#");
        SecuredAssembler.registerWith(Assembler.general());
        initialized = true;
    }

    static void registerWith(AssemblerGroup group) {
        if (group == null) {
            group = Assembler.general();
        }
        group.implementWith((Resource)SECURED_MODEL, (Assembler)new SecuredAssembler());
        group.implementWith((Resource)EVALUATOR_ASSEMBLER, (Assembler)new SecurityEvaluatorAssembler());
    }

    public Model open(Assembler a, Resource root, Mode mode) {
        Resource rootModel = SecuredAssembler.getUniqueResource((Resource)root, (Property)BASE_MODEL);
        if (rootModel == null) {
            throw new AssemblerException(root, String.format("No %s provided for %s", BASE_MODEL, root));
        }
        Model baseModel = a.openModel(rootModel, Mode.ANY);
        Literal modelName = SecuredAssembler.getUniqueLiteral((Resource)root, (Property)JA.modelName);
        if (modelName == null) {
            throw new AssemblerException(root, String.format("No %s provided for %s", JA.modelName, root));
        }
        Literal factoryName = SecuredAssembler.getUniqueLiteral((Resource)root, (Property)EVALUATOR_FACTORY);
        Resource evaluatorImpl = SecuredAssembler.getUniqueResource((Resource)root, (Property)EVALUATOR_IMPL);
        if (factoryName == null && evaluatorImpl == null) {
            throw new AssemblerException(root, String.format("Either a %s or a %s must be provided for %s", EVALUATOR_FACTORY, EVALUATOR_IMPL, root));
        }
        if (factoryName != null && evaluatorImpl != null) {
            throw new AssemblerException(root, String.format("May not specify both a %s and a %s for %s", EVALUATOR_FACTORY, EVALUATOR_IMPL, root));
        }
        SecurityEvaluator securityEvaluator = null;
        if (factoryName != null) {
            securityEvaluator = this.executeEvaluatorFactory(root, factoryName);
        }
        if (evaluatorImpl != null) {
            securityEvaluator = this.getEvaluatorImpl(a, evaluatorImpl);
        }
        return Factory.getInstance(securityEvaluator, modelName.asLiteral().getString(), baseModel);
    }

    protected Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        return this.open(a, root, mode);
    }

    private SecurityEvaluator executeEvaluatorFactory(Resource root, Literal factoryName) {
        try {
            Class<?> factoryClass = Class.forName(factoryName.getString());
            Method method = factoryClass.getMethod("getInstance", new Class[0]);
            if (!SecurityEvaluator.class.isAssignableFrom(method.getReturnType())) {
                throw new AssemblerException(root, String.format("%s (found at %s for %s) getInstance() must return an instance of SecurityEvaluator", factoryName, EVALUATOR_FACTORY, root));
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new AssemblerException(root, String.format("%s (found at %s for %s) getInstance() must be a static method", factoryName, EVALUATOR_FACTORY, root));
            }
            return (SecurityEvaluator)method.invoke(null, new Object[0]);
        }
        catch (SecurityException e) {
            throw new AssemblerException(root, String.format(ERROR_FINDING_FACTORY, factoryName, e.getMessage()), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssemblerException(root, String.format(ERROR_FINDING_FACTORY, factoryName, e.getMessage()), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssemblerException(root, String.format("Class %s (found at %s for %s) could not be loaded", factoryName, EVALUATOR_FACTORY, root));
        }
        catch (NoSuchMethodException e) {
            throw new AssemblerException(root, String.format("%s (found at %s for %s) must implement a static getInstance() that returns an instance of SecurityEvaluator", factoryName, EVALUATOR_FACTORY, root));
        }
        catch (IllegalAccessException e) {
            throw new AssemblerException(root, String.format(ERROR_FINDING_FACTORY, factoryName, e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AssemblerException(root, String.format(ERROR_FINDING_FACTORY, factoryName, e.getMessage()), (Throwable)e);
        }
    }

    private SecurityEvaluator getEvaluatorImpl(Assembler a, Resource evaluatorImpl) {
        Object obj = a.open(a, evaluatorImpl, Mode.ANY);
        if (obj instanceof SecurityEvaluator) {
            return (SecurityEvaluator)obj;
        }
        throw new AssemblerException(evaluatorImpl, String.format("%s does not specify a SecurityEvaluator instance", evaluatorImpl));
    }

    static {
        SecuredAssembler.init();
    }
}

