/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.common.ResourceVocabulary;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

abstract class ResourceVocabularyImpl<T extends Resource>
implements ResourceVocabulary<T> {
    private final Map<Class<? extends T>, Set<Node>> map;

    ResourceVocabularyImpl(Map<Class<? extends T>, Set<Node>> map) {
        this.map = Objects.requireNonNull(map);
    }

    @Override
    public Set<Node> get(Class<? extends T> key) throws OntJenaException {
        return this.map.getOrDefault(OntJenaException.notNull(key, "Null key"), Set.of());
    }

    @Override
    public boolean supports(Class<? extends T> type) {
        return this.map.containsKey(type);
    }

    static class ReservedIml
    extends ResourceVocabularyImpl<Resource>
    implements OntPersonality.Reserved {
        private final Map<String, Set<Node>> nodes = new HashMap<String, Set<Node>>();
        private final Set<Node> resources;
        private final Set<Node> properties = this.get(Property.class);
        private final Set<Node> allResources;

        ReservedIml(Map<Class<? extends Resource>, Set<Node>> map) {
            super(map);
            this.resources = this.get(Resource.class);
            this.allResources = Stream.of(this.properties, this.resources).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        }

        @Override
        public Set<Node> getResources() {
            return this.resources;
        }

        @Override
        public Set<Node> getProperties() {
            return this.properties;
        }

        @Override
        public Set<Node> getAllResources() {
            return this.allResources;
        }
    }

    static abstract class EntitiesImpl
    extends ResourceVocabularyImpl<OntObject> {
        final Set<Node> classes = this.get(OntClass.Named.class);
        final Set<Node> datatypes = this.get(OntDataRange.Named.class);
        final Set<Node> objectProperties;
        final Set<Node> datatypeProperties;
        final Set<Node> annotationProperties;
        final Set<Node> ontProperties;
        final Set<Node> individuals = this.get(OntIndividual.Named.class);

        EntitiesImpl(Map<Class<? extends OntObject>, Set<Node>> map) {
            super(map);
            this.objectProperties = this.get(OntObjectProperty.Named.class);
            this.datatypeProperties = this.get(OntDataProperty.class);
            this.annotationProperties = this.get(OntAnnotationProperty.class);
            this.ontProperties = this.collect(OntObjectProperty.Named.class, OntDataProperty.class, OntAnnotationProperty.class);
        }

        public Set<Node> getNamedClasses() {
            return this.classes;
        }

        public Set<Node> getDatatypes() {
            return this.datatypes;
        }

        public Set<Node> getObjectProperties() {
            return this.objectProperties;
        }

        public Set<Node> getDatatypeProperties() {
            return this.datatypeProperties;
        }

        public Set<Node> getAnnotationProperties() {
            return this.annotationProperties;
        }

        public Set<Node> getNamedIndividuals() {
            return this.individuals;
        }

        public Set<Node> getOntProperties() {
            return this.ontProperties;
        }

        @SafeVarargs
        private Set<Node> collect(Class<? extends OntObject> ... types) {
            return Arrays.stream(types).map(this::get).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        }
    }

    static class PunningsImpl
    extends EntitiesImpl
    implements OntPersonality.Punnings {
        PunningsImpl(Map<Class<? extends OntObject>, Set<Node>> map) {
            super(map);
        }
    }

    static class BuiltinsImpl
    extends EntitiesImpl
    implements OntPersonality.Builtins {
        BuiltinsImpl(Map<Class<? extends OntObject>, Set<Node>> map) {
            super(map);
        }
    }
}

